
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


class SetBotCallbackAnswer(TLRequest[bool]):
    """
    Set the callback answer to a user button press (bots only)

    **Bots can use this method**

    Raises:
        `400`MessageTooLongError: The provided message is too long.
        `400`QueryIdInvalidError: The query ID is invalid.
        `400`UrlInvalidError: Invalid URL provided.
        `400`UserBotRequiredError: This method can only be called by a bot.

    """

    _id = 0XD58F130A
    _result_id = 0X43B904E1

    def __init__(
        self,
        query_id: int,
        cache_time: int,
        alert: bool = False,
        message: Optional[str] = None,
        url: Optional[str] = None
    ):

        """
        Set the callback answer to a user button press (bots only)

        **Bots can use this method**

        Args:
            query_id (int): Query ID
            cache_time (int): Cache validity
            alert (bool, optional): Whether to show the message as a popup instead of a toast notification
            message (Optional[str], optional): Popup to show
            url (Optional[str], optional): URL to open
        """

        self.query_id = query_id
        self.cache_time = cache_time
        self.alert = alert
        self.message = message
        self.url = url

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\n\x13\x8f\xd5' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.alert, 1)
                writer.long(self.query_id)

                if flags(self.message, 0):
                    writer.string(self.message)

                if flags(self.url, 2):
                    writer.string(self.url)
                writer.int(self.cache_time)

            return writer.getvalue()