
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class UpdatePinnedMessage(TLRequest[TypeUpdates]):
    """
    Pin a message

    **Bots can use this method**

    Raises:
        `400`BotOnesideNotAvailError: Bots can't pin messages in PM just for themselves.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`ChatNotModifiedError: No changes were made to chat information because the new information you passed is identical to the current information.
        `400`MessageIdInvalidError: The provided message id is invalid.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`PinRestrictedError: You can't pin messages.
        `400`UserBannedInChannelError: You're banned from sending messages in supergroups/channels.
        `403`ChatWriteForbiddenError: You can't write in this chat.

    """

    _id = 0XD2AAF7EC
    _result_id = 0XD68D29C0

    def __init__(
        self,
        peer: 'TypeInputPeer',
        id: int,
        silent: bool = False,
        unpin: bool = False,
        pm_oneside: bool = False
    ):

        """
        Pin a message

        **Bots can use this method**

        Args:
            peer ('TypeInputPeer'): The peer where to pin the message
            id (int): The message to pin or unpin
            silent (bool, optional): Pin the message silently, without triggering a notification
            unpin (bool, optional): Whether the message should unpinned or pinned
            pm_oneside (bool, optional): Whether the message should only be pinned on the local side of a one-to-one chat
        """

        self.peer = peer
        self.id = id
        self.silent = silent
        self.unpin = unpin
        self.pm_oneside = pm_oneside

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xec\xf7\xaa\xd2' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.silent, 0)
                flags(self.unpin, 1)
                flags(self.pm_oneside, 2)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.int(self.id)

            return writer.getvalue()