
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.payments.stars_status import TypePaymentsStarsStatus


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class GetStarsSubscriptions(TLRequest[TypePaymentsStarsStatus]):
    """
    Obtain a list of active, expired or cancelled [Telegram Star subscriptions](https://core.telegram.org/api/invites#paid-invite-links).

    Raises:
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0X32512C5
    _result_id = 0XC88B272F

    def __init__(
        self,
        peer: 'TypeInputPeer',
        offset: str,
        missing_balance: bool = False
    ):

        """
        Obtain a list of active, expired or cancelled [Telegram Star subscriptions](https://core.telegram.org/api/invites#paid-invite-links).

        Args:
            peer ('TypeInputPeer'): Always pass [inputPeerSelf](https://core.telegram.org/constructor/inputPeerSelf).
            offset (str): Offset for pagination, taken from [payments.starsStatus](https://core.telegram.org/constructor/payments.starsStatus). subscriptions_next_offset.
            missing_balance (bool, optional): Whether to return only subscriptions expired due to an excessively low Telegram Star balance.
        """

        self.peer = peer
        self.offset = offset
        self.missing_balance = missing_balance

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc5\x12%\x03' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.missing_balance, 0)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.string(self.offset)

            return writer.getvalue()