
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.payments.payment_result import TypePaymentsPaymentResult


if TYPE_CHECKING:
    from ...types.input_invoice import TypeInputInvoice
    from ...types.input_payment_credentials import TypeInputPaymentCredentials


class SendPaymentForm(TLRequest[TypePaymentsPaymentResult]):
    """
    Send compiled payment form

    Raises:
        `400`MessageIdInvalidError: The provided message id is invalid.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`TmpPasswordInvalidError: The passed tmp_password is invalid.

    """

    _id = 0X2D03522F
    _result_id = 0XBC945A3D

    def __init__(
        self,
        form_id: int,
        invoice: 'TypeInputInvoice',
        credentials: 'TypeInputPaymentCredentials',
        requested_info_id: Optional[str] = None,
        shipping_option_id: Optional[str] = None,
        tip_amount: Optional[int] = None
    ):

        """
        Send compiled payment form

        Args:
            form_id (int): Form ID
            invoice ('TypeInputInvoice'): Invoice
            credentials ('TypeInputPaymentCredentials'): Payment credentials
            requested_info_id (Optional[str], optional): ID of saved and validated [order info](https://core.telegram.org/constructor/payments.validatedRequestedInfo)
            shipping_option_id (Optional[str], optional): Chosen shipping option ID
            tip_amount (Optional[int], optional): Tip, in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
        """

        self.form_id = form_id
        self.invoice = invoice
        self.credentials = credentials
        self.requested_info_id = requested_info_id
        self.shipping_option_id = shipping_option_id
        self.tip_amount = tip_amount

    def to_bytes(self, boxed: bool=True):
        with Writer(b'/R\x03-' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.form_id)
                writer.object(
                    self.invoice,
                    group_id=0X70F585EC
                )

                if flags(self.requested_info_id, 0):
                    writer.string(self.requested_info_id)

                if flags(self.shipping_option_id, 1):
                    writer.string(self.shipping_option_id)
                writer.object(
                    self.credentials,
                    group_id=0XED81B2F2
                )

                if flags(self.tip_amount, 2):
                    writer.long(self.tip_amount)

            return writer.getvalue()