
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.premium.boosts_list import TypePremiumBoostsList


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class GetBoostsList(TLRequest[TypePremiumBoostsList]):
    """
    Obtains info about the boosts that were applied to a certain channel or supergroup (admins only)

    Raises:
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0X60F67660
    _result_id = 0X70580F5F

    def __init__(
        self,
        peer: 'TypeInputPeer',
        offset: str,
        limit: int,
        gifts: bool = False
    ):

        """
        Obtains info about the boosts that were applied to a certain channel or supergroup (admins only)

        Args:
            peer ('TypeInputPeer'): The channel/supergroup
            offset (str): Offset for pagination, obtained from [premium.boostsList](https://core.telegram.org/constructor/premium.boostsList). next_offset
            limit (int): Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
            gifts (bool, optional): Whether to return only info about boosts received from [gift codes and giveaways created by the channel/supergroup](https://core.telegram.org/api/giveaways)
        """

        self.peer = peer
        self.offset = offset
        self.limit = limit
        self.gifts = gifts

    def to_bytes(self, boxed: bool=True):
        with Writer(b'`v\xf6`' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.gifts, 0)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.string(self.offset)
                writer.int(self.limit)

            return writer.getvalue()