
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.stats.public_forwards import TypeStatsPublicForwards


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class GetStoryPublicForwards(TLRequest[TypeStatsPublicForwards]):
    """
    Obtain forwards of a [story](https://core.telegram.org/api/stories) as a message to public chats and reposts by public channels.

    Raises:
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0XA6437EF6
    _result_id = 0X1DAE9D9D

    def __init__(
        self,
        peer: 'TypeInputPeer',
        id: int,
        offset: str,
        limit: int
    ):

        """
        Obtain forwards of a [story](https://core.telegram.org/api/stories) as a message to public chats and reposts by public channels.

        Args:
            peer ('TypeInputPeer'): Peer where the story was originally posted
            id (int): [Story](https://core.telegram.org/api/stories) ID
            offset (str): Offset for pagination, from [stats.PublicForwards](https://core.telegram.org/constructor/stats.publicForwards). next_offset.
            limit (int): Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
        """

        self.peer = peer
        self.id = id
        self.offset = offset
        self.limit = limit

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf6~C\xa6' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X995DB9DF
            )
            writer.int(self.id)
            writer.string(self.offset)
            writer.int(self.limit)

            return writer.getvalue()