
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.report_result import TypeReportResult


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class Report(TLRequest[TypeReportResult]):
    """
    Report a story.

    Raises:
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0X19D8EB45
    _result_id = 0XAE48EA2A

    def __init__(
        self,
        peer: 'TypeInputPeer',
        id: List[int],
        option: bytes,
        message: str
    ):

        """
        Report a story.

        Args:
            peer ('TypeInputPeer'): The peer that uploaded the story.
            id (List[int]): IDs of the stories to report.
            option (bytes): Menu option, intially empty
            message (str): Comment for report moderation
        """

        self.peer = peer
        self.id = id
        self.option = option
        self.message = message

    def to_bytes(self, boxed: bool=True):
        with Writer(b'E\xeb\xd8\x19' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X995DB9DF
            )
            writer.vector(
                self.id,
                writer.int
            )
            writer.bytes(self.option)
            writer.string(self.message)

            return writer.getvalue()