
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.reaction import TypeReaction
    from ...types.input_peer import TypeInputPeer


class SendReaction(TLRequest[TypeUpdates]):
    """
    React to a story.

    Raises:
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`ReactionInvalidError: The specified reaction is invalid.
        `400`StoryIdEmptyError: You specified no story IDs.
        `400`StoryIdInvalidError: The specified story ID is invalid.

    """

    _id = 0X7FD736B2
    _result_id = 0XD68D29C0

    def __init__(
        self,
        peer: 'TypeInputPeer',
        story_id: int,
        reaction: 'TypeReaction',
        add_to_recent: bool = False
    ):

        """
        React to a story.

        Args:
            peer ('TypeInputPeer'): The peer that sent the story
            story_id (int): ID of the story to react to
            reaction ('TypeReaction'): Reaction
            add_to_recent (bool, optional): Whether to add this reaction to the [recent reactions list](https://core.telegram.org/api/reactions#recent-reactions).
        """

        self.peer = peer
        self.story_id = story_id
        self.reaction = reaction
        self.add_to_recent = add_to_recent

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb26\xd7\x7f' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.add_to_recent, 0)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.int(self.story_id)
                writer.object(
                    self.reaction,
                    group_id=0X19F930D1
                )

            return writer.getvalue()