
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.updates.difference import TypeUpdatesDifference


class GetDifference(TLRequest[TypeUpdatesDifference]):
    """
    Get new [updates](https://core.telegram.org/api/updates).

    **Bots can use this method**

    Raises:
        `400`CdnMethodInvalidError: You can't call this method in a CDN DC.
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`DateEmptyError: Date empty.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PersistentTimestampEmptyError: Persistent timestamp empty.
        `400`PersistentTimestampInvalidError: Persistent timestamp invalid.
        `400`UsernameInvalidError: The provided username is not valid.
        `400`UserNotParticipantError: You're not a member of this supergroup/channel.
        `403`ChatWriteForbiddenError: You can't write in this chat.
        `500`RandomIdDuplicateError: You provided a random ID that was already used.

    """

    _id = 0X19C2F763
    _result_id = 0XCAABD573

    def __init__(
        self,
        pts: int,
        date: int,
        qts: int,
        pts_limit: Optional[int] = None,
        pts_total_limit: Optional[int] = None,
        qts_limit: Optional[int] = None
    ):

        """
        Get new [updates](https://core.telegram.org/api/updates).

        **Bots can use this method**

        Args:
            pts (int): PTS, see [updates](https://core.telegram.org/api/updates).
            date (int): date, see [updates](https://core.telegram.org/api/updates).
            qts (int): QTS, see [updates](https://core.telegram.org/api/updates).
            pts_limit (Optional[int], optional): PTS limit
            pts_total_limit (Optional[int], optional): For fast updating: if provided and pts + pts_total_limit < remote pts, [updates.differenceTooLong](https://core.telegram.org/constructor/updates.differenceTooLong) will be returned. Simply tells the server to not return the difference if it is bigger than pts_total_limit If the remote pts is too big (> ~4000000), this field will default to 1000000
            qts_limit (Optional[int], optional): QTS limit
        """

        self.pts = pts
        self.date = date
        self.qts = qts
        self.pts_limit = pts_limit
        self.pts_total_limit = pts_total_limit
        self.qts_limit = qts_limit

    def to_bytes(self, boxed: bool=True):
        with Writer(b'c\xf7\xc2\x19' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.int(self.pts)

                if flags(self.pts_limit, 1):
                    writer.int(self.pts_limit)

                if flags(self.pts_total_limit, 0):
                    writer.int(self.pts_total_limit)
                writer.int(self.date)
                writer.int(self.qts)

                if flags(self.qts_limit, 2):
                    writer.int(self.qts_limit)

            return writer.getvalue()