
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


class SaveBigFilePart(TLRequest[bool]):
    """
    Saves a part of a large file (over 10 MB in size) to be later passed to one of the methods.

    **Bots can use this method**

    Raises:
        `400`FilePartsInvalidError: The number of file parts is invalid.
        `400`FilePartEmptyError: The provided file part is empty.
        `400`FilePartInvalidError: The file part number is invalid.
        `400`FilePartSizeChangedError: Provided file part size has changed.
        `400`FilePartSizeInvalidError: The provided file part size is invalid.
        `400`FilePartTooBigError: The uploaded file part is too big.
        `400`FilePartTooSmallError: The size of the uploaded file part is too small, please see the documentation for the allowed sizes.

    """

    _id = 0XDE7B673D
    _result_id = 0X43B904E1

    def __init__(
        self,
        file_id: int,
        file_part: int,
        file_total_parts: int,
        bytes: bytes
    ):

        """
        Saves a part of a large file (over 10 MB in size) to be later passed to one of the methods.

        **Bots can use this method**

        Args:
            file_id (int): Random file id, created by the client
            file_part (int): Part sequence number
            file_total_parts (int): Total number of parts
            bytes (bytes): Binary data, part contents
        """

        self.file_id = file_id
        self.file_part = file_part
        self.file_total_parts = file_total_parts
        self.bytes = bytes

    def to_bytes(self, boxed: bool=True):
        with Writer(b'=g{\xde' if boxed else b'') as writer:
            writer.long(self.file_id)
            writer.int(self.file_part)
            writer.int(self.file_total_parts)
            writer.bytes(self.bytes)

            return writer.getvalue()