
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ....gadgets.byteutils import Reader


class ResPQ(TLObject, family='TypeResPQ'):
    _id = 0X5162463
    _group_id = 0X70B2B108

    def __init__(
        self,
        nonce: int,
        server_nonce: int,
        pq: bytes,
        server_public_key_fingerprints: List[int]
    ):

        self.nonce = nonce
        self.server_nonce = server_nonce
        self.pq = pq
        self.server_public_key_fingerprints = server_public_key_fingerprints

    def to_bytes(self, boxed: bool=True):
        with Writer(b'c$\x16\x05' if boxed else b'') as writer:
            writer.int128(self.nonce)
            writer.int128(self.server_nonce)
            writer.bytes(self.pq)
            writer.vector(
                self.server_public_key_fingerprints,
                writer.long
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        nonce_ = reader.int128()
        server_nonce_ = reader.int128()
        pq_ = reader.bytes()
        server_public_key_fingerprints_ = reader.vector(
            reader.long
        )

        return cls(
            nonce=nonce_,
            server_nonce=server_nonce_,
            pq=pq_,
            server_public_key_fingerprints=server_public_key_fingerprints_
        )

TypeResPQ = ResPQ