
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .input_sticker_set import TypeInputStickerSet
    from ...gadgets.byteutils import Reader


class DocumentAttributeImageSize(TLObject, family='TypeDocumentAttribute'):
    _id = 0X6C37C15C
    _group_id = 0X9EBF3A46

    def __init__(
        self,
        w: int,
        h: int
    ):

        self.w = w
        self.h = h

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\\\xc17l' if boxed else b'') as writer:
            writer.int(self.w)
            writer.int(self.h)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        w_ = reader.int()
        h_ = reader.int()

        return cls(
            w=w_,
            h=h_
        )

class DocumentAttributeAnimated(TLObject, family='TypeDocumentAttribute'):
    _id = 0X11B58939
    _group_id = 0X9EBF3A46


    def to_bytes(self, boxed: bool=True):
        return b'9\x89\xb5\x11' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class DocumentAttributeSticker23(TLObject, family='TypeDocumentAttribute'):
    _id = 0XFB0A5727
    _group_id = 0X9EBF3A46


    def to_bytes(self, boxed: bool=True):
        return b"'W\n\xfb" if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class DocumentAttributeVideo23(TLObject, family='TypeDocumentAttribute'):
    _id = 0X5910CCCB
    _group_id = 0X9EBF3A46

    def __init__(
        self,
        duration: int,
        w: int,
        h: int
    ):

        self.duration = duration
        self.w = w
        self.h = h

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xcb\xcc\x10Y' if boxed else b'') as writer:
            writer.int(self.duration)
            writer.int(self.w)
            writer.int(self.h)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        duration_ = reader.int()
        w_ = reader.int()
        h_ = reader.int()

        return cls(
            duration=duration_,
            w=w_,
            h=h_
        )

class DocumentAttributeAudio23(TLObject, family='TypeDocumentAttribute'):
    _id = 0X51448E5
    _group_id = 0X9EBF3A46

    def __init__(
        self,
        duration: int
    ):

        self.duration = duration

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe5H\x14\x05' if boxed else b'') as writer:
            writer.int(self.duration)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        duration_ = reader.int()

        return cls(
            duration=duration_
        )

class DocumentAttributeFilename(TLObject, family='TypeDocumentAttribute'):
    _id = 0X15590068
    _group_id = 0X9EBF3A46

    def __init__(
        self,
        file_name: str
    ):

        self.file_name = file_name

    def to_bytes(self, boxed: bool=True):
        with Writer(b'h\x00Y\x15' if boxed else b'') as writer:
            writer.string(self.file_name)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        file_name_ = reader.string()

        return cls(
            file_name=file_name_
        )

class DocumentAttributeAudio45(TLObject, family='TypeDocumentAttribute'):
    _id = 0XDED218E0
    _group_id = 0X9EBF3A46

    def __init__(
        self,
        duration: int,
        title: str,
        performer: str
    ):

        self.duration = duration
        self.title = title
        self.performer = performer

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe0\x18\xd2\xde' if boxed else b'') as writer:
            writer.int(self.duration)
            writer.string(self.title)
            writer.string(self.performer)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        duration_ = reader.int()
        title_ = reader.string()
        performer_ = reader.string()

        return cls(
            duration=duration_,
            title=title_,
            performer=performer_
        )

class DocumentAttributeSticker(TLObject, family='TypeDocumentAttribute'):
    _id = 0X3A556302
    _group_id = 0X9EBF3A46

    def __init__(
        self,
        alt: str,
        stickerset: 'TypeInputStickerSet'
    ):

        self.alt = alt
        self.stickerset = stickerset

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x02cU:' if boxed else b'') as writer:
            writer.string(self.alt)
            writer.object(
                self.stickerset,
                group_id=0X919D8BA5
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        alt_ = reader.string()
        stickerset_ = reader.object(
            group_id=0X919D8BA5
        )

        return cls(
            alt=alt_,
            stickerset=stickerset_
        )

class DocumentAttributeAudio(TLObject, family='TypeDocumentAttribute'):
    _id = 0X9852F9C6
    _group_id = 0X9EBF3A46

    def __init__(
        self,
        duration: int,
        voice: bool = False,
        title: Optional[str] = None,
        performer: Optional[str] = None,
        waveform: Optional[bytes] = None
    ):

        self.duration = duration
        self.voice = voice
        self.title = title
        self.performer = performer
        self.waveform = waveform

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc6\xf9R\x98' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.voice, 10)
                writer.int(self.duration)

                if flags(self.title, 0):
                    writer.string(self.title)

                if flags(self.performer, 1):
                    writer.string(self.performer)

                if flags(self.waveform, 2):
                    writer.bytes(self.waveform)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        duration_ = reader.int()
        title_ = (
            reader.string()
            if flags(0) else None
        )

        performer_ = (
            reader.string()
            if flags(1) else None
        )

        waveform_ = (
            reader.bytes()
            if flags(2) else None
        )

        return cls(
            duration=duration_,
            voice=flags(10),
            title=title_,
            performer=performer_,
            waveform=waveform_
        )

class DocumentAttributeVideo(TLObject, family='TypeDocumentAttribute'):
    _id = 0XEF02CE6
    _group_id = 0X9EBF3A46

    def __init__(
        self,
        duration: int,
        w: int,
        h: int,
        round_message: bool = False
    ):

        self.duration = duration
        self.w = w
        self.h = h
        self.round_message = round_message

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe6,\xf0\x0e' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.round_message, 0)
                writer.int(self.duration)
                writer.int(self.w)
                writer.int(self.h)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        duration_ = reader.int()
        w_ = reader.int()
        h_ = reader.int()

        return cls(
            duration=duration_,
            w=w_,
            h=h_,
            round_message=flags(0)
        )

TypeDocumentAttribute = Union[
    DocumentAttributeImageSize,
    DocumentAttributeAnimated,
    DocumentAttributeSticker23,
    DocumentAttributeVideo23,
    DocumentAttributeAudio23,
    DocumentAttributeFilename,
    DocumentAttributeAudio45,
    DocumentAttributeSticker,
    DocumentAttributeAudio,
    DocumentAttributeVideo
]