
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ....gadgets.byteutils import Reader


class ContentSettings(TLObject, family='TypeAccountContentSettings'):
    """
    Sensitive content settings
    """

    _id = 0X57E28221
    _group_id = 0X9B8BBE3D

    def __init__(
        self,
        sensitive_enabled: bool = False,
        sensitive_can_change: bool = False
    ):

        """
        Sensitive content settings

        Args:
            sensitive_enabled (bool, optional): Whether viewing of sensitive (NSFW) content is enabled
            sensitive_can_change (bool, optional): Whether the current client can change the sensitive content settings to view NSFW content
        """

        self.sensitive_enabled = sensitive_enabled
        self.sensitive_can_change = sensitive_can_change

    def to_bytes(self, boxed: bool=True):
        with Writer(b'!\x82\xe2W' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.sensitive_enabled, 0)
                flags(self.sensitive_can_change, 1)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()

        return cls(
            sensitive_enabled=flags(0),
            sensitive_can_change=flags(1)
        )

TypeAccountContentSettings = ContentSettings