
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ....gadgets.byteutils import Reader


class SentCodeTypeApp(TLObject, family='TypeAuthSentCodeType'):
    """
    The code was sent through the telegram app
    """

    _id = 0X3DBB5986
    _group_id = 0X73A22103

    def __init__(
        self,
        length: int
    ):

        """
        The code was sent through the telegram app

        Args:
            length (int): Length of the code in bytes
        """

        self.length = length

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x86Y\xbb=' if boxed else b'') as writer:
            writer.int(self.length)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        length_ = reader.int()

        return cls(
            length=length_
        )

class SentCodeTypeSms(TLObject, family='TypeAuthSentCodeType'):
    """
    The code was sent via SMS
    """

    _id = 0XC000BBA2
    _group_id = 0X73A22103

    def __init__(
        self,
        length: int
    ):

        """
        The code was sent via SMS

        Args:
            length (int): Length of the code in bytes
        """

        self.length = length

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa2\xbb\x00\xc0' if boxed else b'') as writer:
            writer.int(self.length)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        length_ = reader.int()

        return cls(
            length=length_
        )

class SentCodeTypeCall(TLObject, family='TypeAuthSentCodeType'):
    """
    The code will be sent via a phone call: a synthesized voice will tell the user which verification code to input.
    """

    _id = 0X5353E5A7
    _group_id = 0X73A22103

    def __init__(
        self,
        length: int
    ):

        """
        The code will be sent via a phone call: a synthesized voice will tell the user which verification code to input.

        Args:
            length (int): Length of the verification code
        """

        self.length = length

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa7\xe5SS' if boxed else b'') as writer:
            writer.int(self.length)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        length_ = reader.int()

        return cls(
            length=length_
        )

class SentCodeTypeFlashCall(TLObject, family='TypeAuthSentCodeType'):
    """
    The code will be sent via a flash phone call, that will be closed immediately. The phone code will then be the phone number itself, just make sure that the phone number matches the specified pattern.
    """

    _id = 0XAB03C6D9
    _group_id = 0X73A22103

    def __init__(
        self,
        pattern: str
    ):

        """
        The code will be sent via a flash phone call, that will be closed immediately. The phone code will then be the phone number itself, just make sure that the phone number matches the specified pattern.

        Args:
            pattern (str): [pattern](https://core.telegram.org/api/pattern) to match
        """

        self.pattern = pattern

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd9\xc6\x03\xab' if boxed else b'') as writer:
            writer.string(self.pattern)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        pattern_ = reader.string()

        return cls(
            pattern=pattern_
        )

class SentCodeTypeMissedCall(TLObject, family='TypeAuthSentCodeType'):
    """
    The code will be sent via a flash phone call, that will be closed immediately. The last digits of the phone number that calls are the code that must be entered manually by the user.
    """

    _id = 0X82006484
    _group_id = 0X73A22103

    def __init__(
        self,
        prefix: str,
        length: int
    ):

        """
        The code will be sent via a flash phone call, that will be closed immediately. The last digits of the phone number that calls are the code that must be entered manually by the user.

        Args:
            prefix (str): Prefix of the phone number from which the call will be made
            length (int): Length of the verification code
        """

        self.prefix = prefix
        self.length = length

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x84d\x00\x82' if boxed else b'') as writer:
            writer.string(self.prefix)
            writer.int(self.length)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        prefix_ = reader.string()
        length_ = reader.int()

        return cls(
            prefix=prefix_,
            length=length_
        )

class SentCodeTypeEmailCode(TLObject, family='TypeAuthSentCodeType'):
    """
    The code was sent via the [previously configured login email](https://core.telegram.org/api/auth#email-verification)
    """

    _id = 0XF450F59B
    _group_id = 0X73A22103

    def __init__(
        self,
        email_pattern: str,
        length: int,
        apple_signin_allowed: bool = False,
        google_signin_allowed: bool = False,
        reset_available_period: Optional[int] = None,
        reset_pending_date: Optional[int] = None
    ):

        """
        The code was sent via the [previously configured login email](https://core.telegram.org/api/auth#email-verification)

        Args:
            email_pattern (str): [Pattern](https://core.telegram.org/api/pattern) of the email
            length (int): Length of the sent verification code
            apple_signin_allowed (bool, optional): Whether authorization through Apple ID is allowed
            google_signin_allowed (bool, optional): Whether authorization through Google ID is allowed
            reset_available_period (Optional[int], optional): Clients should wait for the specified amount of seconds before allowing the user to invoke [auth.resetLoginEmail](https://core.telegram.org/method/auth.resetLoginEmail) (will be 0 for [Premium](https://core.telegram.org/api/premium) users).
            reset_pending_date (Optional[int], optional): An email reset was already requested, and will occur at the specified date.
        """

        self.email_pattern = email_pattern
        self.length = length
        self.apple_signin_allowed = apple_signin_allowed
        self.google_signin_allowed = google_signin_allowed
        self.reset_available_period = reset_available_period
        self.reset_pending_date = reset_pending_date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9b\xf5P\xf4' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.apple_signin_allowed, 0)
                flags(self.google_signin_allowed, 1)
                writer.string(self.email_pattern)
                writer.int(self.length)

                if flags(self.reset_available_period, 3):
                    writer.int(self.reset_available_period)

                if flags(self.reset_pending_date, 4):
                    writer.int(self.reset_pending_date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        email_pattern_ = reader.string()
        length_ = reader.int()
        reset_available_period_ = (
            reader.int()
            if flags(3) else None
        )

        reset_pending_date_ = (
            reader.int()
            if flags(4) else None
        )

        return cls(
            email_pattern=email_pattern_,
            length=length_,
            apple_signin_allowed=flags(0),
            google_signin_allowed=flags(1),
            reset_available_period=reset_available_period_,
            reset_pending_date=reset_pending_date_
        )

class SentCodeTypeSetUpEmailRequired(TLObject, family='TypeAuthSentCodeType'):
    """
    The user should add and verify an email address in order to login as described [here](https://core.telegram.org/api/auth#email-verification).
    """

    _id = 0XA5491DEA
    _group_id = 0X73A22103

    def __init__(
        self,
        apple_signin_allowed: bool = False,
        google_signin_allowed: bool = False
    ):

        """
        The user should add and verify an email address in order to login as described [here](https://core.telegram.org/api/auth#email-verification).

        Args:
            apple_signin_allowed (bool, optional): Whether authorization through Apple ID is allowed
            google_signin_allowed (bool, optional): Whether authorization through Google ID is allowed
        """

        self.apple_signin_allowed = apple_signin_allowed
        self.google_signin_allowed = google_signin_allowed

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xea\x1dI\xa5' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.apple_signin_allowed, 0)
                flags(self.google_signin_allowed, 1)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()

        return cls(
            apple_signin_allowed=flags(0),
            google_signin_allowed=flags(1)
        )

class SentCodeTypeFragmentSms(TLObject, family='TypeAuthSentCodeType'):
    """
    The code was delivered via [fragment.com](https://fragment.com).
    """

    _id = 0XD9565C39
    _group_id = 0X73A22103

    def __init__(
        self,
        url: str,
        length: int
    ):

        """
        The code was delivered via [fragment.com](https://fragment.com).

        Args:
            url (str): Open the specified URL to log into [fragment.com](https://fragment.com) with the wallet that owns the specified phone number and view the code.
            length (int): Length of the delivered code.
        """

        self.url = url
        self.length = length

    def to_bytes(self, boxed: bool=True):
        with Writer(b'9\\V\xd9' if boxed else b'') as writer:
            writer.string(self.url)
            writer.int(self.length)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        url_ = reader.string()
        length_ = reader.int()

        return cls(
            url=url_,
            length=length_
        )

class SentCodeTypeFirebaseSms(TLObject, family='TypeAuthSentCodeType'):
    """
    An authentication code should be delivered via SMS after Firebase attestation, as described in the [auth documentation](https://core.telegram.org/api/auth).
    """

    _id = 0X9FD736
    _group_id = 0X73A22103

    def __init__(
        self,
        length: int,
        nonce: Optional[bytes] = None,
        play_integrity_project_id: Optional[int] = None,
        play_integrity_nonce: Optional[bytes] = None,
        receipt: Optional[str] = None,
        push_timeout: Optional[int] = None
    ):

        """
        An authentication code should be delivered via SMS after Firebase attestation, as described in the [auth documentation](https://core.telegram.org/api/auth).

        Args:
            length (int): Length of the code that will be delivered.
            nonce (Optional[bytes], optional): On Android, the nonce to be used as described in the [auth documentation](https://core.telegram.org/api/auth)
            play_integrity_project_id (Optional[int], optional): Google Play Integrity project ID
            play_integrity_nonce (Optional[bytes], optional): Play Integrity API nonce
            receipt (Optional[str], optional): On iOS, must be compared with the receipt extracted from the received push notification.
            push_timeout (Optional[int], optional): On iOS: if a push notification with the ios_push_secret isn't received within push_timeout seconds, the next_type authentication method must be used, with [auth.resendCode](https://core.telegram.org/method/auth.resendCode).
        """

        self.length = length
        self.nonce = nonce
        self.play_integrity_project_id = play_integrity_project_id
        self.play_integrity_nonce = play_integrity_nonce
        self.receipt = receipt
        self.push_timeout = push_timeout

    def to_bytes(self, boxed: bool=True):
        with Writer(b'6\xd7\x9f\x00' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.nonce, 0):
                    writer.bytes(self.nonce)

                if flags(self.play_integrity_project_id, 2):
                    writer.long(self.play_integrity_project_id)

                if flags(self.play_integrity_nonce, 2):
                    writer.bytes(self.play_integrity_nonce)

                if flags(self.receipt, 1):
                    writer.string(self.receipt)

                if flags(self.push_timeout, 1):
                    writer.int(self.push_timeout)
                writer.int(self.length)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        nonce_ = (
            reader.bytes()
            if flags(0) else None
        )

        play_integrity_project_id_ = (
            reader.long()
            if flags(2) else None
        )

        play_integrity_nonce_ = (
            reader.bytes()
            if flags(2) else None
        )

        receipt_ = (
            reader.string()
            if flags(1) else None
        )

        push_timeout_ = (
            reader.int()
            if flags(1) else None
        )

        length_ = reader.int()

        return cls(
            length=length_,
            nonce=nonce_,
            play_integrity_project_id=play_integrity_project_id_,
            play_integrity_nonce=play_integrity_nonce_,
            receipt=receipt_,
            push_timeout=push_timeout_
        )

class SentCodeTypeSmsWord(TLObject, family='TypeAuthSentCodeType'):
    """
    The code was sent via SMS as a secret word, starting with the letter specified in beginning
    """

    _id = 0XA416AC81
    _group_id = 0X73A22103

    def __init__(
        self,
        beginning: Optional[str] = None
    ):

        """
        The code was sent via SMS as a secret word, starting with the letter specified in beginning

        Args:
            beginning (Optional[str], optional): If set, the secret word in the sent SMS (which may contain multiple words) starts with this letter.
        """

        self.beginning = beginning

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x81\xac\x16\xa4' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.beginning, 0):
                    writer.string(self.beginning)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        beginning_ = (
            reader.string()
            if flags(0) else None
        )

        return cls(
            beginning=beginning_
        )

class SentCodeTypeSmsPhrase(TLObject, family='TypeAuthSentCodeType'):
    """
    The code was sent via SMS as a secret phrase starting with the word specified in beginning
    """

    _id = 0XB37794AF
    _group_id = 0X73A22103

    def __init__(
        self,
        beginning: Optional[str] = None
    ):

        """
        The code was sent via SMS as a secret phrase starting with the word specified in beginning

        Args:
            beginning (Optional[str], optional): If set, the secret phrase (and the SMS) starts with this word.
        """

        self.beginning = beginning

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xaf\x94w\xb3' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.beginning, 0):
                    writer.string(self.beginning)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        beginning_ = (
            reader.string()
            if flags(0) else None
        )

        return cls(
            beginning=beginning_
        )

TypeAuthSentCodeType = Union[
    SentCodeTypeApp,
    SentCodeTypeSms,
    SentCodeTypeCall,
    SentCodeTypeFlashCall,
    SentCodeTypeMissedCall,
    SentCodeTypeEmailCode,
    SentCodeTypeSetUpEmailRequired,
    SentCodeTypeFragmentSms,
    SentCodeTypeFirebaseSms,
    SentCodeTypeSmsWord,
    SentCodeTypeSmsPhrase
]