
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .document import TypeDocument
    from ...gadgets.byteutils import Reader


class AvailableReaction(TLObject, family='TypeAvailableReaction'):
    """
    Animations associated with a message reaction
    """

    _id = 0XC077EC01
    _group_id = 0XE58A4CAE

    def __init__(
        self,
        reaction: str,
        title: str,
        static_icon: 'TypeDocument',
        appear_animation: 'TypeDocument',
        select_animation: 'TypeDocument',
        activate_animation: 'TypeDocument',
        effect_animation: 'TypeDocument',
        inactive: bool = False,
        premium: bool = False,
        around_animation: Optional['TypeDocument'] = None,
        center_icon: Optional['TypeDocument'] = None
    ):

        """
        Animations associated with a message reaction

        Args:
            reaction (str): Reaction emoji
            title (str): Reaction description
            static_icon ('TypeDocument'): Static icon for the reaction
            appear_animation ('TypeDocument'): The animated sticker to show when the user opens the reaction dropdown
            select_animation ('TypeDocument'): The animated sticker to show when the user hovers over the reaction
            activate_animation ('TypeDocument'): The animated sticker to show when the reaction is chosen and activated
            effect_animation ('TypeDocument'): The background effect (still an animated sticker) to play under the activate_animation, when the reaction is chosen and activated
            inactive (bool, optional): If not set, the reaction can be added to new messages and enabled in chats.
            premium (bool, optional): Whether this reaction can only be used by Telegram Premium users
            around_animation (Optional['TypeDocument'], optional): The animation that plays around the button when you press an existing reaction (played together with center_icon).
            center_icon (Optional['TypeDocument'], optional): The animation of the emoji inside the button when you press an existing reaction (played together with around_animation).
        """

        self.reaction = reaction
        self.title = title
        self.static_icon = static_icon
        self.appear_animation = appear_animation
        self.select_animation = select_animation
        self.activate_animation = activate_animation
        self.effect_animation = effect_animation
        self.inactive = inactive
        self.premium = premium
        self.around_animation = around_animation
        self.center_icon = center_icon

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x01\xecw\xc0' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.inactive, 0)
                flags(self.premium, 2)
                writer.string(self.reaction)
                writer.string(self.title)
                writer.object(
                    self.static_icon,
                    group_id=0X6547BD50
                )
                writer.object(
                    self.appear_animation,
                    group_id=0X6547BD50
                )
                writer.object(
                    self.select_animation,
                    group_id=0X6547BD50
                )
                writer.object(
                    self.activate_animation,
                    group_id=0X6547BD50
                )
                writer.object(
                    self.effect_animation,
                    group_id=0X6547BD50
                )

                if flags(self.around_animation, 1):
                    writer.object(
                        self.around_animation,
                        group_id=0X6547BD50
                    )

                if flags(self.center_icon, 1):
                    writer.object(
                        self.center_icon,
                        group_id=0X6547BD50
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        reaction_ = reader.string()
        title_ = reader.string()
        static_icon_ = reader.object(
            group_id=0X6547BD50
        )

        appear_animation_ = reader.object(
            group_id=0X6547BD50
        )

        select_animation_ = reader.object(
            group_id=0X6547BD50
        )

        activate_animation_ = reader.object(
            group_id=0X6547BD50
        )

        effect_animation_ = reader.object(
            group_id=0X6547BD50
        )

        around_animation_ = (
            reader.object(
                group_id=0X6547BD50
            )
            if flags(1) else None
        )

        center_icon_ = (
            reader.object(
                group_id=0X6547BD50
            )
            if flags(1) else None
        )

        return cls(
            reaction=reaction_,
            title=title_,
            static_icon=static_icon_,
            appear_animation=appear_animation_,
            select_animation=select_animation_,
            activate_animation=activate_animation_,
            effect_animation=effect_animation_,
            inactive=flags(0),
            premium=flags(2),
            around_animation=around_animation_,
            center_icon=center_icon_
        )

TypeAvailableReaction = AvailableReaction