
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class ChatAdminRights(TLObject, family='TypeChatAdminRights'):
    """
    Represents the rights of an admin in a [channel/supergroup](https://core.telegram.org/api/channel).
    """

    _id = 0X5FB224D5
    _group_id = 0X2A03C5CB

    def __init__(
        self,
        change_info: bool = False,
        post_messages: bool = False,
        edit_messages: bool = False,
        delete_messages: bool = False,
        ban_users: bool = False,
        invite_users: bool = False,
        pin_messages: bool = False,
        add_admins: bool = False,
        anonymous: bool = False,
        manage_call: bool = False,
        other: bool = False,
        manage_topics: bool = False,
        post_stories: bool = False,
        edit_stories: bool = False,
        delete_stories: bool = False,
        manage_direct_messages: bool = False
    ):

        """
        Represents the rights of an admin in a [channel/supergroup](https://core.telegram.org/api/channel).

        Args:
            change_info (bool, optional): If set, allows the admin to modify the description of the [channel/supergroup](https://core.telegram.org/api/channel)
            post_messages (bool, optional): If set, allows the admin to post messages in the [channel](https://core.telegram.org/api/channel)
            edit_messages (bool, optional): If set, allows the admin to also edit messages from other admins in the [channel](https://core.telegram.org/api/channel)
            delete_messages (bool, optional): If set, allows the admin to also delete messages from other admins in the [channel](https://core.telegram.org/api/channel)
            ban_users (bool, optional): If set, allows the admin to ban users from the [channel/supergroup](https://core.telegram.org/api/channel)
            invite_users (bool, optional): If set, allows the admin to invite users in the [channel/supergroup](https://core.telegram.org/api/channel)
            pin_messages (bool, optional): If set, allows the admin to pin messages in the [channel/supergroup](https://core.telegram.org/api/channel)
            add_admins (bool, optional): If set, allows the admin to add other admins with the same (or more limited) permissions in the [channel/supergroup](https://core.telegram.org/api/channel)
            anonymous (bool, optional): Whether this admin is anonymous
            manage_call (bool, optional): If set, allows the admin to change group call/livestream settings
            other (bool, optional): Set this flag if none of the other flags are set, but you still want the user to be an admin: if this or any of the other flags are set, the admin can get the chat [admin log](https://core.telegram.org/api/recent-actions), get [chat statistics](https://core.telegram.org/api/stats), get [message statistics in channels](https://core.telegram.org/api/stats), get channel members, see anonymous administrators in supergroups and ignore slow mode.
            manage_topics (bool, optional): If set, allows the admin to create, delete or modify [forum topics](https://core.telegram.org/api/forum#forum-topics).
            post_stories (bool, optional): If set, allows the admin to post [stories](https://core.telegram.org/api/stories) as the [channel](https://core.telegram.org/api/channel).
            edit_stories (bool, optional): If set, allows the admin to edit [stories](https://core.telegram.org/api/stories) posted by the other admins of the [channel](https://core.telegram.org/api/channel).
            delete_stories (bool, optional): If set, allows the admin to delete [stories](https://core.telegram.org/api/stories) posted by the other admins of the [channel](https://core.telegram.org/api/channel).
            manage_direct_messages (bool, optional): ...
        """

        self.change_info = change_info
        self.post_messages = post_messages
        self.edit_messages = edit_messages
        self.delete_messages = delete_messages
        self.ban_users = ban_users
        self.invite_users = invite_users
        self.pin_messages = pin_messages
        self.add_admins = add_admins
        self.anonymous = anonymous
        self.manage_call = manage_call
        self.other = other
        self.manage_topics = manage_topics
        self.post_stories = post_stories
        self.edit_stories = edit_stories
        self.delete_stories = delete_stories
        self.manage_direct_messages = manage_direct_messages

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd5$\xb2_' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.change_info, 0)
                flags(self.post_messages, 1)
                flags(self.edit_messages, 2)
                flags(self.delete_messages, 3)
                flags(self.ban_users, 4)
                flags(self.invite_users, 5)
                flags(self.pin_messages, 7)
                flags(self.add_admins, 9)
                flags(self.anonymous, 10)
                flags(self.manage_call, 11)
                flags(self.other, 12)
                flags(self.manage_topics, 13)
                flags(self.post_stories, 14)
                flags(self.edit_stories, 15)
                flags(self.delete_stories, 16)
                flags(self.manage_direct_messages, 17)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()

        return cls(
            change_info=flags(0),
            post_messages=flags(1),
            edit_messages=flags(2),
            delete_messages=flags(3),
            ban_users=flags(4),
            invite_users=flags(5),
            pin_messages=flags(7),
            add_admins=flags(9),
            anonymous=flags(10),
            manage_call=flags(11),
            other=flags(12),
            manage_topics=flags(13),
            post_stories=flags(14),
            edit_stories=flags(15),
            delete_stories=flags(16),
            manage_direct_messages=flags(17)
        )

TypeChatAdminRights = ChatAdminRights