
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class DcOption(TLObject, family='TypeDcOption'):
    """
    Data center
    """

    _id = 0X18B7A10D
    _group_id = 0XDA1BB453

    def __init__(
        self,
        id: int,
        ip_address: str,
        port: int,
        ipv6: bool = False,
        media_only: bool = False,
        tcpo_only: bool = False,
        cdn: bool = False,
        static: bool = False,
        this_port_only: bool = False,
        secret: Optional[bytes] = None
    ):

        """
        Data center

        Args:
            id (int): DC ID
            ip_address (str): IP address of DC
            port (int): Port
            ipv6 (bool, optional): Whether the specified IP is an IPv6 address
            media_only (bool, optional): Whether this DC should only be used to [download or upload files](https://core.telegram.org/api/files)
            tcpo_only (bool, optional): Whether this DC only supports connection with [transport obfuscation](https://core.telegram.org/mtproto/mtproto-transports#transport-obfuscation)
            cdn (bool, optional): Whether this is a [CDN DC](https://core.telegram.org/cdn).
            static (bool, optional): If set, this IP should be used when connecting through a proxy
            this_port_only (bool, optional): If set, clients must connect using only the specified port, without trying any other port.
            secret (Optional[bytes], optional): If the tcpo_only flag is set, specifies the secret to use when connecting using [transport obfuscation](https://core.telegram.org/mtproto/mtproto-transports#transport-obfuscation)
        """

        self.id = id
        self.ip_address = ip_address
        self.port = port
        self.ipv6 = ipv6
        self.media_only = media_only
        self.tcpo_only = tcpo_only
        self.cdn = cdn
        self.static = static
        self.this_port_only = this_port_only
        self.secret = secret

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\r\xa1\xb7\x18' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.ipv6, 0)
                flags(self.media_only, 1)
                flags(self.tcpo_only, 2)
                flags(self.cdn, 3)
                flags(self.static, 4)
                flags(self.this_port_only, 5)
                writer.int(self.id)
                writer.string(self.ip_address)
                writer.int(self.port)

                if flags(self.secret, 10):
                    writer.bytes(self.secret)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.int()
        ip_address_ = reader.string()
        port_ = reader.int()
        secret_ = (
            reader.bytes()
            if flags(10) else None
        )

        return cls(
            id=id_,
            ip_address=ip_address_,
            port=port_,
            ipv6=flags(0),
            media_only=flags(1),
            tcpo_only=flags(2),
            cdn=flags(3),
            static=flags(4),
            this_port_only=flags(5),
            secret=secret_
        )

TypeDcOption = DcOption