
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .country import TypeHelpCountry
    from ....gadgets.byteutils import Reader


class CountriesListNotModified(TLObject, family='TypeHelpCountriesList'):
    """
    The country list has not changed
    """

    _id = 0X93CC1F32
    _group_id = 0XD1A84079


    def to_bytes(self, boxed: bool=True):
        return b'2\x1f\xcc\x93' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class CountriesList(TLObject, family='TypeHelpCountriesList'):
    """
    Name, ISO code, localized name and phone codes/patterns of all available countries
    """

    _id = 0X87D0759E
    _group_id = 0XD1A84079

    def __init__(
        self,
        countries: List['TypeHelpCountry'],
        hash: int
    ):

        """
        Name, ISO code, localized name and phone codes/patterns of all available countries

        Args:
            countries (List['TypeHelpCountry']): Name, ISO code, localized name and phone codes/patterns of all available countries
            hash (int): [Hash used for caching, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
        """

        self.countries = countries
        self.hash = hash

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9eu\xd0\x87' if boxed else b'') as writer:
            writer.vector(
                self.countries,
                lambda value: writer.object(
                    value,
                    group_id=0XD1EA5215
                )
            )
            writer.int(self.hash)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        countries_ = reader.vector(
            lambda: reader.object(
                group_id=0XD1EA5215
            )
        )

        hash_ = reader.int()

        return cls(
            countries=countries_,
            hash=hash_
        )

TypeHelpCountriesList = Union[
    CountriesListNotModified,
    CountriesList
]