
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ....gadgets.byteutils import Reader


class CountryCode(TLObject, family='TypeHelpCountryCode'):
    """
    Country code and phone number pattern of a specific country
    """

    _id = 0X4203C5EF
    _group_id = 0X8A9D3BF1

    def __init__(
        self,
        country_code: str,
        prefixes: Optional[List[str]] = None,
        patterns: Optional[List[str]] = None
    ):

        """
        Country code and phone number pattern of a specific country

        Args:
            country_code (str): ISO country code
            prefixes (Optional[List[str]], optional): Possible phone prefixes
            patterns (Optional[List[str]], optional): Phone patterns: for example, XXX XXX XXX
        """

        self.country_code = country_code
        self.prefixes = prefixes
        self.patterns = patterns

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xef\xc5\x03B' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.country_code)

                if flags(self.prefixes, 0):
                    writer.vector(
                        self.prefixes,
                        writer.string
                    )

                if flags(self.patterns, 1):
                    writer.vector(
                        self.patterns,
                        writer.string
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        country_code_ = reader.string()
        prefixes_ = (
            reader.vector(
                reader.string
            )
            if flags(0) else None
        )

        patterns_ = (
            reader.vector(
                reader.string
            )
            if flags(1) else None
        )

        return cls(
            country_code=country_code_,
            prefixes=prefixes_,
            patterns=patterns_
        )

TypeHelpCountryCode = CountryCode