
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .input_user import TypeInputUser
    from ...gadgets.byteutils import Reader


class InputBotAppID(TLObject, family='TypeInputBotApp'):
    """
    Used to fetch information about a [direct link Mini App](https://core.telegram.org/api/bots/webapps#direct-link-mini-apps) by its ID
    """

    _id = 0XA920BD7A
    _group_id = 0X40D88192

    def __init__(
        self,
        id: int,
        access_hash: int
    ):

        """
        Used to fetch information about a [direct link Mini App](https://core.telegram.org/api/bots/webapps#direct-link-mini-apps) by its ID

        Args:
            id (int): [direct link Mini App](https://core.telegram.org/api/bots/webapps#direct-link-mini-apps) ID.
            access_hash (int): Access hash, obtained from the [botApp](https://core.telegram.org/constructor/botApp) constructor.
        """

        self.id = id
        self.access_hash = access_hash

    def to_bytes(self, boxed: bool=True):
        with Writer(b'z\xbd \xa9' if boxed else b'') as writer:
            writer.long(self.id)
            writer.long(self.access_hash)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        access_hash_ = reader.long()

        return cls(
            id=id_,
            access_hash=access_hash_
        )

class InputBotAppShortName(TLObject, family='TypeInputBotApp'):
    """
    Used to fetch information about a [direct link Mini App](https://core.telegram.org/api/bots/webapps#direct-link-mini-apps) by its short name
    """

    _id = 0X908C0407
    _group_id = 0X40D88192

    def __init__(
        self,
        bot_id: 'TypeInputUser',
        short_name: str
    ):

        """
        Used to fetch information about a [direct link Mini App](https://core.telegram.org/api/bots/webapps#direct-link-mini-apps) by its short name

        Args:
            bot_id ('TypeInputUser'): ID of the bot that owns the bot mini app
            short_name (str): Short name, obtained from a [Direct Mini App deep link](https://core.telegram.org/api/links#direct-mini-app-links)
        """

        self.bot_id = bot_id
        self.short_name = short_name

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x07\x04\x8c\x90' if boxed else b'') as writer:
            writer.object(
                self.bot_id,
                group_id=0XB628962F
            )
            writer.string(self.short_name)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        bot_id_ = reader.object(
            group_id=0XB628962F
        )

        short_name_ = reader.string()

        return cls(
            bot_id=bot_id_,
            short_name=short_name_
        )

TypeInputBotApp = Union[
    InputBotAppID,
    InputBotAppShortName
]