
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .input_photo import TypeInputPhoto
    from .input_document import TypeInputDocument
    from .input_web_document import TypeInputWebDocument
    from ...gadgets.byteutils import Reader
    from .input_bot_inline_message import TypeInputBotInlineMessage


class InputBotInlineResult(TLObject, family='TypeInputBotInlineResult'):
    """
    An inline bot result
    """

    _id = 0X88BF9319
    _group_id = 0X84BAC7FB

    def __init__(
        self,
        id: str,
        type: str,
        send_message: 'TypeInputBotInlineMessage',
        title: Optional[str] = None,
        description: Optional[str] = None,
        url: Optional[str] = None,
        thumb: Optional['TypeInputWebDocument'] = None,
        content: Optional['TypeInputWebDocument'] = None
    ):

        """
        An inline bot result

        Args:
            id (str): ID of result
            type (str): Result type (see [bot API docs](https://core.telegram.org/bots/api#inlinequeryresult))
            send_message ('TypeInputBotInlineMessage'): Message to send when the result is selected
            title (Optional[str], optional): Result title
            description (Optional[str], optional): Result description
            url (Optional[str], optional): URL of result
            thumb (Optional['TypeInputWebDocument'], optional): Thumbnail for result
            content (Optional['TypeInputWebDocument'], optional): Result contents
        """

        self.id = id
        self.type = type
        self.send_message = send_message
        self.title = title
        self.description = description
        self.url = url
        self.thumb = thumb
        self.content = content

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x19\x93\xbf\x88' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.id)
                writer.string(self.type)

                if flags(self.title, 1):
                    writer.string(self.title)

                if flags(self.description, 2):
                    writer.string(self.description)

                if flags(self.url, 3):
                    writer.string(self.url)

                if flags(self.thumb, 4):
                    writer.object(
                        self.thumb,
                        group_id=0X1AFB92D5
                    )

                if flags(self.content, 5):
                    writer.object(
                        self.content,
                        group_id=0X1AFB92D5
                    )
                writer.object(
                    self.send_message,
                    group_id=0X18FB8A33
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.string()
        type_ = reader.string()
        title_ = (
            reader.string()
            if flags(1) else None
        )

        description_ = (
            reader.string()
            if flags(2) else None
        )

        url_ = (
            reader.string()
            if flags(3) else None
        )

        thumb_ = (
            reader.object(
                group_id=0X1AFB92D5
            )
            if flags(4) else None
        )

        content_ = (
            reader.object(
                group_id=0X1AFB92D5
            )
            if flags(5) else None
        )

        send_message_ = reader.object(
            group_id=0X18FB8A33
        )

        return cls(
            id=id_,
            type=type_,
            send_message=send_message_,
            title=title_,
            description=description_,
            url=url_,
            thumb=thumb_,
            content=content_
        )

class InputBotInlineResultPhoto(TLObject, family='TypeInputBotInlineResult'):
    """
    Photo
    """

    _id = 0XA8D864A7
    _group_id = 0X84BAC7FB

    def __init__(
        self,
        id: str,
        type: str,
        photo: 'TypeInputPhoto',
        send_message: 'TypeInputBotInlineMessage'
    ):

        """
        Photo

        Args:
            id (str): Result ID
            type (str): Result type (see [bot API docs](https://core.telegram.org/bots/api#inlinequeryresult))
            photo ('TypeInputPhoto'): Photo to send
            send_message ('TypeInputBotInlineMessage'): Message to send when the result is selected
        """

        self.id = id
        self.type = type
        self.photo = photo
        self.send_message = send_message

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa7d\xd8\xa8' if boxed else b'') as writer:
            writer.string(self.id)
            writer.string(self.type)
            writer.object(
                self.photo,
                group_id=0XB05DFB35
            )
            writer.object(
                self.send_message,
                group_id=0X18FB8A33
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.string()
        type_ = reader.string()
        photo_ = reader.object(
            group_id=0XB05DFB35
        )

        send_message_ = reader.object(
            group_id=0X18FB8A33
        )

        return cls(
            id=id_,
            type=type_,
            photo=photo_,
            send_message=send_message_
        )

class InputBotInlineResultDocument(TLObject, family='TypeInputBotInlineResult'):
    """
    Document (media of any type except for photos)
    """

    _id = 0XFFF8FDC4
    _group_id = 0X84BAC7FB

    def __init__(
        self,
        id: str,
        type: str,
        document: 'TypeInputDocument',
        send_message: 'TypeInputBotInlineMessage',
        title: Optional[str] = None,
        description: Optional[str] = None
    ):

        """
        Document (media of any type except for photos)

        Args:
            id (str): Result ID
            type (str): Result type (see [bot API docs](https://core.telegram.org/bots/api#inlinequeryresult))
            document ('TypeInputDocument'): Document to send
            send_message ('TypeInputBotInlineMessage'): Message to send when the result is selected
            title (Optional[str], optional): Result title
            description (Optional[str], optional): Result description
        """

        self.id = id
        self.type = type
        self.document = document
        self.send_message = send_message
        self.title = title
        self.description = description

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc4\xfd\xf8\xff' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.id)
                writer.string(self.type)

                if flags(self.title, 1):
                    writer.string(self.title)

                if flags(self.description, 2):
                    writer.string(self.description)
                writer.object(
                    self.document,
                    group_id=0X84313E
                )
                writer.object(
                    self.send_message,
                    group_id=0X18FB8A33
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.string()
        type_ = reader.string()
        title_ = (
            reader.string()
            if flags(1) else None
        )

        description_ = (
            reader.string()
            if flags(2) else None
        )

        document_ = reader.object(
            group_id=0X84313E
        )

        send_message_ = reader.object(
            group_id=0X18FB8A33
        )

        return cls(
            id=id_,
            type=type_,
            document=document_,
            send_message=send_message_,
            title=title_,
            description=description_
        )

class InputBotInlineResultGame(TLObject, family='TypeInputBotInlineResult'):
    """
    Game
    """

    _id = 0X4FA417F2
    _group_id = 0X84BAC7FB

    def __init__(
        self,
        id: str,
        short_name: str,
        send_message: 'TypeInputBotInlineMessage'
    ):

        """
        Game

        Args:
            id (str): Result ID
            short_name (str): Game short name
            send_message ('TypeInputBotInlineMessage'): Message to send when the result is selected
        """

        self.id = id
        self.short_name = short_name
        self.send_message = send_message

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf2\x17\xa4O' if boxed else b'') as writer:
            writer.string(self.id)
            writer.string(self.short_name)
            writer.object(
                self.send_message,
                group_id=0X18FB8A33
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.string()
        short_name_ = reader.string()
        send_message_ = reader.object(
            group_id=0X18FB8A33
        )

        return cls(
            id=id_,
            short_name=short_name_,
            send_message=send_message_
        )

TypeInputBotInlineResult = Union[
    InputBotInlineResult,
    InputBotInlineResultPhoto,
    InputBotInlineResultDocument,
    InputBotInlineResultGame
]