
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .input_peer import TypeInputPeer
    from .input_group_call import TypeInputGroupCall
    from .input_sticker_set import TypeInputStickerSet
    from ...gadgets.byteutils import Reader


class InputFileLocation(TLObject, family='TypeInputFileLocation'):
    """
    DEPRECATED location of a photo
    """

    _id = 0XDFDAABE1
    _group_id = 0X7CB505BF

    def __init__(
        self,
        volume_id: int,
        local_id: int,
        secret: int,
        file_reference: bytes
    ):

        """
        DEPRECATED location of a photo

        Args:
            volume_id (int): Server volume
            local_id (int): File identifier
            secret (int): Check sum to access the file
            file_reference (bytes): [File reference](https://core.telegram.org/api/file_reference)
        """

        self.volume_id = volume_id
        self.local_id = local_id
        self.secret = secret
        self.file_reference = file_reference

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe1\xab\xda\xdf' if boxed else b'') as writer:
            writer.long(self.volume_id)
            writer.int(self.local_id)
            writer.long(self.secret)
            writer.bytes(self.file_reference)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        volume_id_ = reader.long()
        local_id_ = reader.int()
        secret_ = reader.long()
        file_reference_ = reader.bytes()

        return cls(
            volume_id=volume_id_,
            local_id=local_id_,
            secret=secret_,
            file_reference=file_reference_
        )

class InputEncryptedFileLocation(TLObject, family='TypeInputFileLocation'):
    """
    Location of encrypted secret chat file.
    """

    _id = 0XF5235D55
    _group_id = 0X7CB505BF

    def __init__(
        self,
        id: int,
        access_hash: int
    ):

        """
        Location of encrypted secret chat file.

        Args:
            id (int): File ID, id parameter value from [encryptedFile](https://core.telegram.org/constructor/encryptedFile)
            access_hash (int): Checksum, access_hash parameter value from [encryptedFile](https://core.telegram.org/constructor/encryptedFile)
        """

        self.id = id
        self.access_hash = access_hash

    def to_bytes(self, boxed: bool=True):
        with Writer(b'U]#\xf5' if boxed else b'') as writer:
            writer.long(self.id)
            writer.long(self.access_hash)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        access_hash_ = reader.long()

        return cls(
            id=id_,
            access_hash=access_hash_
        )

class InputDocumentFileLocation(TLObject, family='TypeInputFileLocation'):
    """
    Document location (video, voice, audio, basically every type except photo)
    """

    _id = 0XBAD07584
    _group_id = 0X7CB505BF

    def __init__(
        self,
        id: int,
        access_hash: int,
        file_reference: bytes,
        thumb_size: str
    ):

        """
        Document location (video, voice, audio, basically every type except photo)

        Args:
            id (int): Document ID
            access_hash (int): access_hash parameter from the [document](https://core.telegram.org/constructor/document) constructor
            file_reference (bytes): [File reference](https://core.telegram.org/api/file_reference)
            thumb_size (str): Thumbnail size to download the thumbnail
        """

        self.id = id
        self.access_hash = access_hash
        self.file_reference = file_reference
        self.thumb_size = thumb_size

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x84u\xd0\xba' if boxed else b'') as writer:
            writer.long(self.id)
            writer.long(self.access_hash)
            writer.bytes(self.file_reference)
            writer.string(self.thumb_size)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        access_hash_ = reader.long()
        file_reference_ = reader.bytes()
        thumb_size_ = reader.string()

        return cls(
            id=id_,
            access_hash=access_hash_,
            file_reference=file_reference_,
            thumb_size=thumb_size_
        )

class InputSecureFileLocation(TLObject, family='TypeInputFileLocation'):
    """
    Location of encrypted telegram [passport](https://core.telegram.org/passport) file.
    """

    _id = 0XCBC7EE28
    _group_id = 0X7CB505BF

    def __init__(
        self,
        id: int,
        access_hash: int
    ):

        """
        Location of encrypted telegram [passport](https://core.telegram.org/passport) file.

        Args:
            id (int): File ID, id parameter value from [secureFile](https://core.telegram.org/constructor/secureFile)
            access_hash (int): Checksum, access_hash parameter value from [secureFile](https://core.telegram.org/constructor/secureFile)
        """

        self.id = id
        self.access_hash = access_hash

    def to_bytes(self, boxed: bool=True):
        with Writer(b'(\xee\xc7\xcb' if boxed else b'') as writer:
            writer.long(self.id)
            writer.long(self.access_hash)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        access_hash_ = reader.long()

        return cls(
            id=id_,
            access_hash=access_hash_
        )

class InputTakeoutFileLocation(TLObject, family='TypeInputFileLocation'):
    """
    Used to download a JSON file that will contain all personal data related to features that do not have a specialized [takeout method](https://core.telegram.org/api/takeout) yet, see [here](https://core.telegram.org/api/takeout) for more info on the takeout API.
    """

    _id = 0X29BE5899
    _group_id = 0X7CB505BF


    def to_bytes(self, boxed: bool=True):
        return b'\x99X\xbe)' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputPhotoFileLocation(TLObject, family='TypeInputFileLocation'):
    """
    Use this object to download a photo with [upload.getFile](https://core.telegram.org/method/upload.getFile) method
    """

    _id = 0X40181FFE
    _group_id = 0X7CB505BF

    def __init__(
        self,
        id: int,
        access_hash: int,
        file_reference: bytes,
        thumb_size: str
    ):

        """
        Use this object to download a photo with [upload.getFile](https://core.telegram.org/method/upload.getFile) method

        Args:
            id (int): Photo ID, obtained from the [photo](https://core.telegram.org/constructor/photo) object
            access_hash (int): Photo's access hash, obtained from the [photo](https://core.telegram.org/constructor/photo) object
            file_reference (bytes): [File reference](https://core.telegram.org/api/file_reference)
            thumb_size (str): The [PhotoSize](https://core.telegram.org/type/PhotoSize) to download: must be set to the type field of the desired PhotoSize object of the [photo](https://core.telegram.org/constructor/photo)
        """

        self.id = id
        self.access_hash = access_hash
        self.file_reference = file_reference
        self.thumb_size = thumb_size

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfe\x1f\x18@' if boxed else b'') as writer:
            writer.long(self.id)
            writer.long(self.access_hash)
            writer.bytes(self.file_reference)
            writer.string(self.thumb_size)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        access_hash_ = reader.long()
        file_reference_ = reader.bytes()
        thumb_size_ = reader.string()

        return cls(
            id=id_,
            access_hash=access_hash_,
            file_reference=file_reference_,
            thumb_size=thumb_size_
        )

class InputPhotoLegacyFileLocation(TLObject, family='TypeInputFileLocation'):
    """
    DEPRECATED legacy photo file location
    """

    _id = 0XD83466F3
    _group_id = 0X7CB505BF

    def __init__(
        self,
        id: int,
        access_hash: int,
        file_reference: bytes,
        volume_id: int,
        local_id: int,
        secret: int
    ):

        """
        DEPRECATED legacy photo file location

        Args:
            id (int): Photo ID
            access_hash (int): Access hash
            file_reference (bytes): File reference
            volume_id (int): Volume ID
            local_id (int): Local ID
            secret (int): Secret
        """

        self.id = id
        self.access_hash = access_hash
        self.file_reference = file_reference
        self.volume_id = volume_id
        self.local_id = local_id
        self.secret = secret

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf3f4\xd8' if boxed else b'') as writer:
            writer.long(self.id)
            writer.long(self.access_hash)
            writer.bytes(self.file_reference)
            writer.long(self.volume_id)
            writer.int(self.local_id)
            writer.long(self.secret)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        access_hash_ = reader.long()
        file_reference_ = reader.bytes()
        volume_id_ = reader.long()
        local_id_ = reader.int()
        secret_ = reader.long()

        return cls(
            id=id_,
            access_hash=access_hash_,
            file_reference=file_reference_,
            volume_id=volume_id_,
            local_id=local_id_,
            secret=secret_
        )

class InputPeerPhotoFileLocation(TLObject, family='TypeInputFileLocation'):
    """
    Location of profile photo of channel/group/supergroup/user
    """

    _id = 0X37257E99
    _group_id = 0X7CB505BF

    def __init__(
        self,
        peer: 'TypeInputPeer',
        photo_id: int,
        big: bool = False
    ):

        """
        Location of profile photo of channel/group/supergroup/user

        Args:
            peer ('TypeInputPeer'): The peer whose profile picture should be downloaded
            photo_id (int): Photo ID
            big (bool, optional): Whether to download the high-quality version of the picture
        """

        self.peer = peer
        self.photo_id = photo_id
        self.big = big

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x99~%7' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.big, 0)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.long(self.photo_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_ = reader.object(
            group_id=0X995DB9DF
        )

        photo_id_ = reader.long()

        return cls(
            peer=peer_,
            photo_id=photo_id_,
            big=flags(0)
        )

class InputStickerSetThumb(TLObject, family='TypeInputFileLocation'):
    """
    Location of stickerset thumbnail (see [files](https://core.telegram.org/api/files))
    """

    _id = 0X9D84F3DB
    _group_id = 0X7CB505BF

    def __init__(
        self,
        stickerset: 'TypeInputStickerSet',
        thumb_version: int
    ):

        """
        Location of stickerset thumbnail (see [files](https://core.telegram.org/api/files))

        Args:
            stickerset ('TypeInputStickerSet'): Sticker set
            thumb_version (int): Thumbnail version
        """

        self.stickerset = stickerset
        self.thumb_version = thumb_version

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xdb\xf3\x84\x9d' if boxed else b'') as writer:
            writer.object(
                self.stickerset,
                group_id=0X919D8BA5
            )
            writer.int(self.thumb_version)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        stickerset_ = reader.object(
            group_id=0X919D8BA5
        )

        thumb_version_ = reader.int()

        return cls(
            stickerset=stickerset_,
            thumb_version=thumb_version_
        )

class InputGroupCallStream(TLObject, family='TypeInputFileLocation'):
    """
    Chunk of a livestream
    """

    _id = 0X598A92A
    _group_id = 0X7CB505BF

    def __init__(
        self,
        call: 'TypeInputGroupCall',
        time_ms: int,
        scale: int,
        video_channel: Optional[int] = None,
        video_quality: Optional[int] = None
    ):

        """
        Chunk of a livestream

        Args:
            call ('TypeInputGroupCall'): Livestream info
            time_ms (int): Timestamp in milliseconds
            scale (int): Specifies the duration of the video segment to fetch in milliseconds, by bitshifting 1000 to the right scale times: duration_ms := 1000 >> scale
            video_channel (Optional[int], optional): Selected video channel
            video_quality (Optional[int], optional): Selected video quality (0 = lowest, 1 = medium, 2 = best)
        """

        self.call = call
        self.time_ms = time_ms
        self.scale = scale
        self.video_channel = video_channel
        self.video_quality = video_quality

    def to_bytes(self, boxed: bool=True):
        with Writer(b'*\xa9\x98\x05' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.call,
                    group_id=0XDA9A559A
                )
                writer.long(self.time_ms)
                writer.int(self.scale)

                if flags(self.video_channel, 0):
                    writer.int(self.video_channel)

                if flags(self.video_quality, 0):
                    writer.int(self.video_quality)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        call_ = reader.object(
            group_id=0XDA9A559A
        )

        time_ms_ = reader.long()
        scale_ = reader.int()
        video_channel_ = (
            reader.int()
            if flags(0) else None
        )

        video_quality_ = (
            reader.int()
            if flags(0) else None
        )

        return cls(
            call=call_,
            time_ms=time_ms_,
            scale=scale_,
            video_channel=video_channel_,
            video_quality=video_quality_
        )

TypeInputFileLocation = Union[
    InputFileLocation,
    InputEncryptedFileLocation,
    InputDocumentFileLocation,
    InputSecureFileLocation,
    InputTakeoutFileLocation,
    InputPhotoFileLocation,
    InputPhotoLegacyFileLocation,
    InputPeerPhotoFileLocation,
    InputStickerSetThumb,
    InputGroupCallStream
]