
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Long, Writer


if TYPE_CHECKING:
    from .input_media import TypeInputMedia
    from .message_entity import TypeMessageEntity
    from ...gadgets.byteutils import Reader


class InputSingleMedia(TLObject, family='TypeInputSingleMedia'):
    """
    A single media in an [album or grouped media](https://core.telegram.org/api/files#albums-grouped-media) sent with [messages.sendMultiMedia](https://core.telegram.org/method/messages.sendMultiMedia).
    """

    _id = 0X1CC6E91F
    _group_id = 0XB1D9AD4B

    def __init__(
        self,
        media: 'TypeInputMedia',
        message: str,
        entities: Optional[List['TypeMessageEntity']] = None,
        random_id: int = None
    ):

        """
        A single media in an [album or grouped media](https://core.telegram.org/api/files#albums-grouped-media) sent with [messages.sendMultiMedia](https://core.telegram.org/method/messages.sendMultiMedia).

        Args:
            media ('TypeInputMedia'): The media
            message (str): A caption for the media
            entities (Optional[List['TypeMessageEntity']], optional): Message [entities](https://core.telegram.org/api/entities) for styled text
            random_id (int, optional): Unique client media ID required to prevent message resending
        """

        self.media = media
        self.message = message
        self.entities = entities
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1f\xe9\xc6\x1c' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.media,
                    group_id=0XCEC6DE21
                )
                writer.long(self.random_id)
                writer.string(self.message)

                if flags(self.entities, 0):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        media_ = reader.object(
            group_id=0XCEC6DE21
        )

        random_id_ = reader.long()
        message_ = reader.string()
        entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(0) else None
        )

        return cls(
            media=media_,
            random_id=random_id_,
            message=message_,
            entities=entities_
        )

TypeInputSingleMedia = InputSingleMedia