
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, Optional, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .game import TypeGame
    from .poll import TypePoll
    from .peer import TypePeer
    from .photo import TypePhoto
    from .document import TypeDocument
    from .web_page import TypeWebPage
    from .geo_point import TypeGeoPoint
    from .todo_list import TypeTodoList
    from .story_item import TypeStoryItem
    from .web_document import TypeWebDocument
    from .poll_results import TypePollResults
    from .todo_completion import TypeTodoCompletion
    from ...gadgets.byteutils import Reader
    from .message_extended_media import TypeMessageExtendedMedia


class MessageMediaEmpty(TLObject, family='TypeMessageMedia'):
    """
    Empty constructor.
    """

    _id = 0X3DED6320
    _group_id = 0X45F7A020


    def to_bytes(self, boxed: bool=True):
        return b' c\xed=' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class MessageMediaPhoto(TLObject, family='TypeMessageMedia'):
    """
    Attached photo.
    """

    _id = 0X695150D7
    _group_id = 0X45F7A020

    def __init__(
        self,
        spoiler: bool = False,
        photo: Optional['TypePhoto'] = None,
        ttl_seconds: Optional[int] = None
    ):

        """
        Attached photo.

        Args:
            spoiler (bool, optional): Whether this media should be hidden behind a spoiler warning
            photo (Optional['TypePhoto'], optional): Photo
            ttl_seconds (Optional[int], optional): Time to live in seconds of self-destructing photo
        """

        self.spoiler = spoiler
        self.photo = photo
        self.ttl_seconds = ttl_seconds

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd7PQi' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.spoiler, 3)

                if flags(self.photo, 0):
                    writer.object(
                        self.photo,
                        group_id=0XDDAD9CAC
                    )

                if flags(self.ttl_seconds, 2):
                    writer.int(self.ttl_seconds)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        photo_ = (
            reader.object(
                group_id=0XDDAD9CAC
            )
            if flags(0) else None
        )

        ttl_seconds_ = (
            reader.int()
            if flags(2) else None
        )

        return cls(
            spoiler=flags(3),
            photo=photo_,
            ttl_seconds=ttl_seconds_
        )

class MessageMediaGeo(TLObject, family='TypeMessageMedia'):
    """
    Attached map.
    """

    _id = 0X56E0D474
    _group_id = 0X45F7A020

    def __init__(
        self,
        geo: 'TypeGeoPoint'
    ):

        """
        Attached map.

        Args:
            geo ('TypeGeoPoint'): GeoPoint
        """

        self.geo = geo

    def to_bytes(self, boxed: bool=True):
        with Writer(b't\xd4\xe0V' if boxed else b'') as writer:
            writer.object(
                self.geo,
                group_id=0X9248B41D
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        geo_ = reader.object(
            group_id=0X9248B41D
        )

        return cls(
            geo=geo_
        )

class MessageMediaContact(TLObject, family='TypeMessageMedia'):
    """
    Attached contact.
    """

    _id = 0X70322949
    _group_id = 0X45F7A020

    def __init__(
        self,
        phone_number: str,
        first_name: str,
        last_name: str,
        vcard: str,
        user_id: int
    ):

        """
        Attached contact.

        Args:
            phone_number (str): Phone number
            first_name (str): Contact's first name
            last_name (str): Contact's last name
            vcard (str): VCARD of contact
            user_id (int): User identifier or 0, if the user with the given phone number is not registered
        """

        self.phone_number = phone_number
        self.first_name = first_name
        self.last_name = last_name
        self.vcard = vcard
        self.user_id = user_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'I)2p' if boxed else b'') as writer:
            writer.string(self.phone_number)
            writer.string(self.first_name)
            writer.string(self.last_name)
            writer.string(self.vcard)
            writer.long(self.user_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        phone_number_ = reader.string()
        first_name_ = reader.string()
        last_name_ = reader.string()
        vcard_ = reader.string()
        user_id_ = reader.long()

        return cls(
            phone_number=phone_number_,
            first_name=first_name_,
            last_name=last_name_,
            vcard=vcard_,
            user_id=user_id_
        )

class MessageMediaUnsupported(TLObject, family='TypeMessageMedia'):
    """
    Current version of the client does not support this media type.
    """

    _id = 0X9F84F49E
    _group_id = 0X45F7A020


    def to_bytes(self, boxed: bool=True):
        return b'\x9e\xf4\x84\x9f' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class MessageMediaDocument(TLObject, family='TypeMessageMedia'):
    """
    Document (video, audio, voice, sticker, any media type except photo)
    """

    _id = 0X52D8CCD9
    _group_id = 0X45F7A020

    def __init__(
        self,
        nopremium: bool = False,
        spoiler: bool = False,
        video: bool = False,
        round: bool = False,
        voice: bool = False,
        document: Optional['TypeDocument'] = None,
        alt_documents: Optional[List['TypeDocument']] = None,
        video_cover: Optional['TypePhoto'] = None,
        video_timestamp: Optional[int] = None,
        ttl_seconds: Optional[int] = None
    ):

        """
        Document (video, audio, voice, sticker, any media type except photo)

        Args:
            nopremium (bool, optional): Whether this is a normal sticker, if not set this is a premium sticker and a premium sticker animation must be played.
            spoiler (bool, optional): Whether this media should be hidden behind a spoiler warning
            video (bool, optional): Whether this is a video.
            round (bool, optional): Whether this is a round video.
            voice (bool, optional): Whether this is a voice message.
            document (Optional['TypeDocument'], optional): Attached document
            alt_documents (Optional[List['TypeDocument']], optional): Videos only, contains alternative qualities of the video.
            video_cover (Optional['TypePhoto'], optional): ...
            video_timestamp (Optional[int], optional): ...
            ttl_seconds (Optional[int], optional): Time to live of self-destructing document
        """

        self.nopremium = nopremium
        self.spoiler = spoiler
        self.video = video
        self.round = round
        self.voice = voice
        self.document = document
        self.alt_documents = alt_documents
        self.video_cover = video_cover
        self.video_timestamp = video_timestamp
        self.ttl_seconds = ttl_seconds

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd9\xcc\xd8R' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.nopremium, 3)
                flags(self.spoiler, 4)
                flags(self.video, 6)
                flags(self.round, 7)
                flags(self.voice, 8)

                if flags(self.document, 0):
                    writer.object(
                        self.document,
                        group_id=0X6547BD50
                    )

                if flags(self.alt_documents, 5):
                    writer.vector(
                        self.alt_documents,
                        lambda value: writer.object(
                            value,
                            group_id=0X6547BD50
                        )
                    )

                if flags(self.video_cover, 9):
                    writer.object(
                        self.video_cover,
                        group_id=0XDDAD9CAC
                    )

                if flags(self.video_timestamp, 10):
                    writer.int(self.video_timestamp)

                if flags(self.ttl_seconds, 2):
                    writer.int(self.ttl_seconds)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        document_ = (
            reader.object(
                group_id=0X6547BD50
            )
            if flags(0) else None
        )

        alt_documents_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X6547BD50
                )
            )
            if flags(5) else None
        )

        video_cover_ = (
            reader.object(
                group_id=0XDDAD9CAC
            )
            if flags(9) else None
        )

        video_timestamp_ = (
            reader.int()
            if flags(10) else None
        )

        ttl_seconds_ = (
            reader.int()
            if flags(2) else None
        )

        return cls(
            nopremium=flags(3),
            spoiler=flags(4),
            video=flags(6),
            round=flags(7),
            voice=flags(8),
            document=document_,
            alt_documents=alt_documents_,
            video_cover=video_cover_,
            video_timestamp=video_timestamp_,
            ttl_seconds=ttl_seconds_
        )

class MessageMediaWebPage(TLObject, family='TypeMessageMedia'):
    """
    Preview of webpage
    """

    _id = 0XDDF10C3B
    _group_id = 0X45F7A020

    def __init__(
        self,
        webpage: 'TypeWebPage',
        force_large_media: bool = False,
        force_small_media: bool = False,
        manual: bool = False,
        safe: bool = False
    ):

        """
        Preview of webpage

        Args:
            webpage ('TypeWebPage'): Webpage preview
            force_large_media (bool, optional): If set, specifies that a large media preview should be used.
            force_small_media (bool, optional): If set, specifies that a small media preview should be used.
            manual (bool, optional): If set, indicates that the URL used for the webpage preview was specified manually using [inputMediaWebPage](https://core.telegram.org/constructor/inputMediaWebPage), and may not be related to any of the URLs specified in the message.
            safe (bool, optional): If set, the webpage can be opened directly without user confirmation; otherwise, user confirmation is required, showing the exact URL that will be opened.
        """

        self.webpage = webpage
        self.force_large_media = force_large_media
        self.force_small_media = force_small_media
        self.manual = manual
        self.safe = safe

    def to_bytes(self, boxed: bool=True):
        with Writer(b';\x0c\xf1\xdd' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.force_large_media, 0)
                flags(self.force_small_media, 1)
                flags(self.manual, 3)
                flags(self.safe, 4)
                writer.object(
                    self.webpage,
                    group_id=0X9D177ED
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        webpage_ = reader.object(
            group_id=0X9D177ED
        )

        return cls(
            webpage=webpage_,
            force_large_media=flags(0),
            force_small_media=flags(1),
            manual=flags(3),
            safe=flags(4)
        )

class MessageMediaVenue(TLObject, family='TypeMessageMedia'):
    """
    Venue
    """

    _id = 0X2EC0533F
    _group_id = 0X45F7A020

    def __init__(
        self,
        geo: 'TypeGeoPoint',
        title: str,
        address: str,
        provider: str,
        venue_id: str,
        venue_type: str
    ):

        """
        Venue

        Args:
            geo ('TypeGeoPoint'): Geolocation of venue
            title (str): Venue name
            address (str): Address
            provider (str): Venue provider: currently only "foursquare" and "gplaces" (Google Places) need to be supported
            venue_id (str): Venue ID in the provider's database
            venue_type (str): Venue type in the provider's database
        """

        self.geo = geo
        self.title = title
        self.address = address
        self.provider = provider
        self.venue_id = venue_id
        self.venue_type = venue_type

    def to_bytes(self, boxed: bool=True):
        with Writer(b'?S\xc0.' if boxed else b'') as writer:
            writer.object(
                self.geo,
                group_id=0X9248B41D
            )
            writer.string(self.title)
            writer.string(self.address)
            writer.string(self.provider)
            writer.string(self.venue_id)
            writer.string(self.venue_type)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        geo_ = reader.object(
            group_id=0X9248B41D
        )

        title_ = reader.string()
        address_ = reader.string()
        provider_ = reader.string()
        venue_id_ = reader.string()
        venue_type_ = reader.string()

        return cls(
            geo=geo_,
            title=title_,
            address=address_,
            provider=provider_,
            venue_id=venue_id_,
            venue_type=venue_type_
        )

class MessageMediaGame(TLObject, family='TypeMessageMedia'):
    """
    Telegram game
    """

    _id = 0XFDB19008
    _group_id = 0X45F7A020

    def __init__(
        self,
        game: 'TypeGame'
    ):

        """
        Telegram game

        Args:
            game ('TypeGame'): Game
        """

        self.game = game

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x08\x90\xb1\xfd' if boxed else b'') as writer:
            writer.object(
                self.game,
                group_id=0X351303FF
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        game_ = reader.object(
            group_id=0X351303FF
        )

        return cls(
            game=game_
        )

class MessageMediaInvoice(TLObject, family='TypeMessageMedia'):
    """
    Invoice
    """

    _id = 0XF6A548D3
    _group_id = 0X45F7A020

    def __init__(
        self,
        title: str,
        description: str,
        currency: str,
        total_amount: int,
        start_param: str,
        shipping_address_requested: bool = False,
        test: bool = False,
        photo: Optional['TypeWebDocument'] = None,
        receipt_msg_id: Optional[int] = None,
        extended_media: Optional['TypeMessageExtendedMedia'] = None
    ):

        """
        Invoice

        Args:
            title (str): Product name, 1-32 characters
            description (str): Product description, 1-255 characters
            currency (str): Three-letter ISO 4217 [currency](https://core.telegram.org/bots/payments#supported-currencies) code, or XTR for [Telegram Stars](https://core.telegram.org/api/stars).
            total_amount (int): Total price in the smallest units of the currency (integer, not float/double). For example, for a price of US$ 1.45 pass amount = 145. See the exp parameter in [currencies.json](https://core.telegram.org/bots/payments/currencies.json), it shows the number of digits past the decimal point for each currency (2 for the majority of currencies).
            start_param (str): Unique bot deep-linking parameter that can be used to generate this invoice
            shipping_address_requested (bool, optional): Whether the shipping address was requested
            test (bool, optional): Whether this is an example invoice
            photo (Optional['TypeWebDocument'], optional): URL of the product photo for the invoice. Can be a photo of the goods or a marketing image for a service. People like it better when they see what they are paying for.
            receipt_msg_id (Optional[int], optional): Message ID of receipt: if set, clients should change the text of the first [keyboardButtonBuy](https://core.telegram.org/constructor/keyboardButtonBuy) button always attached to the [message](https://core.telegram.org/constructor/message) to a localized version of the word Receipt
            extended_media (Optional['TypeMessageExtendedMedia'], optional): Deprecated
        """

        self.title = title
        self.description = description
        self.currency = currency
        self.total_amount = total_amount
        self.start_param = start_param
        self.shipping_address_requested = shipping_address_requested
        self.test = test
        self.photo = photo
        self.receipt_msg_id = receipt_msg_id
        self.extended_media = extended_media

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd3H\xa5\xf6' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.shipping_address_requested, 1)
                flags(self.test, 3)
                writer.string(self.title)
                writer.string(self.description)

                if flags(self.photo, 0):
                    writer.object(
                        self.photo,
                        group_id=0XCDE930D7
                    )

                if flags(self.receipt_msg_id, 2):
                    writer.int(self.receipt_msg_id)
                writer.string(self.currency)
                writer.long(self.total_amount)
                writer.string(self.start_param)

                if flags(self.extended_media, 4):
                    writer.object(
                        self.extended_media,
                        group_id=0X9339BD78
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        title_ = reader.string()
        description_ = reader.string()
        photo_ = (
            reader.object(
                group_id=0XCDE930D7
            )
            if flags(0) else None
        )

        receipt_msg_id_ = (
            reader.int()
            if flags(2) else None
        )

        currency_ = reader.string()
        total_amount_ = reader.long()
        start_param_ = reader.string()
        extended_media_ = (
            reader.object(
                group_id=0X9339BD78
            )
            if flags(4) else None
        )

        return cls(
            title=title_,
            description=description_,
            currency=currency_,
            total_amount=total_amount_,
            start_param=start_param_,
            shipping_address_requested=flags(1),
            test=flags(3),
            photo=photo_,
            receipt_msg_id=receipt_msg_id_,
            extended_media=extended_media_
        )

class MessageMediaGeoLive(TLObject, family='TypeMessageMedia'):
    """
    Indicates a [live geolocation](https://core.telegram.org/api/live-location)
    """

    _id = 0XB940C666
    _group_id = 0X45F7A020

    def __init__(
        self,
        geo: 'TypeGeoPoint',
        period: int,
        heading: Optional[int] = None,
        proximity_notification_radius: Optional[int] = None
    ):

        """
        Indicates a [live geolocation](https://core.telegram.org/api/live-location)

        Args:
            geo ('TypeGeoPoint'): Geolocation
            period (int): Validity period of provided geolocation
            heading (Optional[int], optional): For [live locations](https://core.telegram.org/api/live-location), a direction in which the location moves, in degrees; 1-360
            proximity_notification_radius (Optional[int], optional): For [live locations](https://core.telegram.org/api/live-location), a maximum distance to another chat member for proximity alerts, in meters (0-100000).
        """

        self.geo = geo
        self.period = period
        self.heading = heading
        self.proximity_notification_radius = proximity_notification_radius

    def to_bytes(self, boxed: bool=True):
        with Writer(b'f\xc6@\xb9' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.geo,
                    group_id=0X9248B41D
                )

                if flags(self.heading, 0):
                    writer.int(self.heading)
                writer.int(self.period)

                if flags(self.proximity_notification_radius, 1):
                    writer.int(self.proximity_notification_radius)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        geo_ = reader.object(
            group_id=0X9248B41D
        )

        heading_ = (
            reader.int()
            if flags(0) else None
        )

        period_ = reader.int()
        proximity_notification_radius_ = (
            reader.int()
            if flags(1) else None
        )

        return cls(
            geo=geo_,
            period=period_,
            heading=heading_,
            proximity_notification_radius=proximity_notification_radius_
        )

class MessageMediaPoll(TLObject, family='TypeMessageMedia'):
    """
    Poll
    """

    _id = 0X4BD6E798
    _group_id = 0X45F7A020

    def __init__(
        self,
        poll: 'TypePoll',
        results: 'TypePollResults'
    ):

        """
        Poll

        Args:
            poll ('TypePoll'): The poll
            results ('TypePollResults'): The results of the poll
        """

        self.poll = poll
        self.results = results

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x98\xe7\xd6K' if boxed else b'') as writer:
            writer.object(
                self.poll,
                group_id=0X9284C836
            )
            writer.object(
                self.results,
                group_id=0X3539EE44
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        poll_ = reader.object(
            group_id=0X9284C836
        )

        results_ = reader.object(
            group_id=0X3539EE44
        )

        return cls(
            poll=poll_,
            results=results_
        )

class MessageMediaDice(TLObject, family='TypeMessageMedia'):
    """
    [Dice-based animated sticker](https://core.telegram.org/api/dice)
    """

    _id = 0X3F7EE58B
    _group_id = 0X45F7A020

    def __init__(
        self,
        value: int,
        emoticon: str
    ):

        """
        [Dice-based animated sticker](https://core.telegram.org/api/dice)

        Args:
            value (int): [Dice value](https://core.telegram.org/api/dice)
            emoticon (str): The emoji, for now ,  and  are supported
        """

        self.value = value
        self.emoticon = emoticon

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x8b\xe5~?' if boxed else b'') as writer:
            writer.int(self.value)
            writer.string(self.emoticon)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        value_ = reader.int()
        emoticon_ = reader.string()

        return cls(
            value=value_,
            emoticon=emoticon_
        )

class MessageMediaStory(TLObject, family='TypeMessageMedia'):
    """
    Represents a forwarded [story](https://core.telegram.org/api/stories) or a story mention.
    """

    _id = 0X68CB6283
    _group_id = 0X45F7A020

    def __init__(
        self,
        peer: 'TypePeer',
        id: int,
        via_mention: bool = False,
        story: Optional['TypeStoryItem'] = None
    ):

        """
        Represents a forwarded [story](https://core.telegram.org/api/stories) or a story mention.

        Args:
            peer ('TypePeer'): Peer that posted the story.
            id (int): Story ID
            via_mention (bool, optional): If set, indicates that this someone has mentioned us in this story (i.e. by tagging us in the description) or vice versa, we have mentioned the other peer (if the message is outgoing).
            story (Optional['TypeStoryItem'], optional): The story itself, if absent fetch it using [stories.getStoriesByID](https://core.telegram.org/method/stories.getStoriesByID) and the peer/ id parameters specified above.
        """

        self.peer = peer
        self.id = id
        self.via_mention = via_mention
        self.story = story

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x83b\xcbh' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.via_mention, 1)
                writer.object(
                    self.peer,
                    group_id=0XB4DECBCA
                )
                writer.int(self.id)

                if flags(self.story, 0):
                    writer.object(
                        self.story,
                        group_id=0X8436985A
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        id_ = reader.int()
        story_ = (
            reader.object(
                group_id=0X8436985A
            )
            if flags(0) else None
        )

        return cls(
            peer=peer_,
            id=id_,
            via_mention=flags(1),
            story=story_
        )

class MessageMediaGiveaway(TLObject, family='TypeMessageMedia'):
    """
    Contains info about a [giveaway, see here](https://core.telegram.org/api/giveaways) for more info.
    """

    _id = 0XAA073BEB
    _group_id = 0X45F7A020

    def __init__(
        self,
        channels: List[int],
        quantity: int,
        until_date: int,
        only_new_subscribers: bool = False,
        winners_are_visible: bool = False,
        countries_iso2: Optional[List[str]] = None,
        prize_description: Optional[str] = None,
        months: Optional[int] = None,
        stars: Optional[int] = None
    ):

        """
        Contains info about a [giveaway, see here](https://core.telegram.org/api/giveaways) for more info.

        Args:
            channels (List[int]): The channels that the user must join to participate in the giveaway.
            quantity (int): Number of [Telegram Premium](https://core.telegram.org/api/premium) subscriptions given away.
            until_date (int): The end date of the giveaway.
            only_new_subscribers (bool, optional): If set, only new subscribers starting from the giveaway creation date will be able to participate to the giveaway.
            winners_are_visible (bool, optional): If set, giveaway winners are public and will be listed in a [messageMediaGiveawayResults](https://core.telegram.org/constructor/messageMediaGiveawayResults) message that will be automatically sent to the channel once the giveaway ends.
            countries_iso2 (Optional[List[str]], optional): If set, only users residing in these countries can participate in the giveaway, (specified as a list of two-letter ISO 3166-1 alpha-2 country codes); otherwise there are no country-based limitations.
            prize_description (Optional[str], optional): Can contain a textual description of additional giveaway prizes.
            months (Optional[int], optional): Duration in months of each [Telegram Premium](https://core.telegram.org/api/premium) subscription in the giveaway.
            stars (Optional[int], optional): For [Telegram Star giveaways](https://core.telegram.org/api/stars#star-giveaways), the total number of Telegram Stars being given away.
        """

        self.channels = channels
        self.quantity = quantity
        self.until_date = until_date
        self.only_new_subscribers = only_new_subscribers
        self.winners_are_visible = winners_are_visible
        self.countries_iso2 = countries_iso2
        self.prize_description = prize_description
        self.months = months
        self.stars = stars

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xeb;\x07\xaa' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.only_new_subscribers, 0)
                flags(self.winners_are_visible, 2)
                writer.vector(
                    self.channels,
                    writer.long
                )

                if flags(self.countries_iso2, 1):
                    writer.vector(
                        self.countries_iso2,
                        writer.string
                    )

                if flags(self.prize_description, 3):
                    writer.string(self.prize_description)
                writer.int(self.quantity)

                if flags(self.months, 4):
                    writer.int(self.months)

                if flags(self.stars, 5):
                    writer.long(self.stars)
                writer.int(self.until_date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        channels_ = reader.vector(
            reader.long
        )

        countries_iso2_ = (
            reader.vector(
                reader.string
            )
            if flags(1) else None
        )

        prize_description_ = (
            reader.string()
            if flags(3) else None
        )

        quantity_ = reader.int()
        months_ = (
            reader.int()
            if flags(4) else None
        )

        stars_ = (
            reader.long()
            if flags(5) else None
        )

        until_date_ = reader.int()

        return cls(
            channels=channels_,
            quantity=quantity_,
            until_date=until_date_,
            only_new_subscribers=flags(0),
            winners_are_visible=flags(2),
            countries_iso2=countries_iso2_,
            prize_description=prize_description_,
            months=months_,
            stars=stars_
        )

class MessageMediaGiveawayResults(TLObject, family='TypeMessageMedia'):
    """
    A [giveaway](https://core.telegram.org/api/giveaways) with public winners has finished, this constructor contains info about the winners.
    """

    _id = 0XCEAA3EA1
    _group_id = 0X45F7A020

    def __init__(
        self,
        channel_id: int,
        launch_msg_id: int,
        winners_count: int,
        unclaimed_count: int,
        winners: List[int],
        until_date: int,
        only_new_subscribers: bool = False,
        refunded: bool = False,
        additional_peers_count: Optional[int] = None,
        months: Optional[int] = None,
        stars: Optional[int] = None,
        prize_description: Optional[str] = None
    ):

        """
        A [giveaway](https://core.telegram.org/api/giveaways) with public winners has finished, this constructor contains info about the winners.

        Args:
            channel_id (int): ID of the channel/supergroup that was automatically [boosted](https://core.telegram.org/api/boost) by the winners of the giveaway for duration of the Premium subscription.
            launch_msg_id (int): Identifier of the message with the giveaway in channel_id.
            winners_count (int): Total number of winners in the giveaway.
            unclaimed_count (int): Number of not-yet-claimed prizes.
            winners (List[int]): Up to 100 user identifiers of the winners of the giveaway.
            until_date (int): Point in time (Unix timestamp) when the winners were selected. May be bigger than winners selection date specified in initial parameters of the giveaway.
            only_new_subscribers (bool, optional): If set, only new subscribers starting from the giveaway creation date participated in the giveaway.
            refunded (bool, optional): If set, the giveaway was canceled and was fully refunded.
            additional_peers_count (Optional[int], optional): Number of other channels that participated in the giveaway.
            months (Optional[int], optional): Duration in months of each [Telegram Premium](https://core.telegram.org/api/premium) subscription in the giveaway.
            stars (Optional[int], optional): For [Telegram Star giveaways](https://core.telegram.org/api/stars#star-giveaways), the total number of Telegram Stars being given away.
            prize_description (Optional[str], optional): Can contain a textual description of additional giveaway prizes.
        """

        self.channel_id = channel_id
        self.launch_msg_id = launch_msg_id
        self.winners_count = winners_count
        self.unclaimed_count = unclaimed_count
        self.winners = winners
        self.until_date = until_date
        self.only_new_subscribers = only_new_subscribers
        self.refunded = refunded
        self.additional_peers_count = additional_peers_count
        self.months = months
        self.stars = stars
        self.prize_description = prize_description

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa1>\xaa\xce' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.only_new_subscribers, 0)
                flags(self.refunded, 2)
                writer.long(self.channel_id)

                if flags(self.additional_peers_count, 3):
                    writer.int(self.additional_peers_count)
                writer.int(self.launch_msg_id)
                writer.int(self.winners_count)
                writer.int(self.unclaimed_count)
                writer.vector(
                    self.winners,
                    writer.long
                )

                if flags(self.months, 4):
                    writer.int(self.months)

                if flags(self.stars, 5):
                    writer.long(self.stars)

                if flags(self.prize_description, 1):
                    writer.string(self.prize_description)
                writer.int(self.until_date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        channel_id_ = reader.long()
        additional_peers_count_ = (
            reader.int()
            if flags(3) else None
        )

        launch_msg_id_ = reader.int()
        winners_count_ = reader.int()
        unclaimed_count_ = reader.int()
        winners_ = reader.vector(
            reader.long
        )

        months_ = (
            reader.int()
            if flags(4) else None
        )

        stars_ = (
            reader.long()
            if flags(5) else None
        )

        prize_description_ = (
            reader.string()
            if flags(1) else None
        )

        until_date_ = reader.int()

        return cls(
            channel_id=channel_id_,
            launch_msg_id=launch_msg_id_,
            winners_count=winners_count_,
            unclaimed_count=unclaimed_count_,
            winners=winners_,
            until_date=until_date_,
            only_new_subscribers=flags(0),
            refunded=flags(2),
            additional_peers_count=additional_peers_count_,
            months=months_,
            stars=stars_,
            prize_description=prize_description_
        )

class MessageMediaPaidMedia(TLObject, family='TypeMessageMedia'):
    """
    [Paid media, see here](https://core.telegram.org/api/paid-media) for more info.
    """

    _id = 0XA8852491
    _group_id = 0X45F7A020

    def __init__(
        self,
        stars_amount: int,
        extended_media: List['TypeMessageExtendedMedia']
    ):

        """
        [Paid media, see here](https://core.telegram.org/api/paid-media) for more info.

        Args:
            stars_amount (int): The price of the media in [Telegram Stars](https://core.telegram.org/api/stars).
            extended_media (List['TypeMessageExtendedMedia']): Either the paid-for media, or super low resolution media previews if the media wasn't purchased yet, [see here](https://core.telegram.org/api/paid-media#viewing-paid-media) for more info.
        """

        self.stars_amount = stars_amount
        self.extended_media = extended_media

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x91$\x85\xa8' if boxed else b'') as writer:
            writer.long(self.stars_amount)
            writer.vector(
                self.extended_media,
                lambda value: writer.object(
                    value,
                    group_id=0X9339BD78
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        stars_amount_ = reader.long()
        extended_media_ = reader.vector(
            lambda: reader.object(
                group_id=0X9339BD78
            )
        )

        return cls(
            stars_amount=stars_amount_,
            extended_media=extended_media_
        )

class MessageMediaToDo(TLObject, family='TypeMessageMedia'):
    _id = 0X8A53B014
    _group_id = 0X45F7A020

    def __init__(
        self,
        todo: 'TypeTodoList',
        completions: Optional[List['TypeTodoCompletion']] = None
    ):

        self.todo = todo
        self.completions = completions

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x14\xb0S\x8a' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.todo,
                    group_id=0XC0516EC3
                )

                if flags(self.completions, 0):
                    writer.vector(
                        self.completions,
                        lambda value: writer.object(
                            value,
                            group_id=0X381D1450
                        )
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        todo_ = reader.object(
            group_id=0XC0516EC3
        )

        completions_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X381D1450
                )
            )
            if flags(0) else None
        )

        return cls(
            todo=todo_,
            completions=completions_
        )

TypeMessageMedia = Union[
    MessageMediaEmpty,
    MessageMediaPhoto,
    MessageMediaGeo,
    MessageMediaContact,
    MessageMediaUnsupported,
    MessageMediaDocument,
    MessageMediaWebPage,
    MessageMediaVenue,
    MessageMediaGame,
    MessageMediaInvoice,
    MessageMediaGeoLive,
    MessageMediaPoll,
    MessageMediaDice,
    MessageMediaStory,
    MessageMediaGiveaway,
    MessageMediaGiveawayResults,
    MessageMediaPaidMedia,
    MessageMediaToDo
]