
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Optional, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from .message_media import TypeMessageMedia
    from .message_entity import TypeMessageEntity
    from .message_fwd_header import TypeMessageFwdHeader
    from ...gadgets.byteutils import Reader


class MessageReplyHeader(TLObject, family='TypeMessageReplyHeader'):
    """
    Message replies and [thread](https://core.telegram.org/api/threads) information
    """

    _id = 0X6917560B
    _group_id = 0XA346A9DF

    def __init__(
        self,
        reply_to_scheduled: bool = False,
        forum_topic: bool = False,
        quote: bool = False,
        reply_to_msg_id: Optional[int] = None,
        reply_to_peer_id: Optional['TypePeer'] = None,
        reply_from: Optional['TypeMessageFwdHeader'] = None,
        reply_media: Optional['TypeMessageMedia'] = None,
        reply_to_top_id: Optional[int] = None,
        quote_text: Optional[str] = None,
        quote_entities: Optional[List['TypeMessageEntity']] = None,
        quote_offset: Optional[int] = None,
        todo_item_id: Optional[int] = None
    ):

        """
        Message replies and [thread](https://core.telegram.org/api/threads) information

        Args:
            reply_to_scheduled (bool, optional): This is a reply to a scheduled message.
            forum_topic (bool, optional): Whether this message was sent in a [forum topic](https://core.telegram.org/api/forum#forum-topics) (except for the General topic).
            quote (bool, optional): Whether this message is quoting a part of another message.
            reply_to_msg_id (Optional[int], optional): ID of message to which this message is replying
            reply_to_peer_id (Optional['TypePeer'], optional): For replies sent in [channel discussion threads](https://core.telegram.org/api/threads) of which the current user is not a member, the discussion group ID
            reply_from (Optional['TypeMessageFwdHeader'], optional): When replying to a message sent by a certain peer to another chat, contains info about the peer that originally sent the message to that other chat.
            reply_media (Optional['TypeMessageMedia'], optional): When replying to a media sent by a certain peer to another chat, contains the media of the replied-to message.
            reply_to_top_id (Optional[int], optional): ID of the message that started this [message thread](https://core.telegram.org/api/threads)
            quote_text (Optional[str], optional): Used to quote-reply to only a certain section (specified here) of the original message.
            quote_entities (Optional[List['TypeMessageEntity']], optional): [Message entities for styled text](https://core.telegram.org/api/entities) from the quote_text field.
            quote_offset (Optional[int], optional): Offset of the message quote_text within the original message (in [UTF-16 code units](https://core.telegram.org/api/entities#entity-length)).
            todo_item_id (Optional[int], optional): ...
        """

        self.reply_to_scheduled = reply_to_scheduled
        self.forum_topic = forum_topic
        self.quote = quote
        self.reply_to_msg_id = reply_to_msg_id
        self.reply_to_peer_id = reply_to_peer_id
        self.reply_from = reply_from
        self.reply_media = reply_media
        self.reply_to_top_id = reply_to_top_id
        self.quote_text = quote_text
        self.quote_entities = quote_entities
        self.quote_offset = quote_offset
        self.todo_item_id = todo_item_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x0bV\x17i' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.reply_to_scheduled, 2)
                flags(self.forum_topic, 3)
                flags(self.quote, 9)

                if flags(self.reply_to_msg_id, 4):
                    writer.int(self.reply_to_msg_id)

                if flags(self.reply_to_peer_id, 0):
                    writer.object(
                        self.reply_to_peer_id,
                        group_id=0XB4DECBCA
                    )

                if flags(self.reply_from, 5):
                    writer.object(
                        self.reply_from,
                        group_id=0XEA3B4B97
                    )

                if flags(self.reply_media, 8):
                    writer.object(
                        self.reply_media,
                        group_id=0X45F7A020
                    )

                if flags(self.reply_to_top_id, 1):
                    writer.int(self.reply_to_top_id)

                if flags(self.quote_text, 6):
                    writer.string(self.quote_text)

                if flags(self.quote_entities, 7):
                    writer.vector(
                        self.quote_entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

                if flags(self.quote_offset, 10):
                    writer.int(self.quote_offset)

                if flags(self.todo_item_id, 11):
                    writer.int(self.todo_item_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        reply_to_msg_id_ = (
            reader.int()
            if flags(4) else None
        )

        reply_to_peer_id_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(0) else None
        )

        reply_from_ = (
            reader.object(
                group_id=0XEA3B4B97
            )
            if flags(5) else None
        )

        reply_media_ = (
            reader.object(
                group_id=0X45F7A020
            )
            if flags(8) else None
        )

        reply_to_top_id_ = (
            reader.int()
            if flags(1) else None
        )

        quote_text_ = (
            reader.string()
            if flags(6) else None
        )

        quote_entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(7) else None
        )

        quote_offset_ = (
            reader.int()
            if flags(10) else None
        )

        todo_item_id_ = (
            reader.int()
            if flags(11) else None
        )

        return cls(
            reply_to_scheduled=flags(2),
            forum_topic=flags(3),
            quote=flags(9),
            reply_to_msg_id=reply_to_msg_id_,
            reply_to_peer_id=reply_to_peer_id_,
            reply_from=reply_from_,
            reply_media=reply_media_,
            reply_to_top_id=reply_to_top_id_,
            quote_text=quote_text_,
            quote_entities=quote_entities_,
            quote_offset=quote_offset_,
            todo_item_id=todo_item_id_
        )

class MessageReplyStoryHeader(TLObject, family='TypeMessageReplyHeader'):
    """
    Represents a reply to a [story](https://core.telegram.org/api/stories)
    """

    _id = 0XE5AF939
    _group_id = 0XA346A9DF

    def __init__(
        self,
        peer: 'TypePeer',
        story_id: int
    ):

        """
        Represents a reply to a [story](https://core.telegram.org/api/stories)

        Args:
            peer ('TypePeer'): Sender of the story.
            story_id (int): Story ID
        """

        self.peer = peer
        self.story_id = story_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'9\xf9Z\x0e' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0XB4DECBCA
            )
            writer.int(self.story_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        story_id_ = reader.int()

        return cls(
            peer=peer_,
            story_id=story_id_
        )

TypeMessageReplyHeader = Union[
    MessageReplyHeader,
    MessageReplyStoryHeader
]