
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ....gadgets.byteutils import Reader
    from ..message_peer_reaction import TypeMessagePeerReaction


class MessageReactionsList(TLObject, family='TypeMessagesMessageReactionsList'):
    """
    List of peers that reacted to a specific message
    """

    _id = 0X31BD492D
    _group_id = 0X533A36D2

    def __init__(
        self,
        count: int,
        reactions: List['TypeMessagePeerReaction'],
        chats: List['TypeChat'],
        users: List['TypeUser'],
        next_offset: Optional[str] = None
    ):

        """
        List of peers that reacted to a specific message

        Args:
            count (int): Total number of reactions matching query
            reactions (List['TypeMessagePeerReaction']): List of peers that reacted to a specific message
            chats (List['TypeChat']): Mentioned chats
            users (List['TypeUser']): Mentioned users
            next_offset (Optional[str], optional): If set, indicates the next offset to use to load more results by invoking [messages.getMessageReactionsList](https://core.telegram.org/method/messages.getMessageReactionsList).
        """

        self.count = count
        self.reactions = reactions
        self.chats = chats
        self.users = users
        self.next_offset = next_offset

    def to_bytes(self, boxed: bool=True):
        with Writer(b'-I\xbd1' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.int(self.count)
                writer.vector(
                    self.reactions,
                    lambda value: writer.object(
                        value,
                        group_id=0X6A319223
                    )
                )
                writer.vector(
                    self.chats,
                    lambda value: writer.object(
                        value,
                        group_id=0X73A5C0D9
                    )
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

                if flags(self.next_offset, 0):
                    writer.string(self.next_offset)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        count_ = reader.int()
        reactions_ = reader.vector(
            lambda: reader.object(
                group_id=0X6A319223
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        next_offset_ = (
            reader.string()
            if flags(0) else None
        )

        return cls(
            count=count_,
            reactions=reactions_,
            chats=chats_,
            users=users_,
            next_offset=next_offset_
        )

TypeMessagesMessageReactionsList = MessageReactionsList