
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..message_peer_vote import TypeMessagePeerVote
    from ....gadgets.byteutils import Reader


class VotesList(TLObject, family='TypeMessagesVotesList'):
    """
    How users voted in a poll
    """

    _id = 0X4899484E
    _group_id = 0XADB5E0FE

    def __init__(
        self,
        count: int,
        votes: List['TypeMessagePeerVote'],
        chats: List['TypeChat'],
        users: List['TypeUser'],
        next_offset: Optional[str] = None
    ):

        """
        How users voted in a poll

        Args:
            count (int): Total number of votes for all options (or only for the chosen option, if provided to [messages.getPollVotes](https://core.telegram.org/method/messages.getPollVotes))
            votes (List['TypeMessagePeerVote']): Vote info for each user
            chats (List['TypeChat']): Mentioned chats
            users (List['TypeUser']): Info about users that voted in the poll
            next_offset (Optional[str], optional): Offset to use with the next [messages.getPollVotes](https://core.telegram.org/method/messages.getPollVotes) request, empty string if no more results are available.
        """

        self.count = count
        self.votes = votes
        self.chats = chats
        self.users = users
        self.next_offset = next_offset

    def to_bytes(self, boxed: bool=True):
        with Writer(b'NH\x99H' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.int(self.count)
                writer.vector(
                    self.votes,
                    lambda value: writer.object(
                        value,
                        group_id=0X29FC700D
                    )
                )
                writer.vector(
                    self.chats,
                    lambda value: writer.object(
                        value,
                        group_id=0X73A5C0D9
                    )
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

                if flags(self.next_offset, 0):
                    writer.string(self.next_offset)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        count_ = reader.int()
        votes_ = reader.vector(
            lambda: reader.object(
                group_id=0X29FC700D
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        next_offset_ = (
            reader.string()
            if flags(0) else None
        )

        return cls(
            count=count_,
            votes=votes_,
            chats=chats_,
            users=users_,
            next_offset=next_offset_
        )

TypeMessagesVotesList = VotesList