
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Optional, Union
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..user import TypeUser
    from ..invoice import TypeInvoice
    from ..data_json import TypeDataJSON
    from ..web_document import TypeWebDocument
    from ..payment_form_method import TypePaymentFormMethod
    from ....gadgets.byteutils import Reader
    from ..payment_requested_info import TypePaymentRequestedInfo
    from ..payment_saved_credentials import TypePaymentSavedCredentials


class PaymentForm(TLObject, family='TypePaymentsPaymentForm'):
    """
    Payment form
    """

    _id = 0XA0058751
    _group_id = 0X65F0559

    def __init__(
        self,
        form_id: int,
        bot_id: int,
        title: str,
        description: str,
        invoice: 'TypeInvoice',
        provider_id: int,
        url: str,
        users: List['TypeUser'],
        can_save_credentials: bool = False,
        password_missing: bool = False,
        photo: Optional['TypeWebDocument'] = None,
        native_provider: Optional[str] = None,
        native_params: Optional['TypeDataJSON'] = None,
        additional_methods: Optional[List['TypePaymentFormMethod']] = None,
        saved_info: Optional['TypePaymentRequestedInfo'] = None,
        saved_credentials: Optional[List['TypePaymentSavedCredentials']] = None
    ):

        """
        Payment form

        Args:
            form_id (int): Form ID
            bot_id (int): Bot ID
            title (str): Form title
            description (str): Description
            invoice ('TypeInvoice'): Invoice
            provider_id (int): Payment provider ID.
            url (str): Payment form URL
            users (List['TypeUser']): Users
            can_save_credentials (bool, optional): Whether the user can choose to save credentials.
            password_missing (bool, optional): Indicates that the user can save payment credentials, but only after setting up a [2FA password](https://core.telegram.org/api/srp) (currently the account doesn't have a [2FA password](https://core.telegram.org/api/srp))
            photo (Optional['TypeWebDocument'], optional): Product photo
            native_provider (Optional[str], optional): Payment provider name. One of the following: - stripe
            native_params (Optional['TypeDataJSON'], optional): Contains information about the payment provider, if available, to support it natively without the need for opening the URL. A JSON object that can contain the following fields: - apple_pay_merchant_id: Apple Pay merchant ID - google_pay_public_key: Google Pay public key - need_country: True, if the user country must be provided, - need_zip: True, if the user ZIP/postal code must be provided, - need_cardholder_name: True, if the cardholder name must be provided
            additional_methods (Optional[List['TypePaymentFormMethod']], optional): Additional payment methods
            saved_info (Optional['TypePaymentRequestedInfo'], optional): Saved server-side order information
            saved_credentials (Optional[List['TypePaymentSavedCredentials']], optional): Contains information about saved card credentials
        """

        self.form_id = form_id
        self.bot_id = bot_id
        self.title = title
        self.description = description
        self.invoice = invoice
        self.provider_id = provider_id
        self.url = url
        self.users = users
        self.can_save_credentials = can_save_credentials
        self.password_missing = password_missing
        self.photo = photo
        self.native_provider = native_provider
        self.native_params = native_params
        self.additional_methods = additional_methods
        self.saved_info = saved_info
        self.saved_credentials = saved_credentials

    def to_bytes(self, boxed: bool=True):
        with Writer(b'Q\x87\x05\xa0' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.can_save_credentials, 2)
                flags(self.password_missing, 3)
                writer.long(self.form_id)
                writer.long(self.bot_id)
                writer.string(self.title)
                writer.string(self.description)

                if flags(self.photo, 5):
                    writer.object(
                        self.photo,
                        group_id=0XCDE930D7
                    )
                writer.object(
                    self.invoice,
                    group_id=0X3A02DB4
                )
                writer.long(self.provider_id)
                writer.string(self.url)

                if flags(self.native_provider, 4):
                    writer.string(self.native_provider)

                if flags(self.native_params, 4):
                    writer.object(
                        self.native_params,
                        group_id=0XE95B0798
                    )

                if flags(self.additional_methods, 6):
                    writer.vector(
                        self.additional_methods,
                        lambda value: writer.object(
                            value,
                            group_id=0X565719CB
                        )
                    )

                if flags(self.saved_info, 0):
                    writer.object(
                        self.saved_info,
                        group_id=0X89AE5563
                    )

                if flags(self.saved_credentials, 1):
                    writer.vector(
                        self.saved_credentials,
                        lambda value: writer.object(
                            value,
                            group_id=0X767A692C
                        )
                    )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        form_id_ = reader.long()
        bot_id_ = reader.long()
        title_ = reader.string()
        description_ = reader.string()
        photo_ = (
            reader.object(
                group_id=0XCDE930D7
            )
            if flags(5) else None
        )

        invoice_ = reader.object(
            group_id=0X3A02DB4
        )

        provider_id_ = reader.long()
        url_ = reader.string()
        native_provider_ = (
            reader.string()
            if flags(4) else None
        )

        native_params_ = (
            reader.object(
                group_id=0XE95B0798
            )
            if flags(4) else None
        )

        additional_methods_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X565719CB
                )
            )
            if flags(6) else None
        )

        saved_info_ = (
            reader.object(
                group_id=0X89AE5563
            )
            if flags(0) else None
        )

        saved_credentials_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X767A692C
                )
            )
            if flags(1) else None
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            form_id=form_id_,
            bot_id=bot_id_,
            title=title_,
            description=description_,
            invoice=invoice_,
            provider_id=provider_id_,
            url=url_,
            users=users_,
            can_save_credentials=flags(2),
            password_missing=flags(3),
            photo=photo_,
            native_provider=native_provider_,
            native_params=native_params_,
            additional_methods=additional_methods_,
            saved_info=saved_info_,
            saved_credentials=saved_credentials_
        )

class PaymentFormStars(TLObject, family='TypePaymentsPaymentForm'):
    """
    Represents a payment form, for payments to be using [Telegram Stars, see here](https://core.telegram.org/api/stars) for more info.
    """

    _id = 0X7BF6B15C
    _group_id = 0X65F0559

    def __init__(
        self,
        form_id: int,
        bot_id: int,
        title: str,
        description: str,
        invoice: 'TypeInvoice',
        users: List['TypeUser'],
        photo: Optional['TypeWebDocument'] = None
    ):

        """
        Represents a payment form, for payments to be using [Telegram Stars, see here](https://core.telegram.org/api/stars) for more info.

        Args:
            form_id (int): Form ID.
            bot_id (int): Bot ID.
            title (str): Form title
            description (str): Description
            invoice ('TypeInvoice'): Invoice
            users (List['TypeUser']): Info about users mentioned in the other fields.
            photo (Optional['TypeWebDocument'], optional): Product photo
        """

        self.form_id = form_id
        self.bot_id = bot_id
        self.title = title
        self.description = description
        self.invoice = invoice
        self.users = users
        self.photo = photo

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\\\xb1\xf6{' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.form_id)
                writer.long(self.bot_id)
                writer.string(self.title)
                writer.string(self.description)

                if flags(self.photo, 5):
                    writer.object(
                        self.photo,
                        group_id=0XCDE930D7
                    )
                writer.object(
                    self.invoice,
                    group_id=0X3A02DB4
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        form_id_ = reader.long()
        bot_id_ = reader.long()
        title_ = reader.string()
        description_ = reader.string()
        photo_ = (
            reader.object(
                group_id=0XCDE930D7
            )
            if flags(5) else None
        )

        invoice_ = reader.object(
            group_id=0X3A02DB4
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            form_id=form_id_,
            bot_id=bot_id_,
            title=title_,
            description=description_,
            invoice=invoice_,
            users=users_,
            photo=photo_
        )

class PaymentFormStarGift(TLObject, family='TypePaymentsPaymentForm'):
    """
    Represents a payment form for a [gift, see here](https://core.telegram.org/api/gifts) for more info.
    """

    _id = 0XB425CFE1
    _group_id = 0X65F0559

    def __init__(
        self,
        form_id: int,
        invoice: 'TypeInvoice'
    ):

        """
        Represents a payment form for a [gift, see here](https://core.telegram.org/api/gifts) for more info.

        Args:
            form_id (int): Form ID.
            invoice ('TypeInvoice'): Invoice
        """

        self.form_id = form_id
        self.invoice = invoice

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe1\xcf%\xb4' if boxed else b'') as writer:
            writer.long(self.form_id)
            writer.object(
                self.invoice,
                group_id=0X3A02DB4
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        form_id_ = reader.long()
        invoice_ = reader.object(
            group_id=0X3A02DB4
        )

        return cls(
            form_id=form_id_,
            invoice=invoice_
        )

TypePaymentsPaymentForm = Union[
    PaymentForm,
    PaymentFormStars,
    PaymentFormStarGift
]