
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .notification_sound import TypeNotificationSound
    from ...gadgets.byteutils import Reader


class PeerNotifySettings(TLObject, family='TypePeerNotifySettings'):
    """
    Notification settings.
    """

    _id = 0X99622C0C
    _group_id = 0X372BF8CC

    def __init__(
        self,
        show_previews: bool = False,
        silent: bool = False,
        mute_until: Optional[int] = None,
        ios_sound: Optional['TypeNotificationSound'] = None,
        android_sound: Optional['TypeNotificationSound'] = None,
        other_sound: Optional['TypeNotificationSound'] = None,
        stories_muted: bool = False,
        stories_hide_sender: bool = False,
        stories_ios_sound: Optional['TypeNotificationSound'] = None,
        stories_android_sound: Optional['TypeNotificationSound'] = None,
        stories_other_sound: Optional['TypeNotificationSound'] = None
    ):

        """
        Notification settings.

        Args:
            show_previews (bool, optional): (Ternary value) If set, indicates whether or not to display previews of messages in notifications; otherwise the default behavior should be used.
            silent (bool, optional): (Ternary value) If set, indicates whether to mute or unmute the peer; otherwise the default behavior should be used.
            mute_until (Optional[int], optional): Mute all notifications until this date
            ios_sound (Optional['TypeNotificationSound'], optional): Notification sound for the official iOS application
            android_sound (Optional['TypeNotificationSound'], optional): Notification sound for the official android application
            other_sound (Optional['TypeNotificationSound'], optional): Notification sound for other applications
            stories_muted (bool, optional): Whether story notifications should be disabled.
            stories_hide_sender (bool, optional): Whether the sender name should be displayed in story notifications.
            stories_ios_sound (Optional['TypeNotificationSound'], optional): Sound for story notifications on the official iOS application
            stories_android_sound (Optional['TypeNotificationSound'], optional): Sound for story notifications on the official Android application
            stories_other_sound (Optional['TypeNotificationSound'], optional): Sound for story notifications on other applications
        """

        self.show_previews = show_previews
        self.silent = silent
        self.mute_until = mute_until
        self.ios_sound = ios_sound
        self.android_sound = android_sound
        self.other_sound = other_sound
        self.stories_muted = stories_muted
        self.stories_hide_sender = stories_hide_sender
        self.stories_ios_sound = stories_ios_sound
        self.stories_android_sound = stories_android_sound
        self.stories_other_sound = stories_other_sound

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x0c,b\x99' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.show_previews, 0):
                    writer.object(
                        self.show_previews,
                        group_id=0X43B904E1
                    )

                if flags(self.silent, 1):
                    writer.object(
                        self.silent,
                        group_id=0X43B904E1
                    )

                if flags(self.mute_until, 2):
                    writer.int(self.mute_until)

                if flags(self.ios_sound, 3):
                    writer.object(
                        self.ios_sound,
                        group_id=0X9B633486
                    )

                if flags(self.android_sound, 4):
                    writer.object(
                        self.android_sound,
                        group_id=0X9B633486
                    )

                if flags(self.other_sound, 5):
                    writer.object(
                        self.other_sound,
                        group_id=0X9B633486
                    )

                if flags(self.stories_muted, 6):
                    writer.object(
                        self.stories_muted,
                        group_id=0X43B904E1
                    )

                if flags(self.stories_hide_sender, 7):
                    writer.object(
                        self.stories_hide_sender,
                        group_id=0X43B904E1
                    )

                if flags(self.stories_ios_sound, 8):
                    writer.object(
                        self.stories_ios_sound,
                        group_id=0X9B633486
                    )

                if flags(self.stories_android_sound, 9):
                    writer.object(
                        self.stories_android_sound,
                        group_id=0X9B633486
                    )

                if flags(self.stories_other_sound, 10):
                    writer.object(
                        self.stories_other_sound,
                        group_id=0X9B633486
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        show_previews_ = (
            reader.object(
                group_id=0X43B904E1
            )
            if flags(0) else None
        )

        silent_ = (
            reader.object(
                group_id=0X43B904E1
            )
            if flags(1) else None
        )

        mute_until_ = (
            reader.int()
            if flags(2) else None
        )

        ios_sound_ = (
            reader.object(
                group_id=0X9B633486
            )
            if flags(3) else None
        )

        android_sound_ = (
            reader.object(
                group_id=0X9B633486
            )
            if flags(4) else None
        )

        other_sound_ = (
            reader.object(
                group_id=0X9B633486
            )
            if flags(5) else None
        )

        stories_muted_ = (
            reader.object(
                group_id=0X43B904E1
            )
            if flags(6) else None
        )

        stories_hide_sender_ = (
            reader.object(
                group_id=0X43B904E1
            )
            if flags(7) else None
        )

        stories_ios_sound_ = (
            reader.object(
                group_id=0X9B633486
            )
            if flags(8) else None
        )

        stories_android_sound_ = (
            reader.object(
                group_id=0X9B633486
            )
            if flags(9) else None
        )

        stories_other_sound_ = (
            reader.object(
                group_id=0X9B633486
            )
            if flags(10) else None
        )

        return cls(
            show_previews=show_previews_,
            silent=silent_,
            mute_until=mute_until_,
            ios_sound=ios_sound_,
            android_sound=android_sound_,
            other_sound=other_sound_,
            stories_muted=stories_muted_,
            stories_hide_sender=stories_hide_sender_,
            stories_ios_sound=stories_ios_sound_,
            stories_android_sound=stories_android_sound_,
            stories_other_sound=stories_other_sound_
        )

TypePeerNotifySettings = PeerNotifySettings