
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class PostInteractionCountersMessage(TLObject, family='TypePostInteractionCounters'):
    """
    Interaction counters for a message.
    """

    _id = 0XE7058E7F
    _group_id = 0XAB525254

    def __init__(
        self,
        msg_id: int,
        views: int,
        forwards: int,
        reactions: int
    ):

        """
        Interaction counters for a message.

        Args:
            msg_id (int): Message ID
            views (int): Number of views
            forwards (int): Number of forwards to public channels
            reactions (int): Number of reactions
        """

        self.msg_id = msg_id
        self.views = views
        self.forwards = forwards
        self.reactions = reactions

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x7f\x8e\x05\xe7' if boxed else b'') as writer:
            writer.int(self.msg_id)
            writer.int(self.views)
            writer.int(self.forwards)
            writer.int(self.reactions)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        msg_id_ = reader.int()
        views_ = reader.int()
        forwards_ = reader.int()
        reactions_ = reader.int()

        return cls(
            msg_id=msg_id_,
            views=views_,
            forwards=forwards_,
            reactions=reactions_
        )

class PostInteractionCountersStory(TLObject, family='TypePostInteractionCounters'):
    """
    Interaction counters for a story.
    """

    _id = 0X8A480E27
    _group_id = 0XAB525254

    def __init__(
        self,
        story_id: int,
        views: int,
        forwards: int,
        reactions: int
    ):

        """
        Interaction counters for a story.

        Args:
            story_id (int): Story ID
            views (int): Number of views
            forwards (int): Number of forwards and reposts to public chats and channels
            reactions (int): Number of reactions
        """

        self.story_id = story_id
        self.views = views
        self.forwards = forwards
        self.reactions = reactions

    def to_bytes(self, boxed: bool=True):
        with Writer(b"'\x0eH\x8a" if boxed else b'') as writer:
            writer.int(self.story_id)
            writer.int(self.views)
            writer.int(self.forwards)
            writer.int(self.reactions)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        story_id_ = reader.int()
        views_ = reader.int()
        forwards_ = reader.int()
        reactions_ = reader.int()

        return cls(
            story_id=story_id_,
            views=views_,
            forwards=forwards_,
            reactions=reactions_
        )

TypePostInteractionCounters = Union[
    PostInteractionCountersMessage,
    PostInteractionCountersStory
]