
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..prepaid_giveaway import TypePrepaidGiveaway
    from ..stats_percent_value import TypeStatsPercentValue
    from ....gadgets.byteutils import Reader


class BoostsStatus(TLObject, family='TypePremiumBoostsStatus'):
    """
    Contains info about the current [boost status](https://core.telegram.org/api/boost) of a peer.
    """

    _id = 0X4959427A
    _group_id = 0XE7E1EFF1

    def __init__(
        self,
        level: int,
        current_level_boosts: int,
        boosts: int,
        boost_url: str,
        my_boost: bool = False,
        gift_boosts: Optional[int] = None,
        next_level_boosts: Optional[int] = None,
        premium_audience: Optional['TypeStatsPercentValue'] = None,
        prepaid_giveaways: Optional[List['TypePrepaidGiveaway']] = None,
        my_boost_slots: Optional[List[int]] = None
    ):

        """
        Contains info about the current [boost status](https://core.telegram.org/api/boost) of a peer.

        Args:
            level (int): The current boost level of the channel/supergroup.
            current_level_boosts (int): The number of boosts acquired so far in the current level.
            boosts (int): Total number of boosts acquired so far.
            boost_url (str): [Boost deep link](https://core.telegram.org/api/links#boost-links) that can be used to boost the chat.
            my_boost (bool, optional): Whether we're currently boosting this channel/supergroup, my_boost_slots will also be set.
            gift_boosts (Optional[int], optional): The number of boosts acquired from created Telegram Premium [gift codes](https://core.telegram.org/api/giveaways) and [giveaways](https://core.telegram.org/api/giveaways); only returned to channel/supergroup admins.
            next_level_boosts (Optional[int], optional): Total number of boosts needed to reach the next level; if absent, the next level isn't available.
            premium_audience (Optional['TypeStatsPercentValue'], optional): Only returned to channel/supergroup admins: contains the approximated number of Premium users subscribed to the channel/supergroup, related to the total number of subscribers.
            prepaid_giveaways (Optional[List['TypePrepaidGiveaway']], optional): A list of prepaid [giveaways](https://core.telegram.org/api/giveaways) available for the chat; only returned to channel/supergroup admins.
            my_boost_slots (Optional[List[int]], optional): Indicates which of our [boost slots](https://core.telegram.org/api/boost) we've assigned to this peer (populated if my_boost is set).
        """

        self.level = level
        self.current_level_boosts = current_level_boosts
        self.boosts = boosts
        self.boost_url = boost_url
        self.my_boost = my_boost
        self.gift_boosts = gift_boosts
        self.next_level_boosts = next_level_boosts
        self.premium_audience = premium_audience
        self.prepaid_giveaways = prepaid_giveaways
        self.my_boost_slots = my_boost_slots

    def to_bytes(self, boxed: bool=True):
        with Writer(b'zBYI' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.my_boost, 2)
                writer.int(self.level)
                writer.int(self.current_level_boosts)
                writer.int(self.boosts)

                if flags(self.gift_boosts, 4):
                    writer.int(self.gift_boosts)

                if flags(self.next_level_boosts, 0):
                    writer.int(self.next_level_boosts)

                if flags(self.premium_audience, 1):
                    writer.object(
                        self.premium_audience,
                        group_id=0XFE9414C3
                    )
                writer.string(self.boost_url)

                if flags(self.prepaid_giveaways, 3):
                    writer.vector(
                        self.prepaid_giveaways,
                        lambda value: writer.object(
                            value,
                            group_id=0X4200658F
                        )
                    )

                if flags(self.my_boost_slots, 2):
                    writer.vector(
                        self.my_boost_slots,
                        writer.int
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        level_ = reader.int()
        current_level_boosts_ = reader.int()
        boosts_ = reader.int()
        gift_boosts_ = (
            reader.int()
            if flags(4) else None
        )

        next_level_boosts_ = (
            reader.int()
            if flags(0) else None
        )

        premium_audience_ = (
            reader.object(
                group_id=0XFE9414C3
            )
            if flags(1) else None
        )

        boost_url_ = reader.string()
        prepaid_giveaways_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X4200658F
                )
            )
            if flags(3) else None
        )

        my_boost_slots_ = (
            reader.vector(
                reader.int
            )
            if flags(2) else None
        )

        return cls(
            level=level_,
            current_level_boosts=current_level_boosts_,
            boosts=boosts_,
            boost_url=boost_url_,
            my_boost=flags(2),
            gift_boosts=gift_boosts_,
            next_level_boosts=next_level_boosts_,
            premium_audience=premium_audience_,
            prepaid_giveaways=prepaid_giveaways_,
            my_boost_slots=my_boost_slots_
        )

TypePremiumBoostsStatus = BoostsStatus