
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class SecurePasswordKdfAlgoUnknown(TLObject, family='TypeSecurePasswordKdfAlgo'):
    """
    Unknown KDF algo (most likely the client has to be updated)
    """

    _id = 0X4A8537
    _group_id = 0X3C26E360


    def to_bytes(self, boxed: bool=True):
        return b'7\x85J\x00' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class SecurePasswordKdfAlgoPBKDF2HMACSHA512iter100000(TLObject, family='TypeSecurePasswordKdfAlgo'):
    """
    PBKDF2 with SHA512 and 100000 iterations KDF algo
    """

    _id = 0XBBF2DDA0
    _group_id = 0X3C26E360

    def __init__(
        self,
        salt: bytes
    ):

        """
        PBKDF2 with SHA512 and 100000 iterations KDF algo

        Args:
            salt (bytes): Salt
        """

        self.salt = salt

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa0\xdd\xf2\xbb' if boxed else b'') as writer:
            writer.bytes(self.salt)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        salt_ = reader.bytes()

        return cls(
            salt=salt_
        )

class SecurePasswordKdfAlgoSHA512(TLObject, family='TypeSecurePasswordKdfAlgo'):
    """
    SHA512 KDF algo
    """

    _id = 0X86471D92
    _group_id = 0X3C26E360

    def __init__(
        self,
        salt: bytes
    ):

        """
        SHA512 KDF algo

        Args:
            salt (bytes): Salt
        """

        self.salt = salt

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x92\x1dG\x86' if boxed else b'') as writer:
            writer.bytes(self.salt)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        salt_ = reader.bytes()

        return cls(
            salt=salt_
        )

TypeSecurePasswordKdfAlgo = Union[
    SecurePasswordKdfAlgoUnknown,
    SecurePasswordKdfAlgoPBKDF2HMACSHA512iter100000,
    SecurePasswordKdfAlgoSHA512
]