
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class StickerKeyword(TLObject, family='TypeStickerKeyword'):
    """
    Keywords for a certain sticker
    """

    _id = 0XFCFEB29C
    _group_id = 0XD76E5240

    def __init__(
        self,
        document_id: int,
        keyword: List[str]
    ):

        """
        Keywords for a certain sticker

        Args:
            document_id (int): Sticker ID
            keyword (List[str]): Keywords
        """

        self.document_id = document_id
        self.keyword = keyword

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9c\xb2\xfe\xfc' if boxed else b'') as writer:
            writer.long(self.document_id)
            writer.vector(
                self.keyword,
                writer.string
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        document_id_ = reader.long()
        keyword_ = reader.vector(
            reader.string
        )

        return cls(
            document_id=document_id_,
            keyword=keyword_
        )

TypeStickerKeyword = StickerKeyword