
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..found_story import TypeFoundStory
    from ....gadgets.byteutils import Reader


class FoundStories(TLObject, family='TypeStoriesFoundStories'):
    """
    Stories found using [global story search](https://core.telegram.org/api/stories#searching-stories).
    """

    _id = 0XE2DE7737
    _group_id = 0XF4730BF7

    def __init__(
        self,
        count: int,
        stories: List['TypeFoundStory'],
        chats: List['TypeChat'],
        users: List['TypeUser'],
        next_offset: Optional[str] = None
    ):

        """
        Stories found using [global story search](https://core.telegram.org/api/stories#searching-stories).

        Args:
            count (int): Total number of results found for the query.
            stories (List['TypeFoundStory']): Matching stories.
            chats (List['TypeChat']): Mentioned chats
            users (List['TypeUser']): Mentioned users
            next_offset (Optional[str], optional): Offset used to fetch the next page, if not set this is the final page.
        """

        self.count = count
        self.stories = stories
        self.chats = chats
        self.users = users
        self.next_offset = next_offset

    def to_bytes(self, boxed: bool=True):
        with Writer(b'7w\xde\xe2' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.int(self.count)
                writer.vector(
                    self.stories,
                    lambda value: writer.object(
                        value,
                        group_id=0X8723F010
                    )
                )

                if flags(self.next_offset, 0):
                    writer.string(self.next_offset)
                writer.vector(
                    self.chats,
                    lambda value: writer.object(
                        value,
                        group_id=0X73A5C0D9
                    )
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        count_ = reader.int()
        stories_ = reader.vector(
            lambda: reader.object(
                group_id=0X8723F010
            )
        )

        next_offset_ = (
            reader.string()
            if flags(0) else None
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            count=count_,
            stories=stories_,
            chats=chats_,
            users=users_,
            next_offset=next_offset_
        )

TypeStoriesFoundStories = FoundStories