
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, Optional, List
from .state import State, TypeUpdatesState
from .difference import TypeUpdatesDifference, DifferenceEmpty, DifferenceTooLong, DifferenceSlice, Difference
from .channel_difference import ChannelDifference, TypeUpdatesChannelDifference, ChannelDifferenceTooLong, ChannelDifferenceEmpty
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..user import TypeUser
    from ..chat import TypeChat
    from ..update import TypeUpdate
    from ..message_media import TypeMessageMedia
    from ..message_entity import TypeMessageEntity
    from ..message_fwd_header import TypeMessageFwdHeader
    from ....gadgets.byteutils import Reader
    from ..message_reply_header import TypeMessageReplyHeader


class UpdatesTooLong(TLObject, family='TypeUpdates'):
    """
    Too many updates, it is necessary to execute [updates.getDifference](https://core.telegram.org/method/updates.getDifference).
    """

    _id = 0XE317AF7E
    _group_id = 0XD68D29C0


    def to_bytes(self, boxed: bool=True):
        return b'~\xaf\x17\xe3' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class UpdateShortMessage(TLObject, family='TypeUpdates'):
    """
    Info about a message sent to (received from) another user
    """

    _id = 0X313BC7F8
    _group_id = 0XD68D29C0

    def __init__(
        self,
        id: int,
        user_id: int,
        message: str,
        pts: int,
        pts_count: int,
        date: int,
        out: bool = False,
        mentioned: bool = False,
        media_unread: bool = False,
        silent: bool = False,
        fwd_from: Optional['TypeMessageFwdHeader'] = None,
        via_bot_id: Optional[int] = None,
        reply_to: Optional['TypeMessageReplyHeader'] = None,
        entities: Optional[List['TypeMessageEntity']] = None,
        ttl_period: Optional[int] = None
    ):

        """
        Info about a message sent to (received from) another user

        Args:
            id (int): The message ID
            user_id (int): The ID of the sender (if outgoing will be the ID of the destination) of the message
            message (str): The message
            pts (int): [PTS](https://core.telegram.org/api/updates)
            pts_count (int): [PTS count](https://core.telegram.org/api/updates)
            date (int): [date](https://core.telegram.org/api/updates)
            out (bool, optional): Whether the message is outgoing
            mentioned (bool, optional): Whether we were mentioned in the message
            media_unread (bool, optional): Whether there are some unread mentions in this message
            silent (bool, optional): If true, the message is a silent message, no notifications should be triggered
            fwd_from (Optional['TypeMessageFwdHeader'], optional): Info about a forwarded message
            via_bot_id (Optional[int], optional): Info about the inline bot used to generate this message
            reply_to (Optional['TypeMessageReplyHeader'], optional): Reply and [thread](https://core.telegram.org/api/threads) information
            entities (Optional[List['TypeMessageEntity']], optional): [Entities](https://core.telegram.org/api/entities) for styled text
            ttl_period (Optional[int], optional): Time To Live of the message, once message.date+message.ttl_period === time(), the message will be deleted on the server, and must be deleted locally as well.
        """

        self.id = id
        self.user_id = user_id
        self.message = message
        self.pts = pts
        self.pts_count = pts_count
        self.date = date
        self.out = out
        self.mentioned = mentioned
        self.media_unread = media_unread
        self.silent = silent
        self.fwd_from = fwd_from
        self.via_bot_id = via_bot_id
        self.reply_to = reply_to
        self.entities = entities
        self.ttl_period = ttl_period

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf8\xc7;1' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.out, 1)
                flags(self.mentioned, 4)
                flags(self.media_unread, 5)
                flags(self.silent, 13)
                writer.int(self.id)
                writer.long(self.user_id)
                writer.string(self.message)
                writer.int(self.pts)
                writer.int(self.pts_count)
                writer.int(self.date)

                if flags(self.fwd_from, 2):
                    writer.object(
                        self.fwd_from,
                        group_id=0XEA3B4B97
                    )

                if flags(self.via_bot_id, 11):
                    writer.long(self.via_bot_id)

                if flags(self.reply_to, 3):
                    writer.object(
                        self.reply_to,
                        group_id=0XA346A9DF
                    )

                if flags(self.entities, 7):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

                if flags(self.ttl_period, 25):
                    writer.int(self.ttl_period)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.int()
        user_id_ = reader.long()
        message_ = reader.string()
        pts_ = reader.int()
        pts_count_ = reader.int()
        date_ = reader.int()
        fwd_from_ = (
            reader.object(
                group_id=0XEA3B4B97
            )
            if flags(2) else None
        )

        via_bot_id_ = (
            reader.long()
            if flags(11) else None
        )

        reply_to_ = (
            reader.object(
                group_id=0XA346A9DF
            )
            if flags(3) else None
        )

        entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(7) else None
        )

        ttl_period_ = (
            reader.int()
            if flags(25) else None
        )

        return cls(
            id=id_,
            user_id=user_id_,
            message=message_,
            pts=pts_,
            pts_count=pts_count_,
            date=date_,
            out=flags(1),
            mentioned=flags(4),
            media_unread=flags(5),
            silent=flags(13),
            fwd_from=fwd_from_,
            via_bot_id=via_bot_id_,
            reply_to=reply_to_,
            entities=entities_,
            ttl_period=ttl_period_
        )

class UpdateShortChatMessage(TLObject, family='TypeUpdates'):
    """
    Shortened constructor containing info on one new incoming text message from a chat
    """

    _id = 0X4D6DEEA5
    _group_id = 0XD68D29C0

    def __init__(
        self,
        id: int,
        from_id: int,
        chat_id: int,
        message: str,
        pts: int,
        pts_count: int,
        date: int,
        out: bool = False,
        mentioned: bool = False,
        media_unread: bool = False,
        silent: bool = False,
        fwd_from: Optional['TypeMessageFwdHeader'] = None,
        via_bot_id: Optional[int] = None,
        reply_to: Optional['TypeMessageReplyHeader'] = None,
        entities: Optional[List['TypeMessageEntity']] = None,
        ttl_period: Optional[int] = None
    ):

        """
        Shortened constructor containing info on one new incoming text message from a chat

        Args:
            id (int): ID of the message
            from_id (int): ID of the sender of the message
            chat_id (int): ID of the chat where the message was sent
            message (str): Message
            pts (int): [PTS](https://core.telegram.org/api/updates)
            pts_count (int): [PTS count](https://core.telegram.org/api/updates)
            date (int): [date](https://core.telegram.org/api/updates)
            out (bool, optional): Whether the message is outgoing
            mentioned (bool, optional): Whether we were mentioned in this message
            media_unread (bool, optional): Whether the message contains some unread mentions
            silent (bool, optional): If true, the message is a silent message, no notifications should be triggered
            fwd_from (Optional['TypeMessageFwdHeader'], optional): Info about a forwarded message
            via_bot_id (Optional[int], optional): Info about the inline bot used to generate this message
            reply_to (Optional['TypeMessageReplyHeader'], optional): Reply (thread) information
            entities (Optional[List['TypeMessageEntity']], optional): [Entities](https://core.telegram.org/api/entities) for styled text
            ttl_period (Optional[int], optional): Time To Live of the message, once updateShortChatMessage.date+updateShortChatMessage.ttl_period === time(), the message will be deleted on the server, and must be deleted locally as well.
        """

        self.id = id
        self.from_id = from_id
        self.chat_id = chat_id
        self.message = message
        self.pts = pts
        self.pts_count = pts_count
        self.date = date
        self.out = out
        self.mentioned = mentioned
        self.media_unread = media_unread
        self.silent = silent
        self.fwd_from = fwd_from
        self.via_bot_id = via_bot_id
        self.reply_to = reply_to
        self.entities = entities
        self.ttl_period = ttl_period

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa5\xeemM' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.out, 1)
                flags(self.mentioned, 4)
                flags(self.media_unread, 5)
                flags(self.silent, 13)
                writer.int(self.id)
                writer.long(self.from_id)
                writer.long(self.chat_id)
                writer.string(self.message)
                writer.int(self.pts)
                writer.int(self.pts_count)
                writer.int(self.date)

                if flags(self.fwd_from, 2):
                    writer.object(
                        self.fwd_from,
                        group_id=0XEA3B4B97
                    )

                if flags(self.via_bot_id, 11):
                    writer.long(self.via_bot_id)

                if flags(self.reply_to, 3):
                    writer.object(
                        self.reply_to,
                        group_id=0XA346A9DF
                    )

                if flags(self.entities, 7):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

                if flags(self.ttl_period, 25):
                    writer.int(self.ttl_period)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.int()
        from_id_ = reader.long()
        chat_id_ = reader.long()
        message_ = reader.string()
        pts_ = reader.int()
        pts_count_ = reader.int()
        date_ = reader.int()
        fwd_from_ = (
            reader.object(
                group_id=0XEA3B4B97
            )
            if flags(2) else None
        )

        via_bot_id_ = (
            reader.long()
            if flags(11) else None
        )

        reply_to_ = (
            reader.object(
                group_id=0XA346A9DF
            )
            if flags(3) else None
        )

        entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(7) else None
        )

        ttl_period_ = (
            reader.int()
            if flags(25) else None
        )

        return cls(
            id=id_,
            from_id=from_id_,
            chat_id=chat_id_,
            message=message_,
            pts=pts_,
            pts_count=pts_count_,
            date=date_,
            out=flags(1),
            mentioned=flags(4),
            media_unread=flags(5),
            silent=flags(13),
            fwd_from=fwd_from_,
            via_bot_id=via_bot_id_,
            reply_to=reply_to_,
            entities=entities_,
            ttl_period=ttl_period_
        )

class UpdateShort(TLObject, family='TypeUpdates'):
    """
    Shortened constructor containing info on one update not requiring auxiliary data
    """

    _id = 0X78D4DEC1
    _group_id = 0XD68D29C0

    def __init__(
        self,
        update: 'TypeUpdate',
        date: int
    ):

        """
        Shortened constructor containing info on one update not requiring auxiliary data

        Args:
            update ('TypeUpdate'): Update
            date (int): Date of event
        """

        self.update = update
        self.date = date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc1\xde\xd4x' if boxed else b'') as writer:
            writer.object(
                self.update,
                group_id=0X54E058F5
            )
            writer.int(self.date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        update_ = reader.object(
            group_id=0X54E058F5
        )

        date_ = reader.int()

        return cls(
            update=update_,
            date=date_
        )

class UpdatesCombined(TLObject, family='TypeUpdates'):
    """
    Constructor for a group of updates.
    """

    _id = 0X725B04C3
    _group_id = 0XD68D29C0

    def __init__(
        self,
        updates: List['TypeUpdate'],
        users: List['TypeUser'],
        chats: List['TypeChat'],
        date: int,
        seq_start: int,
        seq: int
    ):

        """
        Constructor for a group of updates.

        Args:
            updates (List['TypeUpdate']): List of updates
            users (List['TypeUser']): List of users mentioned in updates
            chats (List['TypeChat']): List of chats mentioned in updates
            date (int): Current date
            seq_start (int): Value seq for the earliest update in a group
            seq (int): Value seq for the latest update in a group
        """

        self.updates = updates
        self.users = users
        self.chats = chats
        self.date = date
        self.seq_start = seq_start
        self.seq = seq

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc3\x04[r' if boxed else b'') as writer:
            writer.vector(
                self.updates,
                lambda value: writer.object(
                    value,
                    group_id=0X54E058F5
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )
            writer.vector(
                self.chats,
                lambda value: writer.object(
                    value,
                    group_id=0X73A5C0D9
                )
            )
            writer.int(self.date)
            writer.int(self.seq_start)
            writer.int(self.seq)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        updates_ = reader.vector(
            lambda: reader.object(
                group_id=0X54E058F5
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        date_ = reader.int()
        seq_start_ = reader.int()
        seq_ = reader.int()

        return cls(
            updates=updates_,
            users=users_,
            chats=chats_,
            date=date_,
            seq_start=seq_start_,
            seq=seq_
        )

class Updates(TLObject, family='TypeUpdates'):
    """
    Full constructor of updates
    """

    _id = 0X74AE4240
    _group_id = 0XD68D29C0

    def __init__(
        self,
        updates: List['TypeUpdate'],
        users: List['TypeUser'],
        chats: List['TypeChat'],
        date: int,
        seq: int
    ):

        """
        Full constructor of updates

        Args:
            updates (List['TypeUpdate']): List of updates
            users (List['TypeUser']): List of users mentioned in updates
            chats (List['TypeChat']): List of chats mentioned in updates
            date (int): Current date
            seq (int): Total number of sent updates
        """

        self.updates = updates
        self.users = users
        self.chats = chats
        self.date = date
        self.seq = seq

    def to_bytes(self, boxed: bool=True):
        with Writer(b'@B\xaet' if boxed else b'') as writer:
            writer.vector(
                self.updates,
                lambda value: writer.object(
                    value,
                    group_id=0X54E058F5
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )
            writer.vector(
                self.chats,
                lambda value: writer.object(
                    value,
                    group_id=0X73A5C0D9
                )
            )
            writer.int(self.date)
            writer.int(self.seq)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        updates_ = reader.vector(
            lambda: reader.object(
                group_id=0X54E058F5
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        date_ = reader.int()
        seq_ = reader.int()

        return cls(
            updates=updates_,
            users=users_,
            chats=chats_,
            date=date_,
            seq=seq_
        )

class UpdateShortSentMessage(TLObject, family='TypeUpdates'):
    """
    Shortened constructor containing info on one outgoing message to a contact (the destination chat has to be extracted from the method call that returned this object).
    """

    _id = 0X9015E101
    _group_id = 0XD68D29C0

    def __init__(
        self,
        id: int,
        pts: int,
        pts_count: int,
        date: int,
        out: bool = False,
        media: Optional['TypeMessageMedia'] = None,
        entities: Optional[List['TypeMessageEntity']] = None,
        ttl_period: Optional[int] = None
    ):

        """
        Shortened constructor containing info on one outgoing message to a contact (the destination chat has to be extracted from the method call that returned this object).

        Args:
            id (int): ID of the sent message
            pts (int): [PTS](https://core.telegram.org/api/updates)
            pts_count (int): [PTS count](https://core.telegram.org/api/updates)
            date (int): [date](https://core.telegram.org/api/updates)
            out (bool, optional): Whether the message is outgoing
            media (Optional['TypeMessageMedia'], optional): Attached media
            entities (Optional[List['TypeMessageEntity']], optional): [Entities](https://core.telegram.org/api/entities) for styled text
            ttl_period (Optional[int], optional): Time To Live of the message, once message.date+message.ttl_period === time(), the message will be deleted on the server, and must be deleted locally as well.
        """

        self.id = id
        self.pts = pts
        self.pts_count = pts_count
        self.date = date
        self.out = out
        self.media = media
        self.entities = entities
        self.ttl_period = ttl_period

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x01\xe1\x15\x90' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.out, 1)
                writer.int(self.id)
                writer.int(self.pts)
                writer.int(self.pts_count)
                writer.int(self.date)

                if flags(self.media, 9):
                    writer.object(
                        self.media,
                        group_id=0X45F7A020
                    )

                if flags(self.entities, 7):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

                if flags(self.ttl_period, 25):
                    writer.int(self.ttl_period)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.int()
        pts_ = reader.int()
        pts_count_ = reader.int()
        date_ = reader.int()
        media_ = (
            reader.object(
                group_id=0X45F7A020
            )
            if flags(9) else None
        )

        entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(7) else None
        )

        ttl_period_ = (
            reader.int()
            if flags(25) else None
        )

        return cls(
            id=id_,
            pts=pts_,
            pts_count=pts_count_,
            date=date_,
            out=flags(1),
            media=media_,
            entities=entities_,
            ttl_period=ttl_period_
        )

TypeUpdates = Union[
    UpdatesTooLong,
    UpdateShortMessage,
    UpdateShortChatMessage,
    UpdateShort,
    UpdatesCombined,
    Updates,
    UpdateShortSentMessage
]

__all__ = [
    'UpdateShortChatMessage',
    'UpdateShortMessage',
    'State',
    'TypeUpdatesDifference',
    'DifferenceEmpty',
    'TypeUpdatesChannelDifference',
    'DifferenceTooLong',
    'TypeUpdatesState',
    'ChannelDifferenceTooLong',
    'Updates',
    'DifferenceSlice',
    'Difference',
    'ChannelDifference',
    'UpdatesTooLong',
    'UpdatesCombined',
    'UpdateShortSentMessage',
    'ChannelDifferenceEmpty',
    'UpdateShort',
    'TypeUpdates'
]