"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListClientsRequestTypedDict(TypedDict):
    embed: NotRequired[Nullable[str]]
    r"""This endpoint allows embedding related API items by appending the following values via the `embed` query string parameter.

    * `organization`: Include the organization of the client. Available for `signuplink` partners, or for `oauth` partners with the `organizations.read` scope.
    * `onboarding`: Include the onboarding status of the client. Available for `signuplink` partners, or for `oauth` partners with the `onboarding.read` scope.
    * `capabilities`: Include the [capabilities](list-capabilities) of the client organization. Available for *oauth* partners with the `onboarding.read` scope.
    """
    from_: NotRequired[str]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set."""
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""


class ListClientsRequest(BaseModel):
    embed: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows embedding related API items by appending the following values via the `embed` query string parameter.

    * `organization`: Include the organization of the client. Available for `signuplink` partners, or for `oauth` partners with the `organizations.read` scope.
    * `onboarding`: Include the onboarding status of the client. Available for `signuplink` partners, or for `oauth` partners with the `onboarding.read` scope.
    * `capabilities`: Include the [capabilities](list-capabilities) of the client organization. Available for *oauth* partners with the `onboarding.read` scope.
    """

    from_: Annotated[
        Optional[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set."""

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of items to return. Defaults to 50 items."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["embed", "from", "limit"]
        nullable_fields = ["embed", "limit"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListClientsClientsResponseDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class ListClientsClientsResponseDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class ListClientsClientsResponseLinksTypedDict(TypedDict):
    documentation: NotRequired[ListClientsClientsResponseDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class ListClientsClientsResponseLinks(BaseModel):
    documentation: Optional[ListClientsClientsResponseDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class ListClientsClientsResponseResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[ListClientsClientsResponseLinks], pydantic.Field(alias="_links")
    ] = None


class ListClientsClientsResponseResponseBody(Exception):
    r"""An error response object."""

    data: ListClientsClientsResponseResponseBodyData

    def __init__(self, data: ListClientsClientsResponseResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, ListClientsClientsResponseResponseBodyData)


class ListClientsClientsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class ListClientsClientsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class ListClientsClientsLinksTypedDict(TypedDict):
    documentation: NotRequired[ListClientsClientsDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class ListClientsClientsLinks(BaseModel):
    documentation: Optional[ListClientsClientsDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class ListClientsClientsResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[ListClientsClientsLinks], pydantic.Field(alias="_links")
    ] = None


class ListClientsClientsResponseBody(Exception):
    r"""An error response object."""

    data: ListClientsClientsResponseBodyData

    def __init__(self, data: ListClientsClientsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, ListClientsClientsResponseBodyData)


class ListClientsCommissionTypedDict(TypedDict):
    r"""The commission object."""

    count: NotRequired[int]
    r"""The commission count."""


class ListClientsCommission(BaseModel):
    r"""The commission object."""

    count: Optional[int] = None
    r"""The commission count."""


class ListClientsClientsSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsClientsSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsOrganizationTypedDict(TypedDict):
    r"""The API resource URL of the client's organization."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsOrganization(BaseModel):
    r"""The API resource URL of the client's organization."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsClientsOnboardingTypedDict(TypedDict):
    r"""The API resource URL of the client's onboarding status."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsClientsOnboarding(BaseModel):
    r"""The API resource URL of the client's onboarding status."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsClientsResponse200DocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsClientsResponse200Documentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsClientsResponse200LinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListClientsClientsSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    organization: NotRequired[ListClientsOrganizationTypedDict]
    r"""The API resource URL of the client's organization."""
    onboarding: NotRequired[ListClientsClientsOnboardingTypedDict]
    r"""The API resource URL of the client's onboarding status."""
    documentation: NotRequired[ListClientsClientsResponse200DocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListClientsClientsResponse200Links(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[ListClientsClientsSelf], pydantic.Field(alias="self")] = (
        None
    )
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    organization: Optional[ListClientsOrganization] = None
    r"""The API resource URL of the client's organization."""

    onboarding: Optional[ListClientsClientsOnboarding] = None
    r"""The API resource URL of the client's onboarding status."""

    documentation: Optional[ListClientsClientsResponse200Documentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListClientsAddressTypedDict(TypedDict):
    r"""The address of the organization."""

    street_and_number: NotRequired[str]
    r"""A street and street number."""
    postal_code: NotRequired[str]
    r"""A postal code. This field may be required if the provided country has a postal code system."""
    city: NotRequired[str]
    country: NotRequired[str]
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""


class ListClientsAddress(BaseModel):
    r"""The address of the organization."""

    street_and_number: Annotated[
        Optional[str], pydantic.Field(alias="streetAndNumber")
    ] = None
    r"""A street and street number."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""A postal code. This field may be required if the provided country has a postal code system."""

    city: Optional[str] = None

    country: Optional[str] = None
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format."""


class ListClientsClientsResponse200SelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsClientsResponse200Self(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsDashboardTypedDict(TypedDict):
    r"""Direct link to the organization's Mollie dashboard."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsDashboard(BaseModel):
    r"""Direct link to the organization's Mollie dashboard."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsClientsResponse200ApplicationHalPlusJSONResponseBodyDocumentationTypedDict(
    TypedDict
):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsClientsResponse200ApplicationHalPlusJSONResponseBodyDocumentation(
    BaseModel
):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsClientsResponse200ApplicationHalPlusJSONResponseBodyLinksTypedDict(
    TypedDict
):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListClientsClientsResponse200SelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    dashboard: NotRequired[ListClientsDashboardTypedDict]
    r"""Direct link to the organization's Mollie dashboard."""
    documentation: NotRequired[
        ListClientsClientsResponse200ApplicationHalPlusJSONResponseBodyDocumentationTypedDict
    ]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListClientsClientsResponse200ApplicationHalPlusJSONResponseBodyLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[
        Optional[ListClientsClientsResponse200Self], pydantic.Field(alias="self")
    ] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    dashboard: Optional[ListClientsDashboard] = None
    r"""Direct link to the organization's Mollie dashboard."""

    documentation: Optional[
        ListClientsClientsResponse200ApplicationHalPlusJSONResponseBodyDocumentation
    ] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListClientsClientsOrganizationTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains an organization object. Will always contain the string `organization` for this resource type."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this organization. Example: `org_12345678`."""
    name: NotRequired[str]
    r"""The name of the organization."""
    email: NotRequired[str]
    r"""The email address associated with the organization."""
    locale: NotRequired[str]
    r"""The preferred locale of the merchant, as set in their Mollie dashboard."""
    address: NotRequired[ListClientsAddressTypedDict]
    r"""The address of the organization."""
    registration_number: NotRequired[str]
    r"""The registration number of the organization at their local chamber of commerce."""
    vat_number: NotRequired[Nullable[str]]
    r"""The VAT number of the organization, if based in the European Union or in The United Kingdom. VAT numbers are verified against the international registry *VIES*.

    The field is not present for merchants residing in other countries.
    """
    vat_regulation: NotRequired[Nullable[str]]
    r"""Mollie applies Dutch VAT for merchants based in The Netherlands, British VAT for merchants based in The United Kingdom, and shifted VAT for merchants in the European Union.

    The field is not present for merchants residing in other countries.

    Possible values: `dutch` `british` `shifted`
    """
    links: NotRequired[
        ListClientsClientsResponse200ApplicationHalPlusJSONResponseBodyLinksTypedDict
    ]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class ListClientsClientsOrganization(BaseModel):
    resource: Optional[str] = "organization"
    r"""Indicates the response contains an organization object. Will always contain the string `organization` for this resource type."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this organization. Example: `org_12345678`."""

    name: Optional[str] = None
    r"""The name of the organization."""

    email: Optional[str] = None
    r"""The email address associated with the organization."""

    locale: Optional[str] = None
    r"""The preferred locale of the merchant, as set in their Mollie dashboard."""

    address: Optional[ListClientsAddress] = None
    r"""The address of the organization."""

    registration_number: Annotated[
        Optional[str], pydantic.Field(alias="registrationNumber")
    ] = None
    r"""The registration number of the organization at their local chamber of commerce."""

    vat_number: Annotated[OptionalNullable[str], pydantic.Field(alias="vatNumber")] = (
        UNSET
    )
    r"""The VAT number of the organization, if based in the European Union or in The United Kingdom. VAT numbers are verified against the international registry *VIES*.

    The field is not present for merchants residing in other countries.
    """

    vat_regulation: Annotated[
        OptionalNullable[str], pydantic.Field(alias="vatRegulation")
    ] = UNSET
    r"""Mollie applies Dutch VAT for merchants based in The Netherlands, British VAT for merchants based in The United Kingdom, and shifted VAT for merchants in the European Union.

    The field is not present for merchants residing in other countries.

    Possible values: `dutch` `british` `shifted`
    """

    links: Annotated[
        Optional[ListClientsClientsResponse200ApplicationHalPlusJSONResponseBodyLinks],
        pydantic.Field(alias="_links"),
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "name",
            "email",
            "locale",
            "address",
            "registrationNumber",
            "vatNumber",
            "vatRegulation",
            "_links",
        ]
        nullable_fields = ["vatNumber", "vatRegulation"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListClientsClientsResponseSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsClientsResponseSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsClientsDashboardTypedDict(TypedDict):
    r"""Direct link to the onboarding process in the Mollie dashboard. The merchant can be redirected to this page to complete their onboarding."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsClientsDashboard(BaseModel):
    r"""Direct link to the onboarding process in the Mollie dashboard. The merchant can be redirected to this page to complete their onboarding."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsClientsResponseOrganizationTypedDict(TypedDict):
    r"""The API resource URL of the organization."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsClientsResponseOrganization(BaseModel):
    r"""The API resource URL of the organization."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsClientsResponse200ApplicationHalPlusJSONDocumentationTypedDict(
    TypedDict
):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsClientsResponse200ApplicationHalPlusJSONDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsClientsResponse200ApplicationHalPlusJSONLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListClientsClientsResponseSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    dashboard: NotRequired[ListClientsClientsDashboardTypedDict]
    r"""Direct link to the onboarding process in the Mollie dashboard. The merchant can be redirected to this page to complete their onboarding."""
    organization: NotRequired[ListClientsClientsResponseOrganizationTypedDict]
    r"""The API resource URL of the organization."""
    documentation: NotRequired[
        ListClientsClientsResponse200ApplicationHalPlusJSONDocumentationTypedDict
    ]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListClientsClientsResponse200ApplicationHalPlusJSONLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[
        Optional[ListClientsClientsResponseSelf], pydantic.Field(alias="self")
    ] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    dashboard: Optional[ListClientsClientsDashboard] = None
    r"""Direct link to the onboarding process in the Mollie dashboard. The merchant can be redirected to this page to complete their onboarding."""

    organization: Optional[ListClientsClientsResponseOrganization] = None
    r"""The API resource URL of the organization."""

    documentation: Optional[
        ListClientsClientsResponse200ApplicationHalPlusJSONDocumentation
    ] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListClientsOnboardingTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains an onboarding status object. Will always contain the string `onboarding` for this resource type."""
    name: NotRequired[str]
    r"""The name of the organization."""
    status: NotRequired[str]
    r"""The current status of the organization's onboarding process.

    * `needs-data` — The merchant needs to provide additional information
    * `in-review` — The merchant provided all information, awaiting review from Mollie
    * `completed` — The onboarding is completed

    Possible values: `needs-data` `in-review` `completed`
    """
    can_receive_payments: NotRequired[bool]
    r"""Whether the organization can receive payments."""
    can_receive_settlements: NotRequired[bool]
    r"""Whether the organization can receive settlements to their external bank account."""
    signed_up_at: NotRequired[str]
    r"""The sign up date time of the organization in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: NotRequired[
        ListClientsClientsResponse200ApplicationHalPlusJSONLinksTypedDict
    ]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class ListClientsOnboarding(BaseModel):
    resource: Optional[str] = "onboarding"
    r"""Indicates the response contains an onboarding status object. Will always contain the string `onboarding` for this resource type."""

    name: Optional[str] = None
    r"""The name of the organization."""

    status: Optional[str] = None
    r"""The current status of the organization's onboarding process.

    * `needs-data` — The merchant needs to provide additional information
    * `in-review` — The merchant provided all information, awaiting review from Mollie
    * `completed` — The onboarding is completed

    Possible values: `needs-data` `in-review` `completed`
    """

    can_receive_payments: Annotated[
        Optional[bool], pydantic.Field(alias="canReceivePayments")
    ] = None
    r"""Whether the organization can receive payments."""

    can_receive_settlements: Annotated[
        Optional[bool], pydantic.Field(alias="canReceiveSettlements")
    ] = None
    r"""Whether the organization can receive settlements to their external bank account."""

    signed_up_at: Annotated[Optional[str], pydantic.Field(alias="signedUpAt")] = None
    r"""The sign up date time of the organization in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[
        Optional[ListClientsClientsResponse200ApplicationHalPlusJSONLinks],
        pydantic.Field(alias="_links"),
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class ListClientsStatus(str, Enum):
    UNREQUESTED = "unrequested"
    ENABLED = "enabled"
    DISABLED = "disabled"
    PENDING = "pending"


class ListClientsStatusReason(str, Enum):
    REQUIREMENT_PAST_DUE = "requirement-past-due"
    ONBOARDING_INFORMATION_NEEDED = "onboarding-information-needed"


class ListClientsClientsResponseDashboardTypedDict(TypedDict):
    r"""If known, a deep link to the Mollie dashboard of the client, where the requirement can be fulfilled. For example, where necessary documents are to be uploaded."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsClientsResponseDashboard(BaseModel):
    r"""If known, a deep link to the Mollie dashboard of the client, where the requirement can be fulfilled. For example, where necessary documents are to be uploaded."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsClientsResponse200ApplicationHalPlusJSONResponseBodyEmbeddedLinksTypedDict(
    TypedDict
):
    dashboard: NotRequired[ListClientsClientsResponseDashboardTypedDict]
    r"""If known, a deep link to the Mollie dashboard of the client, where the requirement can be fulfilled. For example, where necessary documents are to be uploaded."""


class ListClientsClientsResponse200ApplicationHalPlusJSONResponseBodyEmbeddedLinks(
    BaseModel
):
    dashboard: Optional[ListClientsClientsResponseDashboard] = None
    r"""If known, a deep link to the Mollie dashboard of the client, where the requirement can be fulfilled. For example, where necessary documents are to be uploaded."""


class ListClientsRequirementsTypedDict(TypedDict):
    id: NotRequired[str]
    r"""The name of this requirement, referring to the task to be fulfilled by the organization to enable or re-enable the capability. The name is unique among other requirements of the same capability."""
    status: NotRequired[str]
    r"""The status of the requirement depends on its due date. If no due date is given, the status will be `requested`.

    Possible values: `currently-due` `past-due` `requested`
    """
    due_date: NotRequired[Nullable[str]]
    r"""Due date until the requirement must be fulfilled, if any. The date is shown in ISO-8601 format."""
    links: NotRequired[
        ListClientsClientsResponse200ApplicationHalPlusJSONResponseBodyEmbeddedLinksTypedDict
    ]


class ListClientsRequirements(BaseModel):
    id: Optional[str] = None
    r"""The name of this requirement, referring to the task to be fulfilled by the organization to enable or re-enable the capability. The name is unique among other requirements of the same capability."""

    status: Optional[str] = None
    r"""The status of the requirement depends on its due date. If no due date is given, the status will be `requested`.

    Possible values: `currently-due` `past-due` `requested`
    """

    due_date: Annotated[OptionalNullable[str], pydantic.Field(alias="dueDate")] = UNSET
    r"""Due date until the requirement must be fulfilled, if any. The date is shown in ISO-8601 format."""

    links: Annotated[
        Optional[
            ListClientsClientsResponse200ApplicationHalPlusJSONResponseBodyEmbeddedLinks
        ],
        pydantic.Field(alias="_links"),
    ] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "status", "dueDate", "_links"]
        nullable_fields = ["dueDate"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListClientsCapabilitiesTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Always the word `capability` for this resource type."""
    name: NotRequired[str]
    r"""A unique name for this capability like `payments` / `settlements`."""
    status: NotRequired[ListClientsStatus]
    status_reason: NotRequired[Nullable[ListClientsStatusReason]]
    requirements: NotRequired[List[ListClientsRequirementsTypedDict]]


class ListClientsCapabilities(BaseModel):
    resource: Optional[str] = None
    r"""Always the word `capability` for this resource type."""

    name: Optional[str] = None
    r"""A unique name for this capability like `payments` / `settlements`."""

    status: Optional[ListClientsStatus] = None

    status_reason: Annotated[
        OptionalNullable[ListClientsStatusReason], pydantic.Field(alias="statusReason")
    ] = UNSET

    requirements: Optional[List[ListClientsRequirements]] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["resource", "name", "status", "statusReason", "requirements"]
        nullable_fields = ["statusReason"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListClientsClientsEmbeddedTypedDict(TypedDict):
    organization: NotRequired[ListClientsClientsOrganizationTypedDict]
    onboarding: NotRequired[ListClientsOnboardingTypedDict]
    capabilities: NotRequired[ListClientsCapabilitiesTypedDict]


class ListClientsClientsEmbedded(BaseModel):
    organization: Optional[ListClientsClientsOrganization] = None

    onboarding: Optional[ListClientsOnboarding] = None

    capabilities: Optional[ListClientsCapabilities] = None


class ListClientsClientsTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a client object. Will always contain the string `client` for this resource type."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this client. Example: `org_12345678`."""
    commission: NotRequired[Nullable[ListClientsCommissionTypedDict]]
    r"""The commission object."""
    organization_created_at: NotRequired[str]
    r"""The date and time the client organization was created, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: NotRequired[ListClientsClientsResponse200LinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    embedded: NotRequired[ListClientsClientsEmbeddedTypedDict]


class ListClientsClients(BaseModel):
    resource: Optional[str] = "client"
    r"""Indicates the response contains a client object. Will always contain the string `client` for this resource type."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this client. Example: `org_12345678`."""

    commission: OptionalNullable[ListClientsCommission] = UNSET
    r"""The commission object."""

    organization_created_at: Annotated[
        Optional[str], pydantic.Field(alias="organizationCreatedAt")
    ] = None
    r"""The date and time the client organization was created, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[
        Optional[ListClientsClientsResponse200Links], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    embedded: Annotated[
        Optional[ListClientsClientsEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "commission",
            "organizationCreatedAt",
            "_links",
            "_embedded",
        ]
        nullable_fields = ["commission"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListClientsEmbeddedTypedDict(TypedDict):
    clients: NotRequired[List[ListClientsClientsTypedDict]]
    r"""An array of client objects. For a complete reference of the client object, refer to the [Get client endpoint](get-client) documentation."""


class ListClientsEmbedded(BaseModel):
    clients: Optional[List[ListClientsClients]] = None
    r"""An array of client objects. For a complete reference of the client object, refer to the [Get client endpoint](get-client) documentation."""


class ListClientsSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListClientsLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListClientsSelfTypedDict]
    r"""The URL to the current set of items."""
    previous: NotRequired[Nullable[ListClientsPreviousTypedDict]]
    r"""The previous set of items, if available."""
    next: NotRequired[Nullable[ListClientsNextTypedDict]]
    r"""The next set of items, if available."""
    documentation: NotRequired[ListClientsDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListClientsLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[ListClientsSelf], pydantic.Field(alias="self")] = None
    r"""The URL to the current set of items."""

    previous: OptionalNullable[ListClientsPrevious] = UNSET
    r"""The previous set of items, if available."""

    next: OptionalNullable[ListClientsNext] = UNSET
    r"""The next set of items, if available."""

    documentation: Optional[ListClientsDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "previous", "next", "documentation"]
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListClientsResponseBodyTypedDict(TypedDict):
    r"""A list of client objects. For a complete reference of the client object, refer to the [Get client endpoint](get-client) documentation."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """
    embedded: NotRequired[ListClientsEmbeddedTypedDict]
    links: NotRequired[ListClientsLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListClientsResponseBody(BaseModel):
    r"""A list of client objects. For a complete reference of the client object, refer to the [Get client endpoint](get-client) documentation."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """

    embedded: Annotated[
        Optional[ListClientsEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[Optional[ListClientsLinks], pydantic.Field(alias="_links")] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
