# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAnalyticsInstanceResult',
    'AwaitableGetAnalyticsInstanceResult',
    'get_analytics_instance',
    'get_analytics_instance_output',
]

@pulumi.output_type
class GetAnalyticsInstanceResult:
    """
    A collection of values returned by getAnalyticsInstance.
    """
    def __init__(__self__, admin_user=None, analytics_instance_id=None, capacities=None, compartment_id=None, defined_tags=None, description=None, domain_id=None, email_notification=None, feature_bundle=None, feature_set=None, freeform_tags=None, id=None, idcs_access_token=None, kms_key_id=None, license_type=None, name=None, network_endpoint_details=None, service_url=None, state=None, system_tags=None, time_created=None, time_updated=None, update_channel=None):
        if admin_user and not isinstance(admin_user, str):
            raise TypeError("Expected argument 'admin_user' to be a str")
        pulumi.set(__self__, "admin_user", admin_user)
        if analytics_instance_id and not isinstance(analytics_instance_id, str):
            raise TypeError("Expected argument 'analytics_instance_id' to be a str")
        pulumi.set(__self__, "analytics_instance_id", analytics_instance_id)
        if capacities and not isinstance(capacities, list):
            raise TypeError("Expected argument 'capacities' to be a list")
        pulumi.set(__self__, "capacities", capacities)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain_id and not isinstance(domain_id, str):
            raise TypeError("Expected argument 'domain_id' to be a str")
        pulumi.set(__self__, "domain_id", domain_id)
        if email_notification and not isinstance(email_notification, str):
            raise TypeError("Expected argument 'email_notification' to be a str")
        pulumi.set(__self__, "email_notification", email_notification)
        if feature_bundle and not isinstance(feature_bundle, str):
            raise TypeError("Expected argument 'feature_bundle' to be a str")
        pulumi.set(__self__, "feature_bundle", feature_bundle)
        if feature_set and not isinstance(feature_set, str):
            raise TypeError("Expected argument 'feature_set' to be a str")
        pulumi.set(__self__, "feature_set", feature_set)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if idcs_access_token and not isinstance(idcs_access_token, str):
            raise TypeError("Expected argument 'idcs_access_token' to be a str")
        pulumi.set(__self__, "idcs_access_token", idcs_access_token)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if license_type and not isinstance(license_type, str):
            raise TypeError("Expected argument 'license_type' to be a str")
        pulumi.set(__self__, "license_type", license_type)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_endpoint_details and not isinstance(network_endpoint_details, list):
            raise TypeError("Expected argument 'network_endpoint_details' to be a list")
        pulumi.set(__self__, "network_endpoint_details", network_endpoint_details)
        if service_url and not isinstance(service_url, str):
            raise TypeError("Expected argument 'service_url' to be a str")
        pulumi.set(__self__, "service_url", service_url)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if update_channel and not isinstance(update_channel, str):
            raise TypeError("Expected argument 'update_channel' to be a str")
        pulumi.set(__self__, "update_channel", update_channel)

    @property
    @pulumi.getter(name="adminUser")
    def admin_user(self) -> str:
        return pulumi.get(self, "admin_user")

    @property
    @pulumi.getter(name="analyticsInstanceId")
    def analytics_instance_id(self) -> str:
        return pulumi.get(self, "analytics_instance_id")

    @property
    @pulumi.getter
    def capacities(self) -> Sequence['outputs.GetAnalyticsInstanceCapacityResult']:
        """
        Service instance capacity metadata (e.g.: OLPU count, number of users, ...etc...).
        """
        return pulumi.get(self, "capacities")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the vanity url.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> str:
        """
        Identity domain OCID.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="emailNotification")
    def email_notification(self) -> str:
        """
        Email address receiving notifications.
        """
        return pulumi.get(self, "email_notification")

    @property
    @pulumi.getter(name="featureBundle")
    def feature_bundle(self) -> str:
        """
        The feature set of an Analytics instance.
        """
        return pulumi.get(self, "feature_bundle")

    @property
    @pulumi.getter(name="featureSet")
    def feature_set(self) -> str:
        """
        Analytics feature set.
        """
        return pulumi.get(self, "feature_set")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idcsAccessToken")
    def idcs_access_token(self) -> str:
        return pulumi.get(self, "idcs_access_token")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        OCID of the Oracle Cloud Infrastructure Vault Key encrypting the customer data stored in this Analytics instance. A null value indicates Oracle managed default encryption.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> str:
        """
        The license used for the service.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Analytics instance. This name must be unique in the tenancy and cannot be changed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkEndpointDetails")
    def network_endpoint_details(self) -> Sequence['outputs.GetAnalyticsInstanceNetworkEndpointDetailResult']:
        """
        Base representation of a network endpoint.
        """
        return pulumi.get(self, "network_endpoint_details")

    @property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> str:
        """
        URL of the Analytics service.
        """
        return pulumi.get(self, "service_url")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of an instance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.key": "value"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the instance was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the instance was last updated (in the format defined by RFC3339). This timestamp represents updates made through this API. External events do not influence it.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="updateChannel")
    def update_channel(self) -> str:
        """
        Analytics instance update channel.
        """
        return pulumi.get(self, "update_channel")


class AwaitableGetAnalyticsInstanceResult(GetAnalyticsInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAnalyticsInstanceResult(
            admin_user=self.admin_user,
            analytics_instance_id=self.analytics_instance_id,
            capacities=self.capacities,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            domain_id=self.domain_id,
            email_notification=self.email_notification,
            feature_bundle=self.feature_bundle,
            feature_set=self.feature_set,
            freeform_tags=self.freeform_tags,
            id=self.id,
            idcs_access_token=self.idcs_access_token,
            kms_key_id=self.kms_key_id,
            license_type=self.license_type,
            name=self.name,
            network_endpoint_details=self.network_endpoint_details,
            service_url=self.service_url,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            update_channel=self.update_channel)


def get_analytics_instance(analytics_instance_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAnalyticsInstanceResult:
    """
    This data source provides details about a specific Analytics Instance resource in Oracle Cloud Infrastructure Analytics service.

    Info for a specific Analytics instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_analytics_instance = oci.Analytics.get_analytics_instance(analytics_instance_id=test_analytics_instance_oci_analytics_analytics_instance["id"])
    ```


    :param str analytics_instance_id: The OCID of the AnalyticsInstance.
    """
    __args__ = dict()
    __args__['analyticsInstanceId'] = analytics_instance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Analytics/getAnalyticsInstance:getAnalyticsInstance', __args__, opts=opts, typ=GetAnalyticsInstanceResult).value

    return AwaitableGetAnalyticsInstanceResult(
        admin_user=pulumi.get(__ret__, 'admin_user'),
        analytics_instance_id=pulumi.get(__ret__, 'analytics_instance_id'),
        capacities=pulumi.get(__ret__, 'capacities'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        domain_id=pulumi.get(__ret__, 'domain_id'),
        email_notification=pulumi.get(__ret__, 'email_notification'),
        feature_bundle=pulumi.get(__ret__, 'feature_bundle'),
        feature_set=pulumi.get(__ret__, 'feature_set'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        idcs_access_token=pulumi.get(__ret__, 'idcs_access_token'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        license_type=pulumi.get(__ret__, 'license_type'),
        name=pulumi.get(__ret__, 'name'),
        network_endpoint_details=pulumi.get(__ret__, 'network_endpoint_details'),
        service_url=pulumi.get(__ret__, 'service_url'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        update_channel=pulumi.get(__ret__, 'update_channel'))
def get_analytics_instance_output(analytics_instance_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAnalyticsInstanceResult]:
    """
    This data source provides details about a specific Analytics Instance resource in Oracle Cloud Infrastructure Analytics service.

    Info for a specific Analytics instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_analytics_instance = oci.Analytics.get_analytics_instance(analytics_instance_id=test_analytics_instance_oci_analytics_analytics_instance["id"])
    ```


    :param str analytics_instance_id: The OCID of the AnalyticsInstance.
    """
    __args__ = dict()
    __args__['analyticsInstanceId'] = analytics_instance_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Analytics/getAnalyticsInstance:getAnalyticsInstance', __args__, opts=opts, typ=GetAnalyticsInstanceResult)
    return __ret__.apply(lambda __response__: GetAnalyticsInstanceResult(
        admin_user=pulumi.get(__response__, 'admin_user'),
        analytics_instance_id=pulumi.get(__response__, 'analytics_instance_id'),
        capacities=pulumi.get(__response__, 'capacities'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        domain_id=pulumi.get(__response__, 'domain_id'),
        email_notification=pulumi.get(__response__, 'email_notification'),
        feature_bundle=pulumi.get(__response__, 'feature_bundle'),
        feature_set=pulumi.get(__response__, 'feature_set'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        idcs_access_token=pulumi.get(__response__, 'idcs_access_token'),
        kms_key_id=pulumi.get(__response__, 'kms_key_id'),
        license_type=pulumi.get(__response__, 'license_type'),
        name=pulumi.get(__response__, 'name'),
        network_endpoint_details=pulumi.get(__response__, 'network_endpoint_details'),
        service_url=pulumi.get(__response__, 'service_url'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        update_channel=pulumi.get(__response__, 'update_channel')))
