# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetGenericArtifactsResult',
    'AwaitableGetGenericArtifactsResult',
    'get_generic_artifacts',
    'get_generic_artifacts_output',
]

@pulumi.output_type
class GetGenericArtifactsResult:
    """
    A collection of values returned by getGenericArtifacts.
    """
    def __init__(__self__, artifact_path=None, compartment_id=None, display_name=None, filters=None, generic_artifact_collections=None, id=None, repository_id=None, sha256=None, state=None, version=None):
        if artifact_path and not isinstance(artifact_path, str):
            raise TypeError("Expected argument 'artifact_path' to be a str")
        pulumi.set(__self__, "artifact_path", artifact_path)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if generic_artifact_collections and not isinstance(generic_artifact_collections, list):
            raise TypeError("Expected argument 'generic_artifact_collections' to be a list")
        pulumi.set(__self__, "generic_artifact_collections", generic_artifact_collections)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if sha256 and not isinstance(sha256, str):
            raise TypeError("Expected argument 'sha256' to be a str")
        pulumi.set(__self__, "sha256", sha256)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="artifactPath")
    def artifact_path(self) -> Optional[str]:
        """
        A user-defined path to describe the location of an artifact. Slashes do not create a directory structure, but you can use slashes to organize the repository. An artifact path does not include an artifact version.  Example: `project01/my-web-app/artifact-abc`
        """
        return pulumi.get(self, "artifact_path")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the repository's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The artifact name with the format of `<artifact-path>:<artifact-version>`. The artifact name is truncated to a maximum length of 255.  Example: `project01/my-web-app/artifact-abc:1.0.0`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetGenericArtifactsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="genericArtifactCollections")
    def generic_artifact_collections(self) -> Sequence['outputs.GetGenericArtifactsGenericArtifactCollectionResult']:
        """
        The list of generic_artifact_collection.
        """
        return pulumi.get(self, "generic_artifact_collections")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the artifact.  Example: `ocid1.genericartifact.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the repository.
        """
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter
    def sha256(self) -> Optional[str]:
        """
        The SHA256 digest for the artifact. When you upload an artifact to the repository, a SHA256 digest is calculated and added to the artifact properties.
        """
        return pulumi.get(self, "sha256")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the artifact.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        A user-defined string to describe the artifact version.  Example: `1.1.0` or `1.2-beta-2`
        """
        return pulumi.get(self, "version")


class AwaitableGetGenericArtifactsResult(GetGenericArtifactsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGenericArtifactsResult(
            artifact_path=self.artifact_path,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            generic_artifact_collections=self.generic_artifact_collections,
            id=self.id,
            repository_id=self.repository_id,
            sha256=self.sha256,
            state=self.state,
            version=self.version)


def get_generic_artifacts(artifact_path: Optional[str] = None,
                          compartment_id: Optional[str] = None,
                          display_name: Optional[str] = None,
                          filters: Optional[Sequence[Union['GetGenericArtifactsFilterArgs', 'GetGenericArtifactsFilterArgsDict']]] = None,
                          id: Optional[str] = None,
                          repository_id: Optional[str] = None,
                          sha256: Optional[str] = None,
                          state: Optional[str] = None,
                          version: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGenericArtifactsResult:
    """
    This data source provides the list of Generic Artifacts in Oracle Cloud Infrastructure Artifacts service.

    Lists artifacts in the specified repository.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_generic_artifacts = oci.Artifacts.get_generic_artifacts(compartment_id=compartment_id,
        repository_id=test_repository["id"],
        artifact_path=generic_artifact_artifact_path,
        display_name=generic_artifact_display_name,
        id=generic_artifact_id,
        sha256=generic_artifact_sha256,
        state=generic_artifact_state,
        version=generic_artifact_version)
    ```


    :param str artifact_path: Filter results by a prefix for the `artifactPath` and and return artifacts that begin with the specified prefix in their path.
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str id: A filter to return the resources for the specified OCID.
    :param str repository_id: A filter to return the artifacts only for the specified repository OCID.
    :param str sha256: Filter results by a specified SHA256 digest for the artifact.
    :param str state: A filter to return only resources that match the given lifecycle state name exactly.
    :param str version: Filter results by a prefix for `version` and return artifacts that that begin with the specified prefix in their version.
    """
    __args__ = dict()
    __args__['artifactPath'] = artifact_path
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['repositoryId'] = repository_id
    __args__['sha256'] = sha256
    __args__['state'] = state
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Artifacts/getGenericArtifacts:getGenericArtifacts', __args__, opts=opts, typ=GetGenericArtifactsResult).value

    return AwaitableGetGenericArtifactsResult(
        artifact_path=pulumi.get(__ret__, 'artifact_path'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        generic_artifact_collections=pulumi.get(__ret__, 'generic_artifact_collections'),
        id=pulumi.get(__ret__, 'id'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        sha256=pulumi.get(__ret__, 'sha256'),
        state=pulumi.get(__ret__, 'state'),
        version=pulumi.get(__ret__, 'version'))
def get_generic_artifacts_output(artifact_path: Optional[pulumi.Input[Optional[str]]] = None,
                                 compartment_id: Optional[pulumi.Input[str]] = None,
                                 display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetGenericArtifactsFilterArgs', 'GetGenericArtifactsFilterArgsDict']]]]] = None,
                                 id: Optional[pulumi.Input[Optional[str]]] = None,
                                 repository_id: Optional[pulumi.Input[str]] = None,
                                 sha256: Optional[pulumi.Input[Optional[str]]] = None,
                                 state: Optional[pulumi.Input[Optional[str]]] = None,
                                 version: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGenericArtifactsResult]:
    """
    This data source provides the list of Generic Artifacts in Oracle Cloud Infrastructure Artifacts service.

    Lists artifacts in the specified repository.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_generic_artifacts = oci.Artifacts.get_generic_artifacts(compartment_id=compartment_id,
        repository_id=test_repository["id"],
        artifact_path=generic_artifact_artifact_path,
        display_name=generic_artifact_display_name,
        id=generic_artifact_id,
        sha256=generic_artifact_sha256,
        state=generic_artifact_state,
        version=generic_artifact_version)
    ```


    :param str artifact_path: Filter results by a prefix for the `artifactPath` and and return artifacts that begin with the specified prefix in their path.
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str id: A filter to return the resources for the specified OCID.
    :param str repository_id: A filter to return the artifacts only for the specified repository OCID.
    :param str sha256: Filter results by a specified SHA256 digest for the artifact.
    :param str state: A filter to return only resources that match the given lifecycle state name exactly.
    :param str version: Filter results by a prefix for `version` and return artifacts that that begin with the specified prefix in their version.
    """
    __args__ = dict()
    __args__['artifactPath'] = artifact_path
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['repositoryId'] = repository_id
    __args__['sha256'] = sha256
    __args__['state'] = state
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Artifacts/getGenericArtifacts:getGenericArtifacts', __args__, opts=opts, typ=GetGenericArtifactsResult)
    return __ret__.apply(lambda __response__: GetGenericArtifactsResult(
        artifact_path=pulumi.get(__response__, 'artifact_path'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        generic_artifact_collections=pulumi.get(__response__, 'generic_artifact_collections'),
        id=pulumi.get(__response__, 'id'),
        repository_id=pulumi.get(__response__, 'repository_id'),
        sha256=pulumi.get(__response__, 'sha256'),
        state=pulumi.get(__response__, 'state'),
        version=pulumi.get(__response__, 'version')))
