# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AgentPluginListArgs',
    'AgentPluginListArgsDict',
    'AssetComputeArgs',
    'AssetComputeArgsDict',
    'AssetComputeDiskArgs',
    'AssetComputeDiskArgsDict',
    'AssetComputeGpuDeviceArgs',
    'AssetComputeGpuDeviceArgsDict',
    'AssetComputeNicArgs',
    'AssetComputeNicArgsDict',
    'AssetComputeNvdimmArgs',
    'AssetComputeNvdimmArgsDict',
    'AssetComputeNvdimmControllerArgs',
    'AssetComputeNvdimmControllerArgsDict',
    'AssetComputeScsiControllerArgs',
    'AssetComputeScsiControllerArgsDict',
    'AssetSourceDiscoveryCredentialsArgs',
    'AssetSourceDiscoveryCredentialsArgsDict',
    'AssetSourceReplicationCredentialsArgs',
    'AssetSourceReplicationCredentialsArgsDict',
    'AssetVmArgs',
    'AssetVmArgsDict',
    'AssetVmwareVcenterArgs',
    'AssetVmwareVcenterArgsDict',
    'AssetVmwareVmArgs',
    'AssetVmwareVmArgsDict',
    'AssetVmwareVmCustomerTagArgs',
    'AssetVmwareVmCustomerTagArgsDict',
    'GetAgentDependenciesFilterArgs',
    'GetAgentDependenciesFilterArgsDict',
    'GetAgentsFilterArgs',
    'GetAgentsFilterArgsDict',
    'GetApplianceImagesFilterArgs',
    'GetApplianceImagesFilterArgsDict',
    'GetAssetSourcesFilterArgs',
    'GetAssetSourcesFilterArgsDict',
    'GetAssetsFilterArgs',
    'GetAssetsFilterArgsDict',
    'GetDiscoverySchedulesFilterArgs',
    'GetDiscoverySchedulesFilterArgsDict',
    'GetEnvironmentsFilterArgs',
    'GetEnvironmentsFilterArgsDict',
    'GetInventoriesFilterArgs',
    'GetInventoriesFilterArgsDict',
]

MYPY = False

if not MYPY:
    class AgentPluginListArgsDict(TypedDict):
        agent_id: NotRequired[pulumi.Input[str]]
        """
        Agent identifier.
        """
        defined_tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        freeform_tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        lifecycle_details: NotRequired[pulumi.Input[str]]
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        Plugin identifier, which can be renamed.
        """
        plugin_version: NotRequired[pulumi.Input[str]]
        """
        Plugin version.
        """
        state: NotRequired[pulumi.Input[str]]
        """
        The current state of the Agent.
        """
        time_created: NotRequired[pulumi.Input[str]]
        """
        The time when the Agent was created. An RFC3339 formatted datetime string.
        """
        time_updated: NotRequired[pulumi.Input[str]]
        """
        The time when the Agent was updated. An RFC3339 formatted datetime string.
        """
elif False:
    AgentPluginListArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AgentPluginListArgs:
    def __init__(__self__, *,
                 agent_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 plugin_version: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] agent_id: Agent identifier.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] name: Plugin identifier, which can be renamed.
        :param pulumi.Input[str] plugin_version: Plugin version.
        :param pulumi.Input[str] state: The current state of the Agent.
        :param pulumi.Input[str] time_created: The time when the Agent was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time when the Agent was updated. An RFC3339 formatted datetime string.
        """
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plugin_version is not None:
            pulumi.set(__self__, "plugin_version", plugin_version)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[pulumi.Input[str]]:
        """
        Agent identifier.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) The defined tags associated with this resource, if any. Each key is predefined and scoped to namespaces. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) The freeform tags associated with this resource, if any. Each tag is a simple key-value pair with no predefined name, type, or namespace/scope. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Plugin identifier, which can be renamed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> Optional[pulumi.Input[str]]:
        """
        Plugin version.
        """
        return pulumi.get(self, "plugin_version")

    @plugin_version.setter
    def plugin_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plugin_version", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Agent.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the Agent was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the Agent was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


if not MYPY:
    class AssetComputeArgsDict(TypedDict):
        connected_networks: NotRequired[pulumi.Input[int]]
        """
        (Updatable) Number of connected networks.
        """
        cores_count: NotRequired[pulumi.Input[int]]
        """
        (Updatable) Number of CPUs.
        """
        cpu_model: NotRequired[pulumi.Input[str]]
        """
        (Updatable) CPU model name.
        """
        description: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Information about the asset.
        """
        disks: NotRequired[pulumi.Input[Sequence[pulumi.Input['AssetComputeDiskArgsDict']]]]
        """
        (Updatable) Lists the set of disks belonging to the virtual machine. This list is unordered.
        """
        disks_count: NotRequired[pulumi.Input[int]]
        """
        (Updatable) Number of disks.
        """
        dns_name: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Fully Qualified DNS Name.
        """
        firmware: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Information about firmware type for this virtual machine.
        """
        gpu_devices: NotRequired[pulumi.Input[Sequence[pulumi.Input['AssetComputeGpuDeviceArgsDict']]]]
        """
        (Updatable) List of GPU devices attached to a virtual machine.
        """
        gpu_devices_count: NotRequired[pulumi.Input[int]]
        """
        (Updatable) Number of GPU devices.
        """
        guest_state: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Guest state.
        """
        hardware_version: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Hardware version.
        """
        host_name: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Host name of the VM.
        """
        is_pmem_enabled: NotRequired[pulumi.Input[bool]]
        """
        (Updatable) Whether Pmem is enabled. Decides if NVDIMMs are used as a permanent memory.
        """
        is_tpm_enabled: NotRequired[pulumi.Input[bool]]
        """
        (Updatable) Whether Trusted Platform Module (TPM) is enabled.
        """
        latency_sensitivity: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Latency sensitivity.
        """
        memory_in_mbs: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Memory size in MBs.
        """
        nics: NotRequired[pulumi.Input[Sequence[pulumi.Input['AssetComputeNicArgsDict']]]]
        """
        (Updatable) List of network ethernet cards attached to a virtual machine.
        """
        nics_count: NotRequired[pulumi.Input[int]]
        """
        (Updatable) Number of network ethernet cards.
        """
        nvdimm_controller: NotRequired[pulumi.Input['AssetComputeNvdimmControllerArgsDict']]
        """
        (Updatable) The asset's NVDIMM configuration.
        """
        nvdimms: NotRequired[pulumi.Input[Sequence[pulumi.Input['AssetComputeNvdimmArgsDict']]]]
        """
        (Updatable) The properties of the NVDIMMs attached to a virtual machine.
        """
        operating_system: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Operating system.
        """
        operating_system_version: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Operating system version.
        """
        pmem_in_mbs: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Pmem size in MBs.
        """
        power_state: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The current power state of the virtual machine.
        """
        primary_ip: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Primary IP address of the compute instance.
        """
        scsi_controller: NotRequired[pulumi.Input['AssetComputeScsiControllerArgsDict']]
        """
        (Updatable) The assets SCSI controller.
        """
        storage_provisioned_in_mbs: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Provision storage size in MBs.
        """
        threads_per_core_count: NotRequired[pulumi.Input[int]]
        """
        (Updatable) Number of threads per core.
        """
elif False:
    AssetComputeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssetComputeArgs:
    def __init__(__self__, *,
                 connected_networks: Optional[pulumi.Input[int]] = None,
                 cores_count: Optional[pulumi.Input[int]] = None,
                 cpu_model: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['AssetComputeDiskArgs']]]] = None,
                 disks_count: Optional[pulumi.Input[int]] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 firmware: Optional[pulumi.Input[str]] = None,
                 gpu_devices: Optional[pulumi.Input[Sequence[pulumi.Input['AssetComputeGpuDeviceArgs']]]] = None,
                 gpu_devices_count: Optional[pulumi.Input[int]] = None,
                 guest_state: Optional[pulumi.Input[str]] = None,
                 hardware_version: Optional[pulumi.Input[str]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 is_pmem_enabled: Optional[pulumi.Input[bool]] = None,
                 is_tpm_enabled: Optional[pulumi.Input[bool]] = None,
                 latency_sensitivity: Optional[pulumi.Input[str]] = None,
                 memory_in_mbs: Optional[pulumi.Input[str]] = None,
                 nics: Optional[pulumi.Input[Sequence[pulumi.Input['AssetComputeNicArgs']]]] = None,
                 nics_count: Optional[pulumi.Input[int]] = None,
                 nvdimm_controller: Optional[pulumi.Input['AssetComputeNvdimmControllerArgs']] = None,
                 nvdimms: Optional[pulumi.Input[Sequence[pulumi.Input['AssetComputeNvdimmArgs']]]] = None,
                 operating_system: Optional[pulumi.Input[str]] = None,
                 operating_system_version: Optional[pulumi.Input[str]] = None,
                 pmem_in_mbs: Optional[pulumi.Input[str]] = None,
                 power_state: Optional[pulumi.Input[str]] = None,
                 primary_ip: Optional[pulumi.Input[str]] = None,
                 scsi_controller: Optional[pulumi.Input['AssetComputeScsiControllerArgs']] = None,
                 storage_provisioned_in_mbs: Optional[pulumi.Input[str]] = None,
                 threads_per_core_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] connected_networks: (Updatable) Number of connected networks.
        :param pulumi.Input[int] cores_count: (Updatable) Number of CPUs.
        :param pulumi.Input[str] cpu_model: (Updatable) CPU model name.
        :param pulumi.Input[str] description: (Updatable) Information about the asset.
        :param pulumi.Input[Sequence[pulumi.Input['AssetComputeDiskArgs']]] disks: (Updatable) Lists the set of disks belonging to the virtual machine. This list is unordered.
        :param pulumi.Input[int] disks_count: (Updatable) Number of disks.
        :param pulumi.Input[str] dns_name: (Updatable) Fully Qualified DNS Name.
        :param pulumi.Input[str] firmware: (Updatable) Information about firmware type for this virtual machine.
        :param pulumi.Input[Sequence[pulumi.Input['AssetComputeGpuDeviceArgs']]] gpu_devices: (Updatable) List of GPU devices attached to a virtual machine.
        :param pulumi.Input[int] gpu_devices_count: (Updatable) Number of GPU devices.
        :param pulumi.Input[str] guest_state: (Updatable) Guest state.
        :param pulumi.Input[str] hardware_version: (Updatable) Hardware version.
        :param pulumi.Input[str] host_name: (Updatable) Host name of the VM.
        :param pulumi.Input[bool] is_pmem_enabled: (Updatable) Whether Pmem is enabled. Decides if NVDIMMs are used as a permanent memory.
        :param pulumi.Input[bool] is_tpm_enabled: (Updatable) Whether Trusted Platform Module (TPM) is enabled.
        :param pulumi.Input[str] latency_sensitivity: (Updatable) Latency sensitivity.
        :param pulumi.Input[str] memory_in_mbs: (Updatable) Memory size in MBs.
        :param pulumi.Input[Sequence[pulumi.Input['AssetComputeNicArgs']]] nics: (Updatable) List of network ethernet cards attached to a virtual machine.
        :param pulumi.Input[int] nics_count: (Updatable) Number of network ethernet cards.
        :param pulumi.Input['AssetComputeNvdimmControllerArgs'] nvdimm_controller: (Updatable) The asset's NVDIMM configuration.
        :param pulumi.Input[Sequence[pulumi.Input['AssetComputeNvdimmArgs']]] nvdimms: (Updatable) The properties of the NVDIMMs attached to a virtual machine.
        :param pulumi.Input[str] operating_system: (Updatable) Operating system.
        :param pulumi.Input[str] operating_system_version: (Updatable) Operating system version.
        :param pulumi.Input[str] pmem_in_mbs: (Updatable) Pmem size in MBs.
        :param pulumi.Input[str] power_state: (Updatable) The current power state of the virtual machine.
        :param pulumi.Input[str] primary_ip: (Updatable) Primary IP address of the compute instance.
        :param pulumi.Input['AssetComputeScsiControllerArgs'] scsi_controller: (Updatable) The assets SCSI controller.
        :param pulumi.Input[str] storage_provisioned_in_mbs: (Updatable) Provision storage size in MBs.
        :param pulumi.Input[int] threads_per_core_count: (Updatable) Number of threads per core.
        """
        if connected_networks is not None:
            pulumi.set(__self__, "connected_networks", connected_networks)
        if cores_count is not None:
            pulumi.set(__self__, "cores_count", cores_count)
        if cpu_model is not None:
            pulumi.set(__self__, "cpu_model", cpu_model)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if disks_count is not None:
            pulumi.set(__self__, "disks_count", disks_count)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if firmware is not None:
            pulumi.set(__self__, "firmware", firmware)
        if gpu_devices is not None:
            pulumi.set(__self__, "gpu_devices", gpu_devices)
        if gpu_devices_count is not None:
            pulumi.set(__self__, "gpu_devices_count", gpu_devices_count)
        if guest_state is not None:
            pulumi.set(__self__, "guest_state", guest_state)
        if hardware_version is not None:
            pulumi.set(__self__, "hardware_version", hardware_version)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if is_pmem_enabled is not None:
            pulumi.set(__self__, "is_pmem_enabled", is_pmem_enabled)
        if is_tpm_enabled is not None:
            pulumi.set(__self__, "is_tpm_enabled", is_tpm_enabled)
        if latency_sensitivity is not None:
            pulumi.set(__self__, "latency_sensitivity", latency_sensitivity)
        if memory_in_mbs is not None:
            pulumi.set(__self__, "memory_in_mbs", memory_in_mbs)
        if nics is not None:
            pulumi.set(__self__, "nics", nics)
        if nics_count is not None:
            pulumi.set(__self__, "nics_count", nics_count)
        if nvdimm_controller is not None:
            pulumi.set(__self__, "nvdimm_controller", nvdimm_controller)
        if nvdimms is not None:
            pulumi.set(__self__, "nvdimms", nvdimms)
        if operating_system is not None:
            pulumi.set(__self__, "operating_system", operating_system)
        if operating_system_version is not None:
            pulumi.set(__self__, "operating_system_version", operating_system_version)
        if pmem_in_mbs is not None:
            pulumi.set(__self__, "pmem_in_mbs", pmem_in_mbs)
        if power_state is not None:
            pulumi.set(__self__, "power_state", power_state)
        if primary_ip is not None:
            pulumi.set(__self__, "primary_ip", primary_ip)
        if scsi_controller is not None:
            pulumi.set(__self__, "scsi_controller", scsi_controller)
        if storage_provisioned_in_mbs is not None:
            pulumi.set(__self__, "storage_provisioned_in_mbs", storage_provisioned_in_mbs)
        if threads_per_core_count is not None:
            pulumi.set(__self__, "threads_per_core_count", threads_per_core_count)

    @property
    @pulumi.getter(name="connectedNetworks")
    def connected_networks(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Number of connected networks.
        """
        return pulumi.get(self, "connected_networks")

    @connected_networks.setter
    def connected_networks(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connected_networks", value)

    @property
    @pulumi.getter(name="coresCount")
    def cores_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Number of CPUs.
        """
        return pulumi.get(self, "cores_count")

    @cores_count.setter
    def cores_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cores_count", value)

    @property
    @pulumi.getter(name="cpuModel")
    def cpu_model(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) CPU model name.
        """
        return pulumi.get(self, "cpu_model")

    @cpu_model.setter
    def cpu_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu_model", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Information about the asset.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AssetComputeDiskArgs']]]]:
        """
        (Updatable) Lists the set of disks belonging to the virtual machine. This list is unordered.
        """
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AssetComputeDiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @property
    @pulumi.getter(name="disksCount")
    def disks_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Number of disks.
        """
        return pulumi.get(self, "disks_count")

    @disks_count.setter
    def disks_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disks_count", value)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Fully Qualified DNS Name.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter
    def firmware(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Information about firmware type for this virtual machine.
        """
        return pulumi.get(self, "firmware")

    @firmware.setter
    def firmware(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firmware", value)

    @property
    @pulumi.getter(name="gpuDevices")
    def gpu_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AssetComputeGpuDeviceArgs']]]]:
        """
        (Updatable) List of GPU devices attached to a virtual machine.
        """
        return pulumi.get(self, "gpu_devices")

    @gpu_devices.setter
    def gpu_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AssetComputeGpuDeviceArgs']]]]):
        pulumi.set(self, "gpu_devices", value)

    @property
    @pulumi.getter(name="gpuDevicesCount")
    def gpu_devices_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Number of GPU devices.
        """
        return pulumi.get(self, "gpu_devices_count")

    @gpu_devices_count.setter
    def gpu_devices_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gpu_devices_count", value)

    @property
    @pulumi.getter(name="guestState")
    def guest_state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Guest state.
        """
        return pulumi.get(self, "guest_state")

    @guest_state.setter
    def guest_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "guest_state", value)

    @property
    @pulumi.getter(name="hardwareVersion")
    def hardware_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Hardware version.
        """
        return pulumi.get(self, "hardware_version")

    @hardware_version.setter
    def hardware_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hardware_version", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Host name of the VM.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="isPmemEnabled")
    def is_pmem_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether Pmem is enabled. Decides if NVDIMMs are used as a permanent memory.
        """
        return pulumi.get(self, "is_pmem_enabled")

    @is_pmem_enabled.setter
    def is_pmem_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_pmem_enabled", value)

    @property
    @pulumi.getter(name="isTpmEnabled")
    def is_tpm_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether Trusted Platform Module (TPM) is enabled.
        """
        return pulumi.get(self, "is_tpm_enabled")

    @is_tpm_enabled.setter
    def is_tpm_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_tpm_enabled", value)

    @property
    @pulumi.getter(name="latencySensitivity")
    def latency_sensitivity(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Latency sensitivity.
        """
        return pulumi.get(self, "latency_sensitivity")

    @latency_sensitivity.setter
    def latency_sensitivity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "latency_sensitivity", value)

    @property
    @pulumi.getter(name="memoryInMbs")
    def memory_in_mbs(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Memory size in MBs.
        """
        return pulumi.get(self, "memory_in_mbs")

    @memory_in_mbs.setter
    def memory_in_mbs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "memory_in_mbs", value)

    @property
    @pulumi.getter
    def nics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AssetComputeNicArgs']]]]:
        """
        (Updatable) List of network ethernet cards attached to a virtual machine.
        """
        return pulumi.get(self, "nics")

    @nics.setter
    def nics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AssetComputeNicArgs']]]]):
        pulumi.set(self, "nics", value)

    @property
    @pulumi.getter(name="nicsCount")
    def nics_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Number of network ethernet cards.
        """
        return pulumi.get(self, "nics_count")

    @nics_count.setter
    def nics_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nics_count", value)

    @property
    @pulumi.getter(name="nvdimmController")
    def nvdimm_controller(self) -> Optional[pulumi.Input['AssetComputeNvdimmControllerArgs']]:
        """
        (Updatable) The asset's NVDIMM configuration.
        """
        return pulumi.get(self, "nvdimm_controller")

    @nvdimm_controller.setter
    def nvdimm_controller(self, value: Optional[pulumi.Input['AssetComputeNvdimmControllerArgs']]):
        pulumi.set(self, "nvdimm_controller", value)

    @property
    @pulumi.getter
    def nvdimms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AssetComputeNvdimmArgs']]]]:
        """
        (Updatable) The properties of the NVDIMMs attached to a virtual machine.
        """
        return pulumi.get(self, "nvdimms")

    @nvdimms.setter
    def nvdimms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AssetComputeNvdimmArgs']]]]):
        pulumi.set(self, "nvdimms", value)

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Operating system.
        """
        return pulumi.get(self, "operating_system")

    @operating_system.setter
    def operating_system(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operating_system", value)

    @property
    @pulumi.getter(name="operatingSystemVersion")
    def operating_system_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Operating system version.
        """
        return pulumi.get(self, "operating_system_version")

    @operating_system_version.setter
    def operating_system_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operating_system_version", value)

    @property
    @pulumi.getter(name="pmemInMbs")
    def pmem_in_mbs(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Pmem size in MBs.
        """
        return pulumi.get(self, "pmem_in_mbs")

    @pmem_in_mbs.setter
    def pmem_in_mbs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pmem_in_mbs", value)

    @property
    @pulumi.getter(name="powerState")
    def power_state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The current power state of the virtual machine.
        """
        return pulumi.get(self, "power_state")

    @power_state.setter
    def power_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "power_state", value)

    @property
    @pulumi.getter(name="primaryIp")
    def primary_ip(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Primary IP address of the compute instance.
        """
        return pulumi.get(self, "primary_ip")

    @primary_ip.setter
    def primary_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_ip", value)

    @property
    @pulumi.getter(name="scsiController")
    def scsi_controller(self) -> Optional[pulumi.Input['AssetComputeScsiControllerArgs']]:
        """
        (Updatable) The assets SCSI controller.
        """
        return pulumi.get(self, "scsi_controller")

    @scsi_controller.setter
    def scsi_controller(self, value: Optional[pulumi.Input['AssetComputeScsiControllerArgs']]):
        pulumi.set(self, "scsi_controller", value)

    @property
    @pulumi.getter(name="storageProvisionedInMbs")
    def storage_provisioned_in_mbs(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Provision storage size in MBs.
        """
        return pulumi.get(self, "storage_provisioned_in_mbs")

    @storage_provisioned_in_mbs.setter
    def storage_provisioned_in_mbs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_provisioned_in_mbs", value)

    @property
    @pulumi.getter(name="threadsPerCoreCount")
    def threads_per_core_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Number of threads per core.
        """
        return pulumi.get(self, "threads_per_core_count")

    @threads_per_core_count.setter
    def threads_per_core_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "threads_per_core_count", value)


if not MYPY:
    class AssetComputeDiskArgsDict(TypedDict):
        boot_order: NotRequired[pulumi.Input[int]]
        """
        (Updatable) Order of boot volumes.
        """
        location: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Location of the boot/data volume.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Disk name.
        """
        persistent_mode: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The disk persistent mode.
        """
        size_in_mbs: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The size of the volume in MBs.
        """
        uuid: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Disk UUID for the virtual disk, if available.
        """
        uuid_lun: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Disk UUID LUN for the virtual disk, if available.
        """
elif False:
    AssetComputeDiskArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssetComputeDiskArgs:
    def __init__(__self__, *,
                 boot_order: Optional[pulumi.Input[int]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 persistent_mode: Optional[pulumi.Input[str]] = None,
                 size_in_mbs: Optional[pulumi.Input[str]] = None,
                 uuid: Optional[pulumi.Input[str]] = None,
                 uuid_lun: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] boot_order: (Updatable) Order of boot volumes.
        :param pulumi.Input[str] location: (Updatable) Location of the boot/data volume.
        :param pulumi.Input[str] name: (Updatable) Disk name.
        :param pulumi.Input[str] persistent_mode: (Updatable) The disk persistent mode.
        :param pulumi.Input[str] size_in_mbs: (Updatable) The size of the volume in MBs.
        :param pulumi.Input[str] uuid: (Updatable) Disk UUID for the virtual disk, if available.
        :param pulumi.Input[str] uuid_lun: (Updatable) Disk UUID LUN for the virtual disk, if available.
        """
        if boot_order is not None:
            pulumi.set(__self__, "boot_order", boot_order)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if persistent_mode is not None:
            pulumi.set(__self__, "persistent_mode", persistent_mode)
        if size_in_mbs is not None:
            pulumi.set(__self__, "size_in_mbs", size_in_mbs)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if uuid_lun is not None:
            pulumi.set(__self__, "uuid_lun", uuid_lun)

    @property
    @pulumi.getter(name="bootOrder")
    def boot_order(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Order of boot volumes.
        """
        return pulumi.get(self, "boot_order")

    @boot_order.setter
    def boot_order(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "boot_order", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Location of the boot/data volume.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Disk name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="persistentMode")
    def persistent_mode(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The disk persistent mode.
        """
        return pulumi.get(self, "persistent_mode")

    @persistent_mode.setter
    def persistent_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "persistent_mode", value)

    @property
    @pulumi.getter(name="sizeInMbs")
    def size_in_mbs(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The size of the volume in MBs.
        """
        return pulumi.get(self, "size_in_mbs")

    @size_in_mbs.setter
    def size_in_mbs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_in_mbs", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Disk UUID for the virtual disk, if available.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uuid", value)

    @property
    @pulumi.getter(name="uuidLun")
    def uuid_lun(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Disk UUID LUN for the virtual disk, if available.
        """
        return pulumi.get(self, "uuid_lun")

    @uuid_lun.setter
    def uuid_lun(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uuid_lun", value)


if not MYPY:
    class AssetComputeGpuDeviceArgsDict(TypedDict):
        cores_count: NotRequired[pulumi.Input[int]]
        """
        (Updatable) Number of GPU cores.
        """
        description: NotRequired[pulumi.Input[str]]
        """
        (Updatable) GPU device description.
        """
        manufacturer: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The manufacturer of GPU.
        """
        memory_in_mbs: NotRequired[pulumi.Input[str]]
        """
        (Updatable) GPU memory size in MBs.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        (Updatable) GPU device name.
        """
elif False:
    AssetComputeGpuDeviceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssetComputeGpuDeviceArgs:
    def __init__(__self__, *,
                 cores_count: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 manufacturer: Optional[pulumi.Input[str]] = None,
                 memory_in_mbs: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] cores_count: (Updatable) Number of GPU cores.
        :param pulumi.Input[str] description: (Updatable) GPU device description.
        :param pulumi.Input[str] manufacturer: (Updatable) The manufacturer of GPU.
        :param pulumi.Input[str] memory_in_mbs: (Updatable) GPU memory size in MBs.
        :param pulumi.Input[str] name: (Updatable) GPU device name.
        """
        if cores_count is not None:
            pulumi.set(__self__, "cores_count", cores_count)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if manufacturer is not None:
            pulumi.set(__self__, "manufacturer", manufacturer)
        if memory_in_mbs is not None:
            pulumi.set(__self__, "memory_in_mbs", memory_in_mbs)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="coresCount")
    def cores_count(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Number of GPU cores.
        """
        return pulumi.get(self, "cores_count")

    @cores_count.setter
    def cores_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cores_count", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) GPU device description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def manufacturer(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The manufacturer of GPU.
        """
        return pulumi.get(self, "manufacturer")

    @manufacturer.setter
    def manufacturer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manufacturer", value)

    @property
    @pulumi.getter(name="memoryInMbs")
    def memory_in_mbs(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) GPU memory size in MBs.
        """
        return pulumi.get(self, "memory_in_mbs")

    @memory_in_mbs.setter
    def memory_in_mbs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "memory_in_mbs", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) GPU device name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class AssetComputeNicArgsDict(TypedDict):
        ip_addresses: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        (Updatable) List of IP addresses.
        """
        label: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Provides a label and summary information for the device.
        """
        mac_address: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Mac address of the VM.
        """
        mac_address_type: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Mac address type.
        """
        network_name: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Network name.
        """
        switch_name: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Switch name.
        """
elif False:
    AssetComputeNicArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssetComputeNicArgs:
    def __init__(__self__, *,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 mac_address: Optional[pulumi.Input[str]] = None,
                 mac_address_type: Optional[pulumi.Input[str]] = None,
                 network_name: Optional[pulumi.Input[str]] = None,
                 switch_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: (Updatable) List of IP addresses.
        :param pulumi.Input[str] label: (Updatable) Provides a label and summary information for the device.
        :param pulumi.Input[str] mac_address: (Updatable) Mac address of the VM.
        :param pulumi.Input[str] mac_address_type: (Updatable) Mac address type.
        :param pulumi.Input[str] network_name: (Updatable) Network name.
        :param pulumi.Input[str] switch_name: (Updatable) Switch name.
        """
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if mac_address_type is not None:
            pulumi.set(__self__, "mac_address_type", mac_address_type)
        if network_name is not None:
            pulumi.set(__self__, "network_name", network_name)
        if switch_name is not None:
            pulumi.set(__self__, "switch_name", switch_name)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) List of IP addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Provides a label and summary information for the device.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Mac address of the VM.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac_address", value)

    @property
    @pulumi.getter(name="macAddressType")
    def mac_address_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Mac address type.
        """
        return pulumi.get(self, "mac_address_type")

    @mac_address_type.setter
    def mac_address_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac_address_type", value)

    @property
    @pulumi.getter(name="networkName")
    def network_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Network name.
        """
        return pulumi.get(self, "network_name")

    @network_name.setter
    def network_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_name", value)

    @property
    @pulumi.getter(name="switchName")
    def switch_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Switch name.
        """
        return pulumi.get(self, "switch_name")

    @switch_name.setter
    def switch_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "switch_name", value)


if not MYPY:
    class AssetComputeNvdimmArgsDict(TypedDict):
        controller_key: NotRequired[pulumi.Input[int]]
        """
        (Updatable) Controller key.
        """
        label: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Provides a label and summary information for the device.
        """
        unit_number: NotRequired[pulumi.Input[int]]
        """
        (Updatable) The unit number of NVDIMM.
        """
elif False:
    AssetComputeNvdimmArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssetComputeNvdimmArgs:
    def __init__(__self__, *,
                 controller_key: Optional[pulumi.Input[int]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 unit_number: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] controller_key: (Updatable) Controller key.
        :param pulumi.Input[str] label: (Updatable) Provides a label and summary information for the device.
        :param pulumi.Input[int] unit_number: (Updatable) The unit number of NVDIMM.
        """
        if controller_key is not None:
            pulumi.set(__self__, "controller_key", controller_key)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if unit_number is not None:
            pulumi.set(__self__, "unit_number", unit_number)

    @property
    @pulumi.getter(name="controllerKey")
    def controller_key(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Controller key.
        """
        return pulumi.get(self, "controller_key")

    @controller_key.setter
    def controller_key(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "controller_key", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Provides a label and summary information for the device.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="unitNumber")
    def unit_number(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The unit number of NVDIMM.
        """
        return pulumi.get(self, "unit_number")

    @unit_number.setter
    def unit_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "unit_number", value)


if not MYPY:
    class AssetComputeNvdimmControllerArgsDict(TypedDict):
        bus_number: NotRequired[pulumi.Input[int]]
        """
        (Updatable) Bus number.
        """
        label: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Provides a label and summary information for the device.
        """
elif False:
    AssetComputeNvdimmControllerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssetComputeNvdimmControllerArgs:
    def __init__(__self__, *,
                 bus_number: Optional[pulumi.Input[int]] = None,
                 label: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] bus_number: (Updatable) Bus number.
        :param pulumi.Input[str] label: (Updatable) Provides a label and summary information for the device.
        """
        if bus_number is not None:
            pulumi.set(__self__, "bus_number", bus_number)
        if label is not None:
            pulumi.set(__self__, "label", label)

    @property
    @pulumi.getter(name="busNumber")
    def bus_number(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Bus number.
        """
        return pulumi.get(self, "bus_number")

    @bus_number.setter
    def bus_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bus_number", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Provides a label and summary information for the device.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)


if not MYPY:
    class AssetComputeScsiControllerArgsDict(TypedDict):
        label: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Provides a label and summary information for the device.
        """
        shared_bus: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Shared bus.
        """
        unit_number: NotRequired[pulumi.Input[int]]
        """
        (Updatable) The unit number of the SCSI controller.
        """
elif False:
    AssetComputeScsiControllerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssetComputeScsiControllerArgs:
    def __init__(__self__, *,
                 label: Optional[pulumi.Input[str]] = None,
                 shared_bus: Optional[pulumi.Input[str]] = None,
                 unit_number: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] label: (Updatable) Provides a label and summary information for the device.
        :param pulumi.Input[str] shared_bus: (Updatable) Shared bus.
        :param pulumi.Input[int] unit_number: (Updatable) The unit number of the SCSI controller.
        """
        if label is not None:
            pulumi.set(__self__, "label", label)
        if shared_bus is not None:
            pulumi.set(__self__, "shared_bus", shared_bus)
        if unit_number is not None:
            pulumi.set(__self__, "unit_number", unit_number)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Provides a label and summary information for the device.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="sharedBus")
    def shared_bus(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Shared bus.
        """
        return pulumi.get(self, "shared_bus")

    @shared_bus.setter
    def shared_bus(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_bus", value)

    @property
    @pulumi.getter(name="unitNumber")
    def unit_number(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The unit number of the SCSI controller.
        """
        return pulumi.get(self, "unit_number")

    @unit_number.setter
    def unit_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "unit_number", value)


if not MYPY:
    class AssetSourceDiscoveryCredentialsArgsDict(TypedDict):
        secret_id: pulumi.Input[str]
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret in a vault. If the the type of the credentials is BASIC`, the secret must contain the username and password in JSON format, which is in the form of `{ "username": "<VMwareUser>", "password": "<VMwarePassword>" }`.
        """
        type: pulumi.Input[str]
        """
        (Updatable) Authentication type
        """
elif False:
    AssetSourceDiscoveryCredentialsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssetSourceDiscoveryCredentialsArgs:
    def __init__(__self__, *,
                 secret_id: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] secret_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret in a vault. If the the type of the credentials is BASIC`, the secret must contain the username and password in JSON format, which is in the form of `{ "username": "<VMwareUser>", "password": "<VMwarePassword>" }`.
        :param pulumi.Input[str] type: (Updatable) Authentication type
        """
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret in a vault. If the the type of the credentials is BASIC`, the secret must contain the username and password in JSON format, which is in the form of `{ "username": "<VMwareUser>", "password": "<VMwarePassword>" }`.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) Authentication type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class AssetSourceReplicationCredentialsArgsDict(TypedDict):
        secret_id: pulumi.Input[str]
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret in a vault. If the the type of the credentials is BASIC`, the secret must contain the username and password in JSON format, which is in the form of `{ "username": "<VMwareUser>", "password": "<VMwarePassword>" }`.
        """
        type: pulumi.Input[str]
        """
        (Updatable) Authentication type
        """
elif False:
    AssetSourceReplicationCredentialsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssetSourceReplicationCredentialsArgs:
    def __init__(__self__, *,
                 secret_id: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] secret_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret in a vault. If the the type of the credentials is BASIC`, the secret must contain the username and password in JSON format, which is in the form of `{ "username": "<VMwareUser>", "password": "<VMwarePassword>" }`.
        :param pulumi.Input[str] type: (Updatable) Authentication type
        """
        pulumi.set(__self__, "secret_id", secret_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret in a vault. If the the type of the credentials is BASIC`, the secret must contain the username and password in JSON format, which is in the form of `{ "username": "<VMwareUser>", "password": "<VMwarePassword>" }`.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) Authentication type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class AssetVmArgsDict(TypedDict):
        hypervisor_host: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Host name/IP address of VM on which the host is running.
        """
        hypervisor_vendor: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Hypervisor vendor.
        """
        hypervisor_version: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Hypervisor version.
        """
elif False:
    AssetVmArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssetVmArgs:
    def __init__(__self__, *,
                 hypervisor_host: Optional[pulumi.Input[str]] = None,
                 hypervisor_vendor: Optional[pulumi.Input[str]] = None,
                 hypervisor_version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] hypervisor_host: (Updatable) Host name/IP address of VM on which the host is running.
        :param pulumi.Input[str] hypervisor_vendor: (Updatable) Hypervisor vendor.
        :param pulumi.Input[str] hypervisor_version: (Updatable) Hypervisor version.
        """
        if hypervisor_host is not None:
            pulumi.set(__self__, "hypervisor_host", hypervisor_host)
        if hypervisor_vendor is not None:
            pulumi.set(__self__, "hypervisor_vendor", hypervisor_vendor)
        if hypervisor_version is not None:
            pulumi.set(__self__, "hypervisor_version", hypervisor_version)

    @property
    @pulumi.getter(name="hypervisorHost")
    def hypervisor_host(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Host name/IP address of VM on which the host is running.
        """
        return pulumi.get(self, "hypervisor_host")

    @hypervisor_host.setter
    def hypervisor_host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hypervisor_host", value)

    @property
    @pulumi.getter(name="hypervisorVendor")
    def hypervisor_vendor(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Hypervisor vendor.
        """
        return pulumi.get(self, "hypervisor_vendor")

    @hypervisor_vendor.setter
    def hypervisor_vendor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hypervisor_vendor", value)

    @property
    @pulumi.getter(name="hypervisorVersion")
    def hypervisor_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Hypervisor version.
        """
        return pulumi.get(self, "hypervisor_version")

    @hypervisor_version.setter
    def hypervisor_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hypervisor_version", value)


if not MYPY:
    class AssetVmwareVcenterArgsDict(TypedDict):
        data_center: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Data center name.
        """
        vcenter_key: NotRequired[pulumi.Input[str]]
        """
        (Updatable) vCenter unique key.
        """
        vcenter_version: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Dot-separated version string.
        """
elif False:
    AssetVmwareVcenterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssetVmwareVcenterArgs:
    def __init__(__self__, *,
                 data_center: Optional[pulumi.Input[str]] = None,
                 vcenter_key: Optional[pulumi.Input[str]] = None,
                 vcenter_version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] data_center: (Updatable) Data center name.
        :param pulumi.Input[str] vcenter_key: (Updatable) vCenter unique key.
        :param pulumi.Input[str] vcenter_version: (Updatable) Dot-separated version string.
        """
        if data_center is not None:
            pulumi.set(__self__, "data_center", data_center)
        if vcenter_key is not None:
            pulumi.set(__self__, "vcenter_key", vcenter_key)
        if vcenter_version is not None:
            pulumi.set(__self__, "vcenter_version", vcenter_version)

    @property
    @pulumi.getter(name="dataCenter")
    def data_center(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Data center name.
        """
        return pulumi.get(self, "data_center")

    @data_center.setter
    def data_center(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_center", value)

    @property
    @pulumi.getter(name="vcenterKey")
    def vcenter_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) vCenter unique key.
        """
        return pulumi.get(self, "vcenter_key")

    @vcenter_key.setter
    def vcenter_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vcenter_key", value)

    @property
    @pulumi.getter(name="vcenterVersion")
    def vcenter_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Dot-separated version string.
        """
        return pulumi.get(self, "vcenter_version")

    @vcenter_version.setter
    def vcenter_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vcenter_version", value)


if not MYPY:
    class AssetVmwareVmArgsDict(TypedDict):
        cluster: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Cluster name.
        """
        customer_fields: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        (Updatable) Customer fields.
        """
        customer_tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['AssetVmwareVmCustomerTagArgsDict']]]]
        """
        (Updatable) Customer defined tags.
        """
        fault_tolerance_bandwidth: NotRequired[pulumi.Input[int]]
        """
        (Updatable) Fault tolerance bandwidth.
        """
        fault_tolerance_secondary_latency: NotRequired[pulumi.Input[int]]
        """
        (Updatable) Fault tolerance to secondary latency.
        """
        fault_tolerance_state: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Fault tolerance state.
        """
        instance_uuid: NotRequired[pulumi.Input[str]]
        """
        (Updatable) vCenter-specific identifier of the virtual machine.
        """
        is_disks_cbt_enabled: NotRequired[pulumi.Input[bool]]
        """
        (Updatable) Indicates that change tracking is supported for virtual disks of this virtual machine. However, even if change tracking is supported, it might not be available for all disks of the virtual machine.
        """
        is_disks_uuid_enabled: NotRequired[pulumi.Input[bool]]
        """
        (Updatable) Whether changed block tracking for this VM's disk is active.
        """
        path: NotRequired[pulumi.Input[str]]
        """
        (Updatable) Path directory of the asset.
        """
        vmware_tools_status: NotRequired[pulumi.Input[str]]
        """
        (Updatable) VMware tools status.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
elif False:
    AssetVmwareVmArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssetVmwareVmArgs:
    def __init__(__self__, *,
                 cluster: Optional[pulumi.Input[str]] = None,
                 customer_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 customer_tags: Optional[pulumi.Input[Sequence[pulumi.Input['AssetVmwareVmCustomerTagArgs']]]] = None,
                 fault_tolerance_bandwidth: Optional[pulumi.Input[int]] = None,
                 fault_tolerance_secondary_latency: Optional[pulumi.Input[int]] = None,
                 fault_tolerance_state: Optional[pulumi.Input[str]] = None,
                 instance_uuid: Optional[pulumi.Input[str]] = None,
                 is_disks_cbt_enabled: Optional[pulumi.Input[bool]] = None,
                 is_disks_uuid_enabled: Optional[pulumi.Input[bool]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 vmware_tools_status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cluster: (Updatable) Cluster name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] customer_fields: (Updatable) Customer fields.
        :param pulumi.Input[Sequence[pulumi.Input['AssetVmwareVmCustomerTagArgs']]] customer_tags: (Updatable) Customer defined tags.
        :param pulumi.Input[int] fault_tolerance_bandwidth: (Updatable) Fault tolerance bandwidth.
        :param pulumi.Input[int] fault_tolerance_secondary_latency: (Updatable) Fault tolerance to secondary latency.
        :param pulumi.Input[str] fault_tolerance_state: (Updatable) Fault tolerance state.
        :param pulumi.Input[str] instance_uuid: (Updatable) vCenter-specific identifier of the virtual machine.
        :param pulumi.Input[bool] is_disks_cbt_enabled: (Updatable) Indicates that change tracking is supported for virtual disks of this virtual machine. However, even if change tracking is supported, it might not be available for all disks of the virtual machine.
        :param pulumi.Input[bool] is_disks_uuid_enabled: (Updatable) Whether changed block tracking for this VM's disk is active.
        :param pulumi.Input[str] path: (Updatable) Path directory of the asset.
        :param pulumi.Input[str] vmware_tools_status: (Updatable) VMware tools status.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if customer_fields is not None:
            pulumi.set(__self__, "customer_fields", customer_fields)
        if customer_tags is not None:
            pulumi.set(__self__, "customer_tags", customer_tags)
        if fault_tolerance_bandwidth is not None:
            pulumi.set(__self__, "fault_tolerance_bandwidth", fault_tolerance_bandwidth)
        if fault_tolerance_secondary_latency is not None:
            pulumi.set(__self__, "fault_tolerance_secondary_latency", fault_tolerance_secondary_latency)
        if fault_tolerance_state is not None:
            pulumi.set(__self__, "fault_tolerance_state", fault_tolerance_state)
        if instance_uuid is not None:
            pulumi.set(__self__, "instance_uuid", instance_uuid)
        if is_disks_cbt_enabled is not None:
            pulumi.set(__self__, "is_disks_cbt_enabled", is_disks_cbt_enabled)
        if is_disks_uuid_enabled is not None:
            pulumi.set(__self__, "is_disks_uuid_enabled", is_disks_uuid_enabled)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if vmware_tools_status is not None:
            pulumi.set(__self__, "vmware_tools_status", vmware_tools_status)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Cluster name.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter(name="customerFields")
    def customer_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Customer fields.
        """
        return pulumi.get(self, "customer_fields")

    @customer_fields.setter
    def customer_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "customer_fields", value)

    @property
    @pulumi.getter(name="customerTags")
    def customer_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AssetVmwareVmCustomerTagArgs']]]]:
        """
        (Updatable) Customer defined tags.
        """
        return pulumi.get(self, "customer_tags")

    @customer_tags.setter
    def customer_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AssetVmwareVmCustomerTagArgs']]]]):
        pulumi.set(self, "customer_tags", value)

    @property
    @pulumi.getter(name="faultToleranceBandwidth")
    def fault_tolerance_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Fault tolerance bandwidth.
        """
        return pulumi.get(self, "fault_tolerance_bandwidth")

    @fault_tolerance_bandwidth.setter
    def fault_tolerance_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fault_tolerance_bandwidth", value)

    @property
    @pulumi.getter(name="faultToleranceSecondaryLatency")
    def fault_tolerance_secondary_latency(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Fault tolerance to secondary latency.
        """
        return pulumi.get(self, "fault_tolerance_secondary_latency")

    @fault_tolerance_secondary_latency.setter
    def fault_tolerance_secondary_latency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "fault_tolerance_secondary_latency", value)

    @property
    @pulumi.getter(name="faultToleranceState")
    def fault_tolerance_state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Fault tolerance state.
        """
        return pulumi.get(self, "fault_tolerance_state")

    @fault_tolerance_state.setter
    def fault_tolerance_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fault_tolerance_state", value)

    @property
    @pulumi.getter(name="instanceUuid")
    def instance_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) vCenter-specific identifier of the virtual machine.
        """
        return pulumi.get(self, "instance_uuid")

    @instance_uuid.setter
    def instance_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_uuid", value)

    @property
    @pulumi.getter(name="isDisksCbtEnabled")
    def is_disks_cbt_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Indicates that change tracking is supported for virtual disks of this virtual machine. However, even if change tracking is supported, it might not be available for all disks of the virtual machine.
        """
        return pulumi.get(self, "is_disks_cbt_enabled")

    @is_disks_cbt_enabled.setter
    def is_disks_cbt_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_disks_cbt_enabled", value)

    @property
    @pulumi.getter(name="isDisksUuidEnabled")
    def is_disks_uuid_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether changed block tracking for this VM's disk is active.
        """
        return pulumi.get(self, "is_disks_uuid_enabled")

    @is_disks_uuid_enabled.setter
    def is_disks_uuid_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_disks_uuid_enabled", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Path directory of the asset.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="vmwareToolsStatus")
    def vmware_tools_status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) VMware tools status.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vmware_tools_status")

    @vmware_tools_status.setter
    def vmware_tools_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vmware_tools_status", value)


if not MYPY:
    class AssetVmwareVmCustomerTagArgsDict(TypedDict):
        description: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The tag description.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        (Updatable) The tag name.
        """
elif False:
    AssetVmwareVmCustomerTagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssetVmwareVmCustomerTagArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: (Updatable) The tag description.
        :param pulumi.Input[str] name: (Updatable) The tag name.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The tag description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The tag name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class GetAgentDependenciesFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetAgentDependenciesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetAgentDependenciesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetAgentsFilterArgsDict(TypedDict):
        name: str
        """
        Plugin identifier, which can be renamed.
        """
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetAgentsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetAgentsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Plugin identifier, which can be renamed.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Plugin identifier, which can be renamed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetApplianceImagesFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetApplianceImagesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetApplianceImagesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetAssetSourcesFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetAssetSourcesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetAssetSourcesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetAssetsFilterArgsDict(TypedDict):
        name: str
        """
        The tag name.
        """
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetAssetsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetAssetsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The tag name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The tag name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetDiscoverySchedulesFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetDiscoverySchedulesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetDiscoverySchedulesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetEnvironmentsFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetEnvironmentsFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetEnvironmentsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


if not MYPY:
    class GetInventoriesFilterArgsDict(TypedDict):
        name: str
        values: Sequence[str]
        regex: NotRequired[bool]
elif False:
    GetInventoriesFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GetInventoriesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


