# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFastLaunchJobConfigsResult',
    'AwaitableGetFastLaunchJobConfigsResult',
    'get_fast_launch_job_configs',
    'get_fast_launch_job_configs_output',
]

@pulumi.output_type
class GetFastLaunchJobConfigsResult:
    """
    A collection of values returned by getFastLaunchJobConfigs.
    """
    def __init__(__self__, compartment_id=None, fast_launch_job_configs=None, filters=None, id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if fast_launch_job_configs and not isinstance(fast_launch_job_configs, list):
            raise TypeError("Expected argument 'fast_launch_job_configs' to be a list")
        pulumi.set(__self__, "fast_launch_job_configs", fast_launch_job_configs)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="fastLaunchJobConfigs")
    def fast_launch_job_configs(self) -> Sequence['outputs.GetFastLaunchJobConfigsFastLaunchJobConfigResult']:
        """
        The list of fast_launch_job_configs.
        """
        return pulumi.get(self, "fast_launch_job_configs")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFastLaunchJobConfigsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetFastLaunchJobConfigsResult(GetFastLaunchJobConfigsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFastLaunchJobConfigsResult(
            compartment_id=self.compartment_id,
            fast_launch_job_configs=self.fast_launch_job_configs,
            filters=self.filters,
            id=self.id)


def get_fast_launch_job_configs(compartment_id: Optional[str] = None,
                                filters: Optional[Sequence[Union['GetFastLaunchJobConfigsFilterArgs', 'GetFastLaunchJobConfigsFilterArgsDict']]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFastLaunchJobConfigsResult:
    """
    This data source provides the list of Fast Launch Job Configs in Oracle Cloud Infrastructure Data Science service.

    List fast launch capable job configs in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fast_launch_job_configs = oci.DataScience.get_fast_launch_job_configs(compartment_id=compartment_id)
    ```


    :param str compartment_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataScience/getFastLaunchJobConfigs:getFastLaunchJobConfigs', __args__, opts=opts, typ=GetFastLaunchJobConfigsResult).value

    return AwaitableGetFastLaunchJobConfigsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        fast_launch_job_configs=pulumi.get(__ret__, 'fast_launch_job_configs'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_fast_launch_job_configs_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFastLaunchJobConfigsFilterArgs', 'GetFastLaunchJobConfigsFilterArgsDict']]]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFastLaunchJobConfigsResult]:
    """
    This data source provides the list of Fast Launch Job Configs in Oracle Cloud Infrastructure Data Science service.

    List fast launch capable job configs in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fast_launch_job_configs = oci.DataScience.get_fast_launch_job_configs(compartment_id=compartment_id)
    ```


    :param str compartment_id: <b>Filter</b> results by the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataScience/getFastLaunchJobConfigs:getFastLaunchJobConfigs', __args__, opts=opts, typ=GetFastLaunchJobConfigsResult)
    return __ret__.apply(lambda __response__: GetFastLaunchJobConfigsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        fast_launch_job_configs=pulumi.get(__response__, 'fast_launch_job_configs'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
