# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetMessageResult',
    'AwaitableGetMessageResult',
    'get_message',
    'get_message_output',
]

@pulumi.output_type
class GetMessageResult:
    """
    A collection of values returned by getMessage.
    """
    def __init__(__self__, deployment_id=None, id=None, items=None):
        if deployment_id and not isinstance(deployment_id, str):
            raise TypeError("Expected argument 'deployment_id' to be a str")
        pulumi.set(__self__, "deployment_id", deployment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> str:
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetMessageItemResult']:
        """
        An array of DeploymentMessages.
        """
        return pulumi.get(self, "items")


class AwaitableGetMessageResult(GetMessageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMessageResult(
            deployment_id=self.deployment_id,
            id=self.id,
            items=self.items)


def get_message(deployment_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMessageResult:
    """
    This data source provides details about a specific Message resource in Oracle Cloud Infrastructure Golden Gate service.

    Lists the DeploymentMessages for a deployment. The sorting order is not important. By default first will be Upgrade message, next Exception message and then Storage Utilization message.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_message = oci.GoldenGate.get_message(deployment_id=test_deployment["id"])
    ```


    :param str deployment_id: A unique Deployment identifier.
    """
    __args__ = dict()
    __args__['deploymentId'] = deployment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getMessage:getMessage', __args__, opts=opts, typ=GetMessageResult).value

    return AwaitableGetMessageResult(
        deployment_id=pulumi.get(__ret__, 'deployment_id'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'))
def get_message_output(deployment_id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMessageResult]:
    """
    This data source provides details about a specific Message resource in Oracle Cloud Infrastructure Golden Gate service.

    Lists the DeploymentMessages for a deployment. The sorting order is not important. By default first will be Upgrade message, next Exception message and then Storage Utilization message.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_message = oci.GoldenGate.get_message(deployment_id=test_deployment["id"])
    ```


    :param str deployment_id: A unique Deployment identifier.
    """
    __args__ = dict()
    __args__['deploymentId'] = deployment_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:GoldenGate/getMessage:getMessage', __args__, opts=opts, typ=GetMessageResult)
    return __ret__.apply(lambda __response__: GetMessageResult(
        deployment_id=pulumi.get(__response__, 'deployment_id'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items')))
