# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSenderResult',
    'AwaitableGetSenderResult',
    'get_sender',
    'get_sender_output',
]

@pulumi.output_type
class GetSenderResult:
    """
    A collection of values returned by getSender.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, email_address=None, email_domain_id=None, freeform_tags=None, id=None, is_spf=None, sender_id=None, state=None, system_tags=None, time_created=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if email_address and not isinstance(email_address, str):
            raise TypeError("Expected argument 'email_address' to be a str")
        pulumi.set(__self__, "email_address", email_address)
        if email_domain_id and not isinstance(email_domain_id, str):
            raise TypeError("Expected argument 'email_domain_id' to be a str")
        pulumi.set(__self__, "email_domain_id", email_domain_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_spf and not isinstance(is_spf, bool):
            raise TypeError("Expected argument 'is_spf' to be a bool")
        pulumi.set(__self__, "is_spf", is_spf)
        if sender_id and not isinstance(sender_id, str):
            raise TypeError("Expected argument 'sender_id' to be a str")
        pulumi.set(__self__, "sender_id", sender_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID for the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> str:
        """
        The email address of the sender.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="emailDomainId")
    def email_domain_id(self) -> str:
        """
        The email domain used to assert responsibility for emails sent from this sender.
        """
        return pulumi.get(self, "email_domain_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique OCID of the sender.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isSpf")
    def is_spf(self) -> bool:
        """
        Value of the SPF field. For more information about SPF, please see [SPF Authentication](https://docs.cloud.oracle.com/iaas/Content/Email/Concepts/overview.htm#components).
        """
        return pulumi.get(self, "is_spf")

    @property
    @pulumi.getter(name="senderId")
    def sender_id(self) -> str:
        return pulumi.get(self, "sender_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current status of the approved sender.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the approved sender was added in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")


class AwaitableGetSenderResult(GetSenderResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSenderResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            email_address=self.email_address,
            email_domain_id=self.email_domain_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_spf=self.is_spf,
            sender_id=self.sender_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created)


def get_sender(sender_id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSenderResult:
    """
    This data source provides details about a specific Sender resource in Oracle Cloud Infrastructure Email service.

    Gets an approved sender for a given `senderId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sender = oci.Email.get_sender(sender_id=test_sender_oci_email_sender["id"])
    ```


    :param str sender_id: The unique OCID of the sender.
    """
    __args__ = dict()
    __args__['senderId'] = sender_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Email/getSender:getSender', __args__, opts=opts, typ=GetSenderResult).value

    return AwaitableGetSenderResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        email_address=pulumi.get(__ret__, 'email_address'),
        email_domain_id=pulumi.get(__ret__, 'email_domain_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_spf=pulumi.get(__ret__, 'is_spf'),
        sender_id=pulumi.get(__ret__, 'sender_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'))
def get_sender_output(sender_id: Optional[pulumi.Input[str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSenderResult]:
    """
    This data source provides details about a specific Sender resource in Oracle Cloud Infrastructure Email service.

    Gets an approved sender for a given `senderId`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sender = oci.Email.get_sender(sender_id=test_sender_oci_email_sender["id"])
    ```


    :param str sender_id: The unique OCID of the sender.
    """
    __args__ = dict()
    __args__['senderId'] = sender_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Email/getSender:getSender', __args__, opts=opts, typ=GetSenderResult)
    return __ret__.apply(lambda __response__: GetSenderResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        email_address=pulumi.get(__response__, 'email_address'),
        email_domain_id=pulumi.get(__response__, 'email_domain_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_spf=pulumi.get(__response__, 'is_spf'),
        sender_id=pulumi.get(__response__, 'sender_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created')))
