# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFleetPropertiesResult',
    'AwaitableGetFleetPropertiesResult',
    'get_fleet_properties',
    'get_fleet_properties_output',
]

@pulumi.output_type
class GetFleetPropertiesResult:
    """
    A collection of values returned by getFleetProperties.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, fleet_id=None, fleet_property_collections=None, id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if fleet_property_collections and not isinstance(fleet_property_collections, list):
            raise TypeError("Expected argument 'fleet_property_collections' to be a list")
        pulumi.set(__self__, "fleet_property_collections", fleet_property_collections)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        Tenancy OCID
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFleetPropertiesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> str:
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter(name="fleetPropertyCollections")
    def fleet_property_collections(self) -> Sequence['outputs.GetFleetPropertiesFleetPropertyCollectionResult']:
        """
        The list of fleet_property_collection.
        """
        return pulumi.get(self, "fleet_property_collections")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The unique id of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the FleetProperty.
        """
        return pulumi.get(self, "state")


class AwaitableGetFleetPropertiesResult(GetFleetPropertiesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetPropertiesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            fleet_id=self.fleet_id,
            fleet_property_collections=self.fleet_property_collections,
            id=self.id,
            state=self.state)


def get_fleet_properties(compartment_id: Optional[str] = None,
                         display_name: Optional[str] = None,
                         filters: Optional[Sequence[Union['GetFleetPropertiesFilterArgs', 'GetFleetPropertiesFilterArgsDict']]] = None,
                         fleet_id: Optional[str] = None,
                         id: Optional[str] = None,
                         state: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetPropertiesResult:
    """
    This data source provides the list of Fleet Properties in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of FleetProperties.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_properties = oci.FleetAppsManagement.get_fleet_properties(fleet_id=test_fleet["id"],
        compartment_id=compartment_id,
        display_name=fleet_property_display_name,
        id=fleet_property_id,
        state=fleet_property_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str fleet_id: unique Fleet identifier
    :param str id: unique FleetProperty identifier
    :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getFleetProperties:getFleetProperties', __args__, opts=opts, typ=GetFleetPropertiesResult).value

    return AwaitableGetFleetPropertiesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        fleet_property_collections=pulumi.get(__ret__, 'fleet_property_collections'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_fleet_properties_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFleetPropertiesFilterArgs', 'GetFleetPropertiesFilterArgsDict']]]]] = None,
                                fleet_id: Optional[pulumi.Input[str]] = None,
                                id: Optional[pulumi.Input[Optional[str]]] = None,
                                state: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFleetPropertiesResult]:
    """
    This data source provides the list of Fleet Properties in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of FleetProperties.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_properties = oci.FleetAppsManagement.get_fleet_properties(fleet_id=test_fleet["id"],
        compartment_id=compartment_id,
        display_name=fleet_property_display_name,
        id=fleet_property_id,
        state=fleet_property_state)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str fleet_id: unique Fleet identifier
    :param str id: unique FleetProperty identifier
    :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getFleetProperties:getFleetProperties', __args__, opts=opts, typ=GetFleetPropertiesResult)
    return __ret__.apply(lambda __response__: GetFleetPropertiesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        fleet_property_collections=pulumi.get(__response__, 'fleet_property_collections'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
