# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAllowedDomainLicenseTypesResult',
    'AwaitableGetAllowedDomainLicenseTypesResult',
    'get_allowed_domain_license_types',
    'get_allowed_domain_license_types_output',
]

@pulumi.output_type
class GetAllowedDomainLicenseTypesResult:
    """
    A collection of values returned by getAllowedDomainLicenseTypes.
    """
    def __init__(__self__, allowed_domain_license_types=None, current_license_type_name=None, filters=None, id=None):
        if allowed_domain_license_types and not isinstance(allowed_domain_license_types, list):
            raise TypeError("Expected argument 'allowed_domain_license_types' to be a list")
        pulumi.set(__self__, "allowed_domain_license_types", allowed_domain_license_types)
        if current_license_type_name and not isinstance(current_license_type_name, str):
            raise TypeError("Expected argument 'current_license_type_name' to be a str")
        pulumi.set(__self__, "current_license_type_name", current_license_type_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="allowedDomainLicenseTypes")
    def allowed_domain_license_types(self) -> Sequence['outputs.GetAllowedDomainLicenseTypesAllowedDomainLicenseTypeResult']:
        """
        The list of allowed_domain_license_types.
        """
        return pulumi.get(self, "allowed_domain_license_types")

    @property
    @pulumi.getter(name="currentLicenseTypeName")
    def current_license_type_name(self) -> Optional[str]:
        return pulumi.get(self, "current_license_type_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAllowedDomainLicenseTypesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetAllowedDomainLicenseTypesResult(GetAllowedDomainLicenseTypesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAllowedDomainLicenseTypesResult(
            allowed_domain_license_types=self.allowed_domain_license_types,
            current_license_type_name=self.current_license_type_name,
            filters=self.filters,
            id=self.id)


def get_allowed_domain_license_types(current_license_type_name: Optional[str] = None,
                                     filters: Optional[Sequence[Union['GetAllowedDomainLicenseTypesFilterArgs', 'GetAllowedDomainLicenseTypesFilterArgsDict']]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAllowedDomainLicenseTypesResult:
    """
    This data source provides the list of Allowed Domain License Types in Oracle Cloud Infrastructure Identity service.

    List the allowed domain license types supported by Oracle Cloud Infrastructure If {@code currentLicenseTypeName} provided, returns allowed license types a domain with the specified license type name can migrate to.
    If {@code name} is provided, it filters and returns resources that match the given license type name.
    Otherwise, returns all valid license types that are currently supported.

    - If license type details are retrieved sucessfully, return 202 ACCEPTED.
    - If any internal error occurs, return 500 INTERNAL SERVER ERROR.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_allowed_domain_license_types = oci.Identity.get_allowed_domain_license_types(current_license_type_name=allowed_domain_license_type_current_license_type_name)
    ```


    :param str current_license_type_name: The domain license type
    """
    __args__ = dict()
    __args__['currentLicenseTypeName'] = current_license_type_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getAllowedDomainLicenseTypes:getAllowedDomainLicenseTypes', __args__, opts=opts, typ=GetAllowedDomainLicenseTypesResult).value

    return AwaitableGetAllowedDomainLicenseTypesResult(
        allowed_domain_license_types=pulumi.get(__ret__, 'allowed_domain_license_types'),
        current_license_type_name=pulumi.get(__ret__, 'current_license_type_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_allowed_domain_license_types_output(current_license_type_name: Optional[pulumi.Input[Optional[str]]] = None,
                                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAllowedDomainLicenseTypesFilterArgs', 'GetAllowedDomainLicenseTypesFilterArgsDict']]]]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAllowedDomainLicenseTypesResult]:
    """
    This data source provides the list of Allowed Domain License Types in Oracle Cloud Infrastructure Identity service.

    List the allowed domain license types supported by Oracle Cloud Infrastructure If {@code currentLicenseTypeName} provided, returns allowed license types a domain with the specified license type name can migrate to.
    If {@code name} is provided, it filters and returns resources that match the given license type name.
    Otherwise, returns all valid license types that are currently supported.

    - If license type details are retrieved sucessfully, return 202 ACCEPTED.
    - If any internal error occurs, return 500 INTERNAL SERVER ERROR.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_allowed_domain_license_types = oci.Identity.get_allowed_domain_license_types(current_license_type_name=allowed_domain_license_type_current_license_type_name)
    ```


    :param str current_license_type_name: The domain license type
    """
    __args__ = dict()
    __args__['currentLicenseTypeName'] = current_license_type_name
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Identity/getAllowedDomainLicenseTypes:getAllowedDomainLicenseTypes', __args__, opts=opts, typ=GetAllowedDomainLicenseTypesResult)
    return __ret__.apply(lambda __response__: GetAllowedDomainLicenseTypesResult(
        allowed_domain_license_types=pulumi.get(__response__, 'allowed_domain_license_types'),
        current_license_type_name=pulumi.get(__response__, 'current_license_type_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
