# Generated by Django 2.0.7 on 2018-08-02 12:55

from django.db import migrations, models
import django.db.models.deletion
import easy_thumbnails.fields
import tango_shared.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('sites', '0002_alter_domain_unique'),
    ]

    operations = [
        migrations.CreateModel(
            name='Gallery',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('overline', models.CharField(blank=True, help_text='A short headline over the main headline.', max_length=200, null=True, verbose_name='Kicker/Overline')),
                ('title', models.CharField(help_text='The title for this content.', max_length=200, verbose_name='Title/Headline')),
                ('subhead', models.CharField(blank=True, help_text='A short extra headline below the main headline.', max_length=200, verbose_name='Subhead/Deck')),
                ('slug', models.SlugField(help_text='Used for URLs and identification.\n        Will auto-fill, but can be edited with caution.\n        ', max_length=200)),
                ('summary', models.TextField(blank=True, help_text="You should summarize the content.\n        It's better for search engines, and for people browsing lists of content.\n        If you don't, a summary will be created. But you should.\n        ", verbose_name='Summary description')),
                ('summary_formatted', models.TextField(blank=True, editable=False, help_text='Stores HTML formatted, sanitized version of summary')),
                ('featured', models.BooleanField(default=False)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('enable_comments', models.BooleanField(default=True)),
                ('last_modified', models.DateTimeField(auto_now=True)),
                ('has_image', models.BooleanField(default=False, editable=False, max_length=200)),
                ('credit', models.CharField(blank=True, max_length=200)),
                ('published', models.BooleanField(default=True)),
                ('sites', models.ManyToManyField(default=[1], to='sites.Site')),
            ],
            options={
                'verbose_name_plural': 'galleries',
            },
        ),
        migrations.CreateModel(
            name='GalleryImage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', easy_thumbnails.fields.ThumbnailerImageField(blank=True, help_text='Size should be a minimum of 720px and no more than 2000px high or wide.', upload_to=tango_shared.models.set_img_path)),
                ('caption', models.CharField(blank=True, max_length=255, null=True)),
                ('byline', models.CharField(blank=True, max_length=200, null=True)),
                ('credit', models.CharField(blank=True, max_length=200, null=True, verbose_name='Credit/source')),
                ('order', models.IntegerField(blank=True, help_text='For manual sorting.', null=True)),
                ('thumb', models.CharField(blank=True, editable=False, max_length=200, null=True)),
                ('is_vertical', models.BooleanField(default=False, editable=False)),
                ('gallery', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='photos.Gallery')),
            ],
            options={
                'ordering': ['order', '-id'],
                'abstract': False,
            },
        ),
    ]
