import setuptools

with open("README.md", "r") as fh:
    long_description = fh.read()

setuptools.setup(
    name="taxontabletools2", # Replace with your own username
    version="2.0.8",
    author="Till-Hendrik Macher",
    author_email="macher@uni-trier.de",
    description="taxontabletools - A comprehensive, platform-independent graphical user interface software to explore and visualise DNA metabarcoding data",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/pypa/taxontabletools2",
    packages=setuptools.find_packages(),
    license = 'MIT',
    install_requires = [
        "altair==5.4.1",
        "attrs==24.2.0",
        "blinker==1.8.2",
        "cachetools==5.5.0",
        "contourpy==1.3.0",
        "cycler==0.12.1",
        "et-xmlfile==1.1.0",
        "fonttools==4.54.1",
        "gitdb==4.0.11",
        "gitpython==3.1.43",
        "jinja2==3.1.4",
        "jsonschema==4.23.0",
        "jsonschema-specifications==2024.10.1",
        "kaleido==0.2.1",
        "kiwisolver==1.4.7",
        "levenshtein==0.26.0",
        "markdown-it-py==3.0.0",
        "markupsafe==3.0.1",
        "matplotlib==3.9.2",
        "matplotlib-venn==1.1.1",
        "mdurl==0.1.2",
        "narwhals==1.9.2",
        "openpyxl==3.1.5",
        "pillow==10.4.0",
        "plotly==5.24.1",
        "protobuf==5.28.2",
        "psutil==6.0.0",
        "pyarrow==17.0.0",
        "pydeck==0.9.1",
        "pymannkendall==1.4.3",
        "pyparsing==3.1.4",
        "python-dateutil==2.9.0.post0",
        "pytz==2024.2",
        "rapidfuzz==3.10.0",
        "referencing==0.35.1",
        "rich==13.9.2",
        "rpds-py==0.20.0",
        "seqconverter==3.3.1",
        "sequencelib==2.22.0",
        "smmap==5.0.1",
        "stqdm==0.0.5",
        "streamlit==1.39.0",
        "tenacity==9.0.0",
        "toml==0.10.2",
        "tornado==6.4.1",
        "tqdm==4.66.5",
        "update-checker==0.18.0",
        "watchdog==4.0.2",
    ],
    include_package_data = True,
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.10',
    entry_points = {
        "console_scripts" : [
            "taxontabletools2 = taxontabletools2.__main__:main",
        ]
    },
)
