# Generated by Django 3.2.13 on 2022-07-12 10:39

from django.db import migrations, models
import django.db.models.deletion
import edc_model.validators.date


class Migration(migrations.Migration):
    dependencies = [
        ("effect_lists", "0009_delete_bloodtests"),
        ("effect_prn", "0007_auto_20220711_1230"),
    ]

    operations = [
        migrations.AlterField(
            model_name="endofstudy",
            name="offschedule_datetime",
            field=models.DateTimeField(
                null=True,
                validators=[edc_model.validators.date.datetime_not_future],
                verbose_name="Date participant was terminated from the study",
            ),
        ),
        migrations.AlterField(
            model_name="endofstudy",
            name="offschedule_reason",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="effect_lists.offstudyreasons",
                verbose_name="Reason participant was terminated from the study",
            ),
        ),
        migrations.AlterField(
            model_name="endofstudy",
            name="transferred_consent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=15,
                verbose_name="If transferred, has the participant provided consent to be followed-up?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalendofstudy",
            name="offschedule_datetime",
            field=models.DateTimeField(
                null=True,
                validators=[edc_model.validators.date.datetime_not_future],
                verbose_name="Date participant was terminated from the study",
            ),
        ),
        migrations.AlterField(
            model_name="historicalendofstudy",
            name="offschedule_reason",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="effect_lists.offstudyreasons",
                verbose_name="Reason participant was terminated from the study",
            ),
        ),
        migrations.AlterField(
            model_name="historicalendofstudy",
            name="transferred_consent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=15,
                verbose_name="If transferred, has the participant provided consent to be followed-up?",
            ),
        ),
    ]
