# Generated by Django 3.2.8 on 2022-02-15 14:25

import django.db.models.deletion
import edc_model.models.fields.duration
import edc_model.models.fields.other_charfield
import edc_vitals.models.fields.blood_pressure
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("edc_action_item", "0028_auto_20210203_0706"),
        ("effect_lists", "0002_bloodtests"),
        ("effect_subject", "0004_auto_20220119_0438"),
    ]

    operations = [
        migrations.RemoveField(
            model_name="neurological",
            name="focal_neurologic_deficits",
        ),
        migrations.RemoveField(
            model_name="neurological",
            name="site",
        ),
        migrations.RemoveField(
            model_name="neurological",
            name="subject_visit",
        ),
        migrations.AlterModelOptions(
            name="followup",
            options={
                "default_permissions": (
                    "add",
                    "change",
                    "delete",
                    "view",
                    "export",
                    "import",
                ),
                "get_latest_by": "modified",
                "ordering": ("-modified", "-created"),
                "verbose_name": "Follow-up",
                "verbose_name_plural": "Follow-up",
            },
        ),
        migrations.AlterModelOptions(
            name="historicalfollowup",
            options={
                "get_latest_by": "history_date",
                "ordering": ("-history_date", "-history_id"),
                "verbose_name": "historical Follow-up",
            },
        ),
        migrations.RemoveField(
            model_name="followup",
            name="crf_status",
        ),
        migrations.RemoveField(
            model_name="followup",
            name="crf_status_comments",
        ),
        migrations.RemoveField(
            model_name="historicalfollowup",
            name="crf_status",
        ),
        migrations.RemoveField(
            model_name="historicalfollowup",
            name="crf_status_comments",
        ),
        migrations.RenameField(
            model_name="historicalsignsandsymptoms",
            old_name="cm_signs_symptoms",
            new_name="any_sx",
        ),
        migrations.RemoveField(
            model_name="historicalsignsandsymptoms",
            name="crf_status",
        ),
        migrations.RemoveField(
            model_name="historicalsignsandsymptoms",
            name="crf_status_comments",
        ),
        migrations.RenameField(
            model_name="signsandsymptoms",
            old_name="cm_signs_symptoms",
            new_name="any_sx",
        ),
        migrations.RemoveField(
            model_name="signsandsymptoms",
            name="crf_status",
        ),
        migrations.RemoveField(
            model_name="signsandsymptoms",
            name="crf_status_comments",
        ),
        migrations.RenameField(
            model_name="signsandsymptoms",
            old_name="signs_and_symptoms",
            new_name="current_sx",
        ),
        migrations.AddField(
            model_name="followup",
            name="action_identifier",
            field=models.CharField(max_length=50, null=True, unique=True),
        ),
        migrations.AddField(
            model_name="followup",
            name="action_item",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_action_item.actionitem",
            ),
        ),
        migrations.AddField(
            model_name="followup",
            name="action_item_reason",
            field=models.TextField(editable=False, null=True),
        ),
        migrations.AddField(
            model_name="followup",
            name="parent_action_identifier",
            field=models.CharField(
                blank=True,
                help_text="action identifier that links to parent reference model instance.",
                max_length=30,
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="followup",
            name="parent_action_item",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="edc_action_item.actionitem",
            ),
        ),
        migrations.AddField(
            model_name="followup",
            name="related_action_identifier",
            field=models.CharField(
                blank=True,
                help_text="action identifier that links to related reference model instance.",
                max_length=30,
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="followup",
            name="related_action_item",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="edc_action_item.actionitem",
            ),
        ),
        migrations.AddField(
            model_name="followup",
            name="tracking_identifier",
            field=models.CharField(max_length=30, null=True, unique=True),
        ),
        migrations.AddField(
            model_name="historicalfollowup",
            name="action_identifier",
            field=models.CharField(db_index=True, max_length=50, null=True),
        ),
        migrations.AddField(
            model_name="historicalfollowup",
            name="action_item",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_action_item.actionitem",
            ),
        ),
        migrations.AddField(
            model_name="historicalfollowup",
            name="action_item_reason",
            field=models.TextField(editable=False, null=True),
        ),
        migrations.AddField(
            model_name="historicalfollowup",
            name="parent_action_identifier",
            field=models.CharField(
                blank=True,
                help_text="action identifier that links to parent reference model instance.",
                max_length=30,
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="historicalfollowup",
            name="parent_action_item",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_action_item.actionitem",
            ),
        ),
        migrations.AddField(
            model_name="historicalfollowup",
            name="related_action_identifier",
            field=models.CharField(
                blank=True,
                help_text="action identifier that links to related reference model instance.",
                max_length=30,
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="historicalfollowup",
            name="related_action_item",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_action_item.actionitem",
            ),
        ),
        migrations.AddField(
            model_name="historicalfollowup",
            name="tracking_identifier",
            field=models.CharField(db_index=True, max_length=30, null=True),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="action_identifier",
            field=models.CharField(db_index=True, max_length=50, null=True),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="action_item",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_action_item.actionitem",
            ),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="action_item_reason",
            field=models.TextField(editable=False, null=True),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="cm_sx",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=15,
                verbose_name="Are any of the signs or symptoms related to cryptococcal meningitis (CM)?",
            ),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="cm_sx_bloods_taken_other",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If other bloods taken, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="cm_sx_lp_done",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If yes, ...",
                max_length=15,
                verbose_name="If the patient has CM signs or symptoms, was an LP done?",
            ),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="cm_sx_patient_admitted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If yes, complete SAE report.",
                max_length=15,
                verbose_name="If the patient has CM signs or symptoms, was the patient admitted?",
            ),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="cn_palsy_left_other",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If other cranial nerve palsy (left), please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="cn_palsy_right_other",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If other cranial nerve palsy (right), please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="current_sx_gte_g3_other",
            field=models.TextField(
                blank=True,
                help_text="If more than one, please separate each with a comma (,).",
                null=True,
                verbose_name="If 'Other sign(s)/symptom(s)' at Grade 3 or above selected, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="current_sx_other",
            field=models.TextField(
                blank=True,
                help_text="If more than one, please separate each with a comma (,).",
                null=True,
                verbose_name="If 'Other sign(s)/symptom(s)' selected, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="focal_neurologic_deficit_other",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If other focal neurologic deficit, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="headache_duration_microseconds",
            field=models.DurationField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="parent_action_identifier",
            field=models.CharField(
                blank=True,
                help_text="action identifier that links to parent reference model instance.",
                max_length=30,
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="parent_action_item",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_action_item.actionitem",
            ),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="related_action_identifier",
            field=models.CharField(
                blank=True,
                help_text="action identifier that links to related reference model instance.",
                max_length=30,
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="related_action_item",
            field=models.ForeignKey(
                blank=True,
                db_constraint=False,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="edc_action_item.actionitem",
            ),
        ),
        migrations.AddField(
            model_name="historicalsignsandsymptoms",
            name="tracking_identifier",
            field=models.CharField(db_index=True, max_length=30, null=True),
        ),
        migrations.AddField(
            model_name="historicalvitalsigns",
            name="dia_blood_pressure",
            field=edc_vitals.models.fields.blood_pressure.DiastolicPressureField(
                blank=True, null=True
            ),
        ),
        migrations.AddField(
            model_name="historicalvitalsigns",
            name="sys_blood_pressure",
            field=edc_vitals.models.fields.blood_pressure.SystolicPressureField(
                blank=True, null=True
            ),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="action_identifier",
            field=models.CharField(max_length=50, null=True, unique=True),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="action_item",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="edc_action_item.actionitem",
            ),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="action_item_reason",
            field=models.TextField(editable=False, null=True),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="cm_sx",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=15,
                verbose_name="Are any of the signs or symptoms related to cryptococcal meningitis (CM)?",
            ),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="cm_sx_bloods_taken",
            field=models.ManyToManyField(
                help_text="If bloods taken, complete relevant blood requisition.</br>",
                to="effect_lists.BloodTests",
                verbose_name="If the patient has CM signs or symptoms, which (if any) of the following bloods were taken?",
            ),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="cm_sx_bloods_taken_other",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If other bloods taken, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="cm_sx_lp_done",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If yes, ...",
                max_length=15,
                verbose_name="If the patient has CM signs or symptoms, was an LP done?",
            ),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="cm_sx_patient_admitted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If yes, complete SAE report.",
                max_length=15,
                verbose_name="If the patient has CM signs or symptoms, was the patient admitted?",
            ),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="cn_palsy_left_other",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If other cranial nerve palsy (left), please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="cn_palsy_right_other",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If other cranial nerve palsy (right), please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="current_sx_gte_g3",
            field=models.ManyToManyField(
                help_text="If yes, complete AE report.</br>",
                related_name="sx_gte_g3",
                to="effect_lists.SiSx",
                verbose_name="For these signs/symptoms, were any Grade 3 or above?",
            ),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="current_sx_gte_g3_other",
            field=models.TextField(
                blank=True,
                help_text="If more than one, please separate each with a comma (,).",
                null=True,
                verbose_name="If 'Other sign(s)/symptom(s)' at Grade 3 or above selected, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="current_sx_other",
            field=models.TextField(
                blank=True,
                help_text="If more than one, please separate each with a comma (,).",
                null=True,
                verbose_name="If 'Other sign(s)/symptom(s)' selected, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="focal_neurologic_deficit_other",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If other focal neurologic deficit, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="headache_duration_microseconds",
            field=models.DurationField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="parent_action_identifier",
            field=models.CharField(
                blank=True,
                help_text="action identifier that links to parent reference model instance.",
                max_length=30,
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="parent_action_item",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="edc_action_item.actionitem",
            ),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="related_action_identifier",
            field=models.CharField(
                blank=True,
                help_text="action identifier that links to related reference model instance.",
                max_length=30,
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="related_action_item",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="edc_action_item.actionitem",
            ),
        ),
        migrations.AddField(
            model_name="signsandsymptoms",
            name="tracking_identifier",
            field=models.CharField(max_length=30, null=True, unique=True),
        ),
        migrations.AddField(
            model_name="vitalsigns",
            name="dia_blood_pressure",
            field=edc_vitals.models.fields.blood_pressure.DiastolicPressureField(
                blank=True, null=True
            ),
        ),
        migrations.AddField(
            model_name="vitalsigns",
            name="sys_blood_pressure",
            field=edc_vitals.models.fields.blood_pressure.SystolicPressureField(
                blank=True, null=True
            ),
        ),
        migrations.AlterField(
            model_name="diagnoses",
            name="patient_admitted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If yes, complete SAE report.",
                max_length=15,
                verbose_name="Has the patient been admitted due to any of these diagnoses?",
            ),
        ),
        migrations.AlterField(
            model_name="diagnoses",
            name="reportable_as_ae",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If yes, complete AE report.",
                max_length=15,
                verbose_name="Are any of these diagnoses Grade 3 or above?",
            ),
        ),
        migrations.AlterField(
            model_name="followup",
            name="adherence_counselling",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                max_length=15,
                verbose_name="Was adherence counselling given?",
            ),
        ),
        migrations.AlterField(
            model_name="followup",
            name="hospitalized",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If yes, complete SAE report.",
                max_length=15,
                verbose_name="Has the patient been hospitalized since the last assessment?",
            ),
        ),
        migrations.AlterField(
            model_name="followup",
            name="survival_status",
            field=models.CharField(
                choices=[
                    ("alive_well", "Alive and well"),
                    ("alive_unwell", "Alive, but unwell"),
                    ("dead", "Deceased"),
                ],
                help_text="If subject 'Alive, but unwell, consider unscheduled visit, or AE report. If subject 'Deceased', submit death report",
                max_length=15,
                verbose_name="What is the patient status?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldiagnoses",
            name="patient_admitted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If yes, complete SAE report.",
                max_length=15,
                verbose_name="Has the patient been admitted due to any of these diagnoses?",
            ),
        ),
        migrations.AlterField(
            model_name="historicaldiagnoses",
            name="reportable_as_ae",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If yes, complete AE report.",
                max_length=15,
                verbose_name="Are any of these diagnoses Grade 3 or above?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalfollowup",
            name="adherence_counselling",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                max_length=15,
                verbose_name="Was adherence counselling given?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalfollowup",
            name="hospitalized",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If yes, complete SAE report.",
                max_length=15,
                verbose_name="Has the patient been hospitalized since the last assessment?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalfollowup",
            name="survival_status",
            field=models.CharField(
                choices=[
                    ("alive_well", "Alive and well"),
                    ("alive_unwell", "Alive, but unwell"),
                    ("dead", "Deceased"),
                ],
                help_text="If subject 'Alive, but unwell, consider unscheduled visit, or AE report. If subject 'Deceased', submit death report",
                max_length=15,
                verbose_name="What is the patient status?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalmentalstatus",
            name="patient_admitted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If yes, complete SAE report.",
                max_length=15,
                verbose_name="Has the patient been admitted due to these symptoms?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalmentalstatus",
            name="reportable_as_ae",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If yes, complete AE report.",
                max_length=15,
                verbose_name="Are any of these symptoms Grade 3 or above?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsignsandsymptoms",
            name="headache_duration",
            field=edc_model.models.fields.duration.DurationDHField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name="historicalsignsandsymptoms",
            name="patient_admitted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If yes, complete SAE report.",
                max_length=15,
                verbose_name="Has the patient been admitted due to any of these signs or symptoms?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsignsandsymptoms",
            name="reportable_as_ae",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If yes, complete AE report.",
                max_length=15,
                verbose_name="Are any of these signs or symptoms Grade 3 or above?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalvitalsigns",
            name="patient_admitted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If yes, complete SAE report.",
                max_length=15,
                verbose_name="Has the patient been admitted due to any of the above?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalvitalsigns",
            name="reportable_as_ae",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If yes, complete AE report.",
                max_length=15,
                verbose_name="Are any of the above reportable as Grade 3 or above?",
            ),
        ),
        migrations.AlterField(
            model_name="mentalstatus",
            name="patient_admitted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If yes, complete SAE report.",
                max_length=15,
                verbose_name="Has the patient been admitted due to these symptoms?",
            ),
        ),
        migrations.AlterField(
            model_name="mentalstatus",
            name="reportable_as_ae",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If yes, complete AE report.",
                max_length=15,
                verbose_name="Are any of these symptoms Grade 3 or above?",
            ),
        ),
        migrations.AlterField(
            model_name="signsandsymptoms",
            name="headache_duration",
            field=edc_model.models.fields.duration.DurationDHField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name="signsandsymptoms",
            name="patient_admitted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If yes, complete SAE report.",
                max_length=15,
                verbose_name="Has the patient been admitted due to any of these signs or symptoms?",
            ),
        ),
        migrations.AlterField(
            model_name="signsandsymptoms",
            name="reportable_as_ae",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="If yes, complete AE report.",
                max_length=15,
                verbose_name="Are any of these signs or symptoms Grade 3 or above?",
            ),
        ),
        migrations.AlterField(
            model_name="vitalsigns",
            name="patient_admitted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If yes, complete SAE report.",
                max_length=15,
                verbose_name="Has the patient been admitted due to any of the above?",
            ),
        ),
        migrations.AlterField(
            model_name="vitalsigns",
            name="reportable_as_ae",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If yes, complete AE report.",
                max_length=15,
                verbose_name="Are any of the above reportable as Grade 3 or above?",
            ),
        ),
        migrations.DeleteModel(
            name="HistoricalNeurological",
        ),
        migrations.DeleteModel(
            name="Neurological",
        ),
    ]
