(function(){RB.ReviewRequestPage={};"use strict";RB.ReviewRequestPage.Entry=Backbone.Model.extend({defaults:{addedTimestamp:null,collapsed:false,page:null,reviewRequestEditor:null,typeID:null,updatedTimestamp:null},parse:function parse(attrs){return{id:attrs.id,collapsed:attrs.collapsed,addedTimestamp:moment.utc(attrs.addedTimestamp).toDate(),updatedTimestamp:moment.utc(attrs.updatedTimestamp).toDate(),typeID:attrs.typeID,reviewRequestEditor:attrs.reviewRequestEditor}},beforeApplyUpdate:function beforeApplyUpdate(entryData){},afterApplyUpdate:function afterApplyUpdate(entryData){},watchUpdates:function watchUpdates(periodMS){this.get("page").watchEntryUpdates(this,periodMS)},stopWatchingUpdates:function stopWatchingUpdates(){this.get("page").stopWatchingEntryUpdates(this)}});"use strict";RB.ReviewRequestPage.ReviewEntry=RB.ReviewRequestPage.Entry.extend({defaults:_.defaults({diffCommentsData:[],review:null},RB.ReviewRequestPage.Entry.prototype.defaults),parse:function parse(attrs){var reviewRequest=attrs.reviewRequestEditor.get("reviewRequest");var reviewData=attrs.reviewData;return _.extend(RB.ReviewRequestPage.Entry.prototype.parse.call(this,attrs),{diffCommentsData:attrs.diffCommentsData,review:reviewRequest.createReview(reviewData.id,{bodyBottom:reviewData.bodyBottom,bodyTop:reviewData.bodyTop,public:reviewData.public,shipIt:reviewData.shipIt})})}});RB.ReviewRequestPage.ReviewReplyEditor=Backbone.Model.extend({defaults:{contextID:null,contextType:null,commentID:null,hasDraft:false,replyObject:null,review:null,reviewReply:null,richText:null,text:""},replyClasses:{diff_comments:RB.DiffCommentReply,screenshot_comments:RB.ScreenshotCommentReply,file_attachment_comments:RB.FileAttachmentCommentReply,general_comments:RB.GeneralCommentReply},initialize:function(){this.on("change:reviewReply",this._setupReviewReply,this);this._setupReviewReply()},save:function(){var contextType=this.get("contextType"),reviewReply=this.get("reviewReply"),valueAttr,richTextAttr,ReplyClass,obj;if(contextType==="body_top"){valueAttr="bodyTop";richTextAttr="bodyTopRichText";obj=reviewReply}else if(contextType==="body_bottom"){valueAttr="bodyBottom";richTextAttr="bodyBottomRichText";obj=reviewReply}else{valueAttr="text";richTextAttr="richText";obj=this.get("replyObject");if(!obj){ReplyClass=this.replyClasses[contextType];console.assert(ReplyClass,"Unexpected context type '%s'",contextType);obj=new ReplyClass({parentObject:reviewReply,replyToID:this.get("contextID"),id:this.get("commentID")})}}this.set("replyObject",obj);this.trigger("saving");obj.ready({ready:function(){var text=this.get("text");if(text){obj.set(valueAttr,text);obj.set(richTextAttr,this.get("richText"));obj.set({forceTextType:"html",includeTextTypes:"raw"});obj.save({attrs:[valueAttr,richTextAttr,"forceTextType","includeTextTypes","replyToID"],success:function(){this.set({hasDraft:true,text:obj.get(valueAttr),richText:true});this.trigger("textUpdated");this.trigger("saved")}},this)}else{this.resetStateIfEmpty()}}},this)},resetStateIfEmpty:function(){var text=this.get("text"),replyObject,contextType;if(text.strip()!==""){return}replyObject=this.get("replyObject");if(!replyObject||replyObject.isNew()){this._resetState()}else{contextType=this.get("contextType");if(contextType==="body_top"||contextType==="body_bottom"){this._resetState(true)}else{replyObject.destroy({success:this._resetState},this)}}},_setupReviewReply:function(){var reviewReply=this.get("reviewReply"),oldReviewReply=this.previous("reviewReply");if(oldReviewReply){oldReviewReply.off(null,null,this)}this.listenTo(reviewReply,"destroyed",function(){this.trigger("discarded");this._resetState()});this.listenTo(reviewReply,"published",function(){this.trigger("published");this._resetState(false)})},_resetState:function(shouldDiscardIfEmpty){this.set({commentID:null,hasDraft:false,replyObject:null});if(shouldDiscardIfEmpty===false){this.trigger("resetState")}else{this.get("reviewReply").discardIfEmpty({success:function(){this.trigger("resetState")}},this)}}});"use strict";RB.ReviewRequestPage.ReviewRequestPage=RB.ReviewablePage.extend({defaults:_.defaults({updatesURL:null},RB.ReviewablePage.prototype.defaults),initialize:function initialize(){RB.ReviewablePage.prototype.initialize.apply(this,arguments);this._watchedEntries={};this._watchedUpdatesPeriodMS=null;this._watchedUpdatesTimeout=null;this._watchedUpdatesLastScheduleTime=null;this.entries=new Backbone.Collection([],{model:RB.ReviewRequestPage.Entry})},parse:function parse(rsp){return _.extend({updatesURL:rsp.updatesURL},RB.ReviewablePage.prototype.parse.call(this,rsp))},addEntry:function addEntry(entry){entry.set("page",this);this.entries.add(entry)},watchEntryUpdates:function watchEntryUpdates(entry,periodMS){if(this._watchedUpdatesPeriodMS===null||periodMS<this._watchedUpdatesPeriodMS){if(this._watchedUpdatesTimeout!==null&&Date.now()-this._watchedUpdatesLastScheduleTime>periodMS){clearTimeout(this._watchedUpdatesTimeout);this._watchedUpdatesTimeout=null}this._watchedUpdatesPeriodMS=periodMS}this._watchedEntries[entry.id]={entry:entry,periodMS:periodMS};this._scheduleCheckUpdates()},stopWatchingEntryUpdates:function stopWatchingEntryUpdates(entry){if(!this._watchedEntries.hasOwnProperty(entry.id)){return}delete this._watchedEntries[entry.id];this._watchedUpdatesPeriodMS=null;if(_.isEmpty(this._watchedEntries)){if(this._watchedUpdatesTimeout!==null){clearTimeout(this._watchedUpdatesTimeout);this._watchedUpdatesTimeout=null}this._watchedUpdatesLastScheduleTime=null}else{for(var key in this._watchedEntries){if(this._watchedEntries.hasOwnProperty(key)){var periodMS=this._watchedEntries[key].periodMS;this._watchedUpdatesPeriodMS=this._watchedUpdatesPeriodMS===null?periodMS:Math.min(this._watchedUpdatesPeriodMS,periodMS)}}}},_scheduleCheckUpdates:function _scheduleCheckUpdates(){var _this=this;if(this._watchedUpdatesTimeout!==null||this._watchedUpdatesPeriodMS===null){return}this._watchedUpdatesLastScheduleTime=Date.now();this._watchedUpdatesTimeout=setTimeout(function(){_this._watchedUpdatesTimeout=null;_this._loadUpdates({entries:_.pluck(_this._watchedEntries,"entry"),onDone:_this._scheduleCheckUpdates.bind(_this)})},this._watchedUpdatesPeriodMS)},_loadUpdates:function _loadUpdates(){var _this2=this;var options=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};var updatesURL=this.get("updatesURL");var allEntryIDs={};var entries=options.entries||[];var urlQuery=[];if(entries.length>0){for(var i=0;i<entries.length;i++){var entry=entries[i];var typeID=entry.get("typeID");if(!allEntryIDs.hasOwnProperty(typeID)){allEntryIDs[typeID]=[]}allEntryIDs[typeID].push(entry.id)}var urlEntryTypeIDs=[];for(var entryTypeID in allEntryIDs){if(allEntryIDs.hasOwnProperty(entryTypeID)){allEntryIDs[entryTypeID].sort(function(a,b){return a-b});var entryIDs=allEntryIDs[entryTypeID].join(",");urlEntryTypeIDs.push(entryTypeID+":"+entryIDs)}}urlQuery.push("entries="+urlEntryTypeIDs.join(";"))}urlQuery.sort();var urlQueryStr=urlQuery.length>0?"?"+urlQuery.join("&"):"";Backbone.sync("read",this,{url:""+updatesURL+urlQueryStr,dataType:"arraybuffer",noActivityIndicator:true,success:function success(arrayBuffer){return _this2._processUpdatesFromPayload(arrayBuffer,options.onDone)}})},_processUpdatesFromPayload:function _processUpdatesFromPayload(arrayBuffer,onDone){var _this3=this;var dataView=new DataView(arrayBuffer);var len=dataView.byteLength;var pos=0;var totalUpdates=0;var totalApplied=0;var done=false;var onUpdateLoaded=function onUpdateLoaded(metadata,html){if(metadata.type==="entry"){_this3._processEntryUpdate(metadata,html)}else{_this3._reloadFromUpdate(null,metadata,html)}totalApplied++;if(done&&totalApplied===totalUpdates){_this3.trigger("updatesProcessed");if(_.isFunction(onDone)){onDone()}}};while(!done){var parsed=this._processUpdateFromPayload(arrayBuffer,dataView,pos);totalUpdates++;pos=parsed.pos;done=pos>=len;parsed.load(onUpdateLoaded)}},_processUpdateFromPayload:function _processUpdateFromPayload(arrayBuffer,dataView,pos){var metadataLen=dataView.getUint32(pos,true);pos+=4;var metadataStart=pos;pos+=metadataLen;var htmlLen=dataView.getUint32(pos,true);pos+=4;var htmlStart=pos;pos+=htmlLen;return{pos:pos,load:function load(cb){var metadataBlob=new Blob([arrayBuffer.slice(metadataStart,metadataStart+metadataLen)]);var htmlBlob=new Blob([arrayBuffer.slice(htmlStart,htmlStart+htmlLen)]);RB.DataUtils.readManyBlobsAsStrings([metadataBlob,htmlBlob],function(metadata,html){return cb(JSON.parse(metadata),html)})}}},_processEntryUpdate:function _processEntryUpdate(metadata,html){var entry=this.entries.get(metadata.entryID);if(!entry){return}console.assert(entry.get("typeID")===metadata.entryType);var newTimestamp=new Date(metadata.updatedTimestamp);if(newTimestamp<=entry.get("updatedTimestamp")){return}this._reloadFromUpdate(entry,metadata,html)},_reloadFromUpdate:function _reloadFromUpdate(model,metadata,html){this.trigger("applyingUpdate:"+metadata.type,metadata,html);if(model){this.trigger("applyingUpdate:"+metadata.type+":"+model.id,metadata,html);if(_.isFunction(model.beforeApplyUpdate)){model.beforeApplyUpdate(metadata)}if(metadata.modelData){model.set(model.parse(_.extend({},model.attributes,metadata.modelData)))}this.trigger("appliedModelUpdate:"+metadata.type+":"+model.id,metadata,html);if(_.isFunction(model.afterApplyUpdate)){model.afterApplyUpdate(metadata)}this.trigger("appliedUpdate:"+metadata.type+":"+model.id,metadata,html)}this.trigger("appliedUpdate:"+metadata.type,metadata,html)}});"use strict";RB.ReviewRequestPage.StatusUpdatesEntry=RB.ReviewRequestPage.Entry.extend({defaults:_.defaults({diffCommentsData:[],pendingStatusUpdates:false,reviews:[]},RB.ReviewRequestPage.Entry.prototype.defaults),parse:function parse(attrs){var reviewRequest=attrs.reviewRequestEditor.get("reviewRequest");var reviewsData=attrs.reviewsData||[];var reviews=reviewsData.map(function(reviewData){return reviewRequest.createReview(reviewData.id,{bodyBottom:reviewData.bodyBottom,bodyTop:reviewData.bodyTop,public:reviewData.public,shipIt:reviewData.shipIt})});return _.extend(RB.ReviewRequestPage.Entry.prototype.parse.call(this,attrs),{diffCommentsData:attrs.diffCommentsData,pendingStatusUpdates:attrs.pendingStatusUpdates,reviews:reviews})}});"use strict";RB.ReviewRequestPage.ChangeEntry=RB.ReviewRequestPage.StatusUpdatesEntry.extend();"use strict";RB.ReviewRequestPage.EntryView=Backbone.View.extend({events:{"click .collapse-button":"_onToggleCollapseClicked"},render:function render(){this._$box=this.$(".review-request-page-entry-contents");this._$expandCollapseButton=this.$(".collapse-button .rb-icon");if(this._$box.hasClass("collapsed")){this._$expandCollapseButton.addClass("rb-icon-expand-review")}else{this._$expandCollapseButton.addClass("rb-icon-collapse-review")}return this},isCollapsed:function isCollapsed(){return this._$box.hasClass("collapsed")},expand:function expand(){this._$box.removeClass("collapsed");this._$expandCollapseButton.removeClass("rb-icon-expand-review").addClass("rb-icon-collapse-review");this.model.set("collapsed",false)},collapse:function collapse(){this._$box.addClass("collapsed");this._$expandCollapseButton.removeClass("rb-icon-collapse-review").addClass("rb-icon-expand-review");this.model.set("collapsed",true)},beforeApplyUpdate:function beforeApplyUpdate(entryData){},afterApplyUpdate:function afterApplyUpdate(entryData){},_onToggleCollapseClicked:function _onToggleCollapseClicked(){if(this.isCollapsed()){this.expand()}else{this.collapse()}}});"use strict";(function(){var ParentView=RB.ReviewRequestPage.EntryView;RB.ReviewRequestPage.BaseStatusUpdatesEntryView=ParentView.extend({CHECK_UPDATES_MS:10*1e3,initialize:function initialize(){ParentView.prototype.initialize.apply(this,arguments);this._reviewViews=null},beforeApplyUpdate:function beforeApplyUpdate(){this.model.stopWatchingUpdates();var diffFragmentQueue=RB.PageManager.getPage().diffFragmentQueue;var diffCommentsData=this.model.get("diffCommentsData")||[];for(var i=0;i<diffCommentsData.length;i++){diffFragmentQueue.saveFragment(diffCommentsData[i][0])}},render:function render(){var _this=this;ParentView.prototype.render.call(this);this._reviewViews=this.model.get("reviews").map(function(review){var $reviewEl=_this.$("#review"+review.id);var view=new RB.ReviewRequestPage.ReviewView({el:$reviewEl,model:review,entryModel:_this.model,$bannerFloatContainer:$reviewEl,$bannerParent:$reviewEl.children(".banners"),bannerNoFloatContainerClass:"collapsed"});view.render();_this.setupReviewView(view);return view});if(this.model.get("pendingStatusUpdates")){this.model.watchUpdates(this.CHECK_UPDATES_MS)}return this},setupReviewView:function setupReviewView(view){}})})();"use strict";(function(){var ParentView=RB.ReviewRequestPage.BaseStatusUpdatesEntryView;RB.ReviewRequestPage.ChangeEntryView=ParentView.extend({initialize:function initialize(options){ParentView.prototype.initialize.apply(this,arguments);var reviewRequestEditor=this.model.get("reviewRequestEditor");this.reviewRequest=reviewRequestEditor.get("reviewRequest");this.reviewRequestEditorView=options.reviewRequestEditorView;this._$boxStatus=null;this._$fixItLabel=null},render:function render(){var _this=this;ParentView.prototype.render.call(this);this._$boxStatus=this.$(".box-status");this._$fixItLabel=$('<label class="fix-it-label">').hide().appendTo(this.$(".labels-container"));RB.formatText(this.$(".changedesc-text"),{bugTrackerURL:this.reviewRequest.get("bugTrackerURL"),isHTMLEncoded:true});this._updateLabels();_.each(this.$(".diff-index tr"),function(rowEl){var $row=$(rowEl);var iconView=new RB.DiffComplexityIconView({numInserts:$row.data("insert-count"),numDeletes:$row.data("delete-count"),numReplaces:$row.data("replace-count"),totalLines:$row.data("total-line-count")});$row.find(".diff-file-icon").empty().append(iconView.$el);iconView.render()});_.each(this.$(".file-container"),function(thumbnailEl){var $thumbnail=$(thumbnailEl);var $caption=$thumbnail.find(".file-caption .edit");var model=_this.reviewRequest.draft.createFileAttachment({id:$thumbnail.data("file-id")});if(!$caption.hasClass("empty-caption")){model.set("caption",$caption.text())}_this.reviewRequestEditorView.buildFileAttachmentThumbnail(model,null,{$el:$thumbnail,canEdit:false})});return this},setupReviewView:function setupReviewView(view){this.listenTo(view,"openIssuesChanged",this._updateLabels)},_updateLabels:function _updateLabels(){if(this._reviewViews.some(function(view){return view.hasOpenIssues()})){var openIssueCount=this._reviewViews.reduce(function(sum,view){return sum+view.getOpenIssueCount()},0);this._$boxStatus.addClass("has-issues");this._$fixItLabel.empty().append($('<span class="open-issue-count">').text(interpolate(gettext("%s failed"),[openIssueCount]))).append(document.createTextNode(gettext("Fix it!"))).show().css({opacity:1,left:0})}else{this._$fixItLabel.css({opacity:0,left:"-100px"});this._$boxStatus.removeClass("has-issues")}}})})();"use strict";RB.ReviewRequestPage.InitialStatusUpdatesEntryView=RB.ReviewRequestPage.BaseStatusUpdatesEntryView.extend();"use strict";RB.ReviewRequestPage.IssueSummaryTableView=Backbone.View.extend({events:{"change #issue-reviewer-filter":"_onReviewerChanged","click .issue-summary-tab":"_onTabChanged","click thead th":"_onHeaderClicked","click .issue":"_onIssueClicked"},stateToSelectorMap:{open:".open",dropped:".dropped",resolved:".resolved",verifying:".verifying-resolved, .verifying-dropped",all:""},statusIconsMap:{open:"rb-icon-issue-open",dropped:"rb-icon-issue-dropped",resolved:"rb-icon-issue-resolved",verifying:"rb-icon-issue-verifying"},COLUMN_DESCRIPTION:1,COLUMN_REVIEWER:2,COLUMN_LAST_UPDATED:3,_noIssuesTemplate:_.template('<tr class="no-issues">\n <td colspan="5"><em><%- text %></em></td>\n</tr>'),initialize:function initialize(){this.statusFilterState=null;this.reviewerFilterState=null;this.reviewerToSelectorMap=null;this._lastWindowWidth=null;this._$window=$(window);this._$currentTab=null;_.bindAll(this,"_onWindowResize")},render:function render(){this._$table=this.$el.find("table");this._$thead=this._$table.find("thead");this._$tbody=this._$table.find("tbody");this._$filters=this.$(".issue-summary-filters");this._$reviewerFilter=this._$filters.find("#issue-reviewer-filter");this._$reviewerHeader=this._$thead.find(".from-header");var hasExistingState=false;if(this.statusFilterState===null){this._$currentTab=this.$(".issue-summary-tab.active");console.assert(this._$currentTab.length===1);this.statusFilterState=this._$currentTab.data("issue-state")}else{this.$(".issue-summary-tab.active").removeClass("active");this._$currentTab=this.$(".issue-summary-tab"+("[data-issue-state="+this.statusFilterState+"]")).addClass("active");hasExistingState=true}this._buildReviewerFilterMap();if(this.reviewerFilterState===null){this.reviewerFilterState=this._$reviewerFilter.val()}else{this._$reviewerFilter.val(this.reviewerFilterState);hasExistingState=true}if(hasExistingState){this._resetFilters();this._applyFilters()}else{this._checkIssues()}this.stopListening(this.model,"issueStatusUpdated");this.listenTo(this.model,"issueStatusUpdated",this._onIssueStatusChanged);this._$window.off("resize",this._onWindowResize);this._$window.on("resize",this._onWindowResize);this._onWindowResize();this.$(".user").user_infobox();this.$("time.timesince").timesince();Djblets.enableRetinaImages(this.$el);return this},_resetFilters:function _resetFilters(){this._$tbody.find(".issue.hidden").removeClass("hidden")},_applyFilters:function _applyFilters(){var sel=this.stateToSelectorMap[this.statusFilterState]+this.reviewerToSelectorMap[this.reviewerFilterState];if(sel){this._$tbody.find(".issue").not(sel).addClass("hidden")}this._checkIssues();this._updateReviewersPos()},_updateReviewersPos:function _updateReviewersPos(){if(this._$reviewerHeader.is(":visible")){this._$filters.css({left:this._$reviewerHeader.offset().left-this._$table.offset().left+this._$reviewerHeader.getExtents("p","l")})}else{this._$filters.css("left","")}},_checkIssues:function _checkIssues(){this._$tbody.find("tr.no-issues").remove();this._$thead.show();if(this._$tbody.find("tr.issue").not(".hidden").length===0){var text=void 0;if(this.reviewerFilterState!=="all"){if(this.statusFilterState==="open"){text=interpolate(gettext("There are no open issues from %s"),[this.reviewerFilterState])}else if(this.statusFilterState==="verifying"){text=interpolate(gettext("There are no issues waiting for verification from %s"),[this.reviewerFilterState])}else if(this.statusFilterState==="dropped"){text=interpolate(gettext("There are no dropped issues from %s"),[this.reviewerFilterState])}else if(this.statusFilterState==="resolved"){text=interpolate(gettext("There are no resolved issues from %s"),[this.reviewerFilterState])}}else{if(this.statusFilterState==="open"){text=gettext("There are no open issues")}else if(this.statusFilterState==="verifying"){text=gettext("There are no issues waiting for verification")}else if(this.statusFilterState==="dropped"){text=gettext("There are no dropped issues")}else if(this.statusFilterState==="resolved"){text=gettext("There are no resolved issues")}}this._$thead.hide();this._$tbody.append(this._noIssuesTemplate({text:text}))}},_sortByCol:function _sortByCol(colIndex,ascending){var _this=this;this._$tbody.html($(".issue").sort(function(issueA,issueB){var $issueA=$(issueA);var $issueB=$(issueB);var $columnA=$issueA.children("td:nth-child("+colIndex+")");var $columnB=$issueB.children("td:nth-child("+colIndex+")");var value1=void 0;var value2=void 0;if(colIndex===_this.COLUMN_LAST_UPDATED){value1=$columnB.children("time").attr("datetime");value2=$columnA.children("time").attr("datetime")}else{value1=$columnA.text().strip().toLowerCase();value2=$columnB.text().strip().toLowerCase()}if(value1===value2){var issueID1=$issueA.data("issue-id");var issueID2=$issueB.data("issue-id");if(ascending){value1=issueID1;value2=issueID2}else{value1=issueID2;value2=issueID1}}var result=void 0;if(value1<value2){result=-1}else if(value1>value2){result=1}else{result=0}if(!ascending){result=-result}return result}))},_buildReviewerFilterMap:function _buildReviewerFilterMap(){var _this2=this;this._$reviewerFilter.children().not('[value="all"]').remove();this.reviewerToSelectorMap={all:""};_.each(this._$tbody.find(".issue"),function(issueEl){var reviewer=$(issueEl).data("reviewer");if(!_.has(_this2.reviewerToSelectorMap,reviewer)){_this2.reviewerToSelectorMap[reviewer]='[data-reviewer="'+reviewer+'"]';_this2._$reviewerFilter.append($("<option>").text(reviewer).val(reviewer))}})},_onIssueStatusChanged:function _onIssueStatusChanged(comment,oldStatus,timestamp){var $entry=$("#summary-table-entry-"+comment.id);var newStatus=comment.get("issueStatus");RB.scrollManager.markForUpdate(this.$el);$entry.removeClass(oldStatus).addClass(newStatus).find(".issue-icon").removeClass(this.statusIconsMap[oldStatus]).addClass(this.statusIconsMap[newStatus]);if(this.statusFilterState!==newStatus&&this.statusFilterState!=="all"){$entry.addClass("hidden")}else{$entry.removeClass("hidden")}var $oldCounter=$("#"+oldStatus+"-counter");var $newCounter=$("#"+newStatus+"-counter");$oldCounter.text(parseInt($oldCounter.text(),10)-1);$newCounter.text(parseInt($newCounter.text(),10)+1);$entry.find(".last-updated time").attr("datetime",new Date(timestamp).toISOString()).text(timestamp).timesince();this._checkIssues();this._updateReviewersPos();RB.scrollManager.markUpdated(this.$el)},_onHeaderClicked:function _onHeaderClicked(evt){evt.stopPropagation();if(this._$tbody.find("tr.issue").not(".hidden").length!==0){this._sortByCol($(evt.target).parent().children().index(evt.target)+1,!evt.shiftKey)}},_onIssueClicked:function _onIssueClicked(evt){if(evt.target.tagName==="A"){return}evt.stopPropagation();var $el=$(evt.currentTarget);this.trigger("issueClicked",{commentType:$el.data("comment-type"),commentID:$el.data("issue-id"),commentURL:$el.data("comment-href")})},_onTabChanged:function _onTabChanged(evt){var $tab=$(evt.currentTarget);this._$currentTab.removeClass("active");this._resetFilters();this.statusFilterState=$tab.data("issue-state");this._applyFilters();$tab.addClass("active");this._$currentTab=$tab},_onReviewerChanged:function _onReviewerChanged(){this._resetFilters();this.reviewerFilterState=this._$reviewerFilter.val();this._applyFilters()},_onWindowResize:function _onWindowResize(){var winWidth=this._$window.width();if(winWidth!==this._lastWindowWidth){this._updateReviewersPos()}this._lastWindowWidth=winWidth}});"use strict";(function(){var ParentView=RB.ReviewRequestPage.EntryView;RB.ReviewRequestPage.ReviewEntryView=ParentView.extend({events:_.defaults({"click .revoke-ship-it":"_revokeShipIt"},ParentView.prototype.events),initialize:function initialize(){ParentView.prototype.initialize.call(this);this._reviewView=null;this._draftBannerShown=false;this._$boxStatus=null;this._$fixItLabel=null;this._$shipItLabel=null},beforeApplyUpdate:function beforeApplyUpdate(){var diffFragmentQueue=RB.PageManager.getPage().diffFragmentQueue;var diffCommentsData=this.model.get("diffCommentsData");for(var i=0;i<diffCommentsData.length;i++){diffFragmentQueue.saveFragment(diffCommentsData[i][0])}},render:function render(){var _this=this;ParentView.prototype.render.call(this);this._reviewView=new RB.ReviewRequestPage.ReviewView({el:this.el,model:this.model.get("review"),entryModel:this.model,$bannerFloatContainer:this._$box,$bannerParent:this.$(".banners"),bannerNoFloatContainerClass:"collapsed"});this._$boxStatus=this.$(".box-status");this._$fixItLabel=this._$boxStatus.find(".fix-it-label");this._$shipItLabel=this._$boxStatus.find(".ship-it-label");this.listenTo(this._reviewView,"hasDraftChanged",function(hasDraft){return _this.$el.toggleClass("has-draft",hasDraft)});this.listenTo(this._reviewView,"openIssuesChanged",this._updateLabels);this._reviewView.render();this._updateLabels();return this},getReviewReplyEditorView:function getReviewReplyEditorView(contextType,contextID){return this._reviewView.getReviewReplyEditorView(contextType,contextID)},_updateLabels:function _updateLabels(){this._updateLabel(this._$fixItLabel,this._reviewView.hasOpenIssues(),"has-issues");this._updateLabel(this._$shipItLabel,this.model.get("review").get("shipIt"),"ship-it")},_updateLabel:function _updateLabel($label,visible,boxClassName){if(visible){this._$boxStatus.addClass(boxClassName);$label.show().css({opacity:1,left:0})}else{$label.css({opacity:0,left:"-100px"});this._$boxStatus.removeClass(boxClassName)}},_revokeShipIt:function _revokeShipIt(){var _this2=this;this._$boxStatus.addClass("revoking-ship-it");var confirmation=RB.ReviewRequestPage.ReviewEntryView.strings.revokeShipItConfirm;if(!confirm(confirmation)){this._clearRevokingShipIt();return}var review=this.model.get("review");review.ready({ready:function ready(){review.set("shipIt",false);review.save({attrs:["shipIt","includeTextTypes"],success:function success(){_this2._updateLabels();setTimeout(function(){return _this2._clearRevokingShipIt()},900)},error:function error(model,xhr){review.set("shipIt",true);_this2._clearRevokingShipIt();alert(xhr.responseJSON.err.msg)}})}})},_clearRevokingShipIt:function _clearRevokingShipIt(){this._$boxStatus.removeClass("revoking-ship-it")}},{strings:{revokeShipItConfirm:gettext("Are you sure you want to revoke this Ship It?\n\nThis cannot be undone.")}})})();RB.ReviewRequestPage.ReviewReplyDraftBannerView=RB.FloatingBannerView.extend({className:"banner",template:_.template(["<h1><%- draftText %></h1>","<p>Be sure to publish when finished.</p>",'<span class="banner-actions">',' <input type="button" value="<%- publishText %>"','        class="publish-button" />',' <input type="button" value="<%- discardText %>"','        class="discard-button" />',"</span>","<% if (showSendEmail) { %>"," <label>",'  <input type="checkbox" class="send-email" checked />',"  <%- sendEmailText %>","</label>","<% } %>"].join("")),events:{"click .publish-button":"_onPublishClicked","click .discard-button":"_onDiscardClicked"},render:function(){var reviewRequestEditor=this.options.reviewRequestEditor;_super(this).render.call(this);this.$el.html(this.template({draftText:gettext("This reply is a draft."),publishText:gettext("Publish"),discardText:gettext("Discard"),sendEmailText:gettext("Send E-Mail"),showSendEmail:reviewRequestEditor.get("showSendEmail")}));this.model.on("saving destroying",function(){this.$("input").prop("disabled",true)},this);this.model.on("saved",function(){this.$("input").prop("disabled",false)},this);this.model.on("publishError",function(errorText){alert(errorText)},this);return this},_onPublishClicked:function(){var $sendEmail=this.$(".send-email");this.model.publish({trivial:$sendEmail.length===1&&!$sendEmail.is(":checked")},this)},_onDiscardClicked:function(){this.model.destroy()}});RB.ReviewRequestPage.ReviewReplyEditorView=Backbone.View.extend({commentTemplate:_.template(['<li <% if (isDraft) { %>class="draft"<% } %>','    <% if (commentID) { %>data-comment-id="<%= commentID %>"<% } %>>',' <div class="comment-author">','  <label for="<%= id %>">','   <div class="avatar-container">','    <img src="<%- avatarURL %>" width="32" height="32" ','         alt="<%- fullName %>" class="avatar"','         srcset="<%- avatarURL %> 1x',"<% if (avatarURL2x) { %>, <%- avatarURL2x %> 2x<% }%>",'         ">',"   </div>",'   <div class="user-reply-info">','    <a href="<%= userPageURL %>" class="user"><%- fullName %></a>',"<% if (timestamp) { %>",'    <span class="timestamp">','     <time class="timesince" datetime="<%= timestampISO %>">',"<%= timestamp %></time>","    </span>","<% } %>","   </div>","  </label>"," </div>"," <div>",'  <pre id="<%= id %>" class="reviewtext"><%- text %></pre>'," </div>","</li>"].join("")),events:{"click .add_comment_link":"_onAddCommentClicked"},initialize:function(){this._$addCommentLink=null;this._$draftComment=null;this._$editor=null;this._$commentsList=null},render:function(){var $draftComment,$reviewText,$time;this._$addCommentLink=this.$(".add_comment_link");this._$commentsList=this.$(".reply-comments");$draftComment=this._$commentsList.children(".draft");if($draftComment.length!==0){$time=$draftComment.find("time");$reviewText=$draftComment.find(".reviewtext");this.model.set({commentID:$draftComment.data("comment-id"),text:$reviewText.html(),timestamp:new Date($time.attr("datetime")),richText:$reviewText.hasClass("rich-text"),hasDraft:true});this._createCommentEditor($draftComment)}this.listenTo(this.model,"textUpdated",function(){var reviewRequest=this.model.get("review").get("parentObject");if(this._$editor){RB.formatText(this._$editor,{newText:this.model.get("text"),richText:this.model.get("richText"),bugTrackerURL:reviewRequest.get("bugTrackerURL")})}});this.model.on("resetState",function(){if(this._$draftComment){this._$draftComment.fadeOut(_.bind(function(){this._$draftComment.remove();this._$draftComment=null},this))}this._$addCommentLink.fadeIn()},this);this.model.on("published",this._onPublished,this)},openCommentEditor:function(){this._createCommentEditor(this._makeCommentElement());this._$editor.inlineEditor("startEdit")},_createCommentEditor:function($draftComment){var reviewRequestEditor=this.options.reviewRequestEditor;this._$draftComment=$draftComment;this._$editor=$draftComment.find("pre.reviewtext");this._$editor.inlineEditor(_.extend({cls:"inline-comment-editor",editIconClass:"rb-icon rb-icon-edit",notifyUnchangedCompletion:true,multiline:true,hasRawValue:true,rawValue:this._$editor.data("raw-value")||""},RB.TextEditorView.getInlineEditorOptions({richText:this._$editor.hasClass("rich-text")}))).removeAttr("data-raw-value").on({beginEdit:function(){if(reviewRequestEditor){reviewRequestEditor.incr("editCount")}},complete:_.bind(function(e,value){var textEditor=RB.TextEditorView.getFromInlineEditor(this._$editor);if(reviewRequestEditor){reviewRequestEditor.decr("editCount")}this.model.set({text:value,richText:textEditor.richText});this.model.save()},this),cancel:_.bind(function(){if(reviewRequestEditor){reviewRequestEditor.decr("editCount")}this.model.resetStateIfEmpty()},this)});this._$addCommentLink.hide()},_makeCommentElement:function(options){var userSession=RB.UserSession.instance,reviewRequest=this.model.get("review").get("parentObject"),urls=userSession.getAvatarURLs(32),now,$el;options=options||{};now=options.now||moment().utcOffset(userSession.get("timezoneOffset"));$el=$(this.commentTemplate(_.extend({id:_.uniqueId("draft_comment_"),text:"",commentID:null,userPageURL:userSession.get("userPageURL"),fullName:userSession.get("fullName"),avatarURL:urls["1x"],avatarURL2x:urls["2x"],isDraft:true,timestampISO:now.format(),timestamp:now.format("MMMM Do, YYYY, h:mm ")+(now.hour()<12?"a.m.":"p.m.")},options))).find(".user").user_infobox().end().find("time.timesince").timesince().end();Djblets.enableRetinaImages($el);if(options.text){RB.formatText($el.find(".reviewtext"),{newText:options.text,richText:options.richText,bugTrackerURL:reviewRequest.get("bugTrackerURL")})}$el.appendTo(this._$commentsList);return $el},_onAddCommentClicked:function(e){e.preventDefault();e.stopPropagation();this.openCommentEditor()},_onPublished:function(){if(this._$draftComment){this._$draftComment.replaceWith(this._makeCommentElement({commentID:this.model.get("commentID"),text:this.model.get("text"),richText:this.model.get("richText"),isDraft:false}));this._$draftComment=null}}});"use strict";(function(){var commentTypeToIDPrefix={diff:"",file:"f",screenshot:"s"};RB.ReviewRequestPage.ReviewRequestPageView=RB.ReviewablePageView.extend({events:_.extend({"click #collapse-all":"_onCollapseAllClicked","click #expand-all":"_onExpandAllClicked"},RB.ReviewablePageView.prototype.events),initialize:function initialize(){var _this=this;RB.ReviewablePageView.prototype.initialize.apply(this,arguments);this._entryViews=[];this._entryViewsByID={};this._rendered=false;this._issueSummaryTableView=null
;var reviewRequest=this.model.get("reviewRequest");this.diffFragmentQueue=new RB.DiffFragmentQueueView({reviewRequestPath:reviewRequest.get("reviewURL"),containerPrefix:"comment_container",queueName:"diff_fragments",el:document.getElementById("content"),diffFragmentViewOptions:{collapsible:true}});this.listenTo(this.model,"updatesProcessed",function(){return _this.diffFragmentQueue.loadFragments()});this.listenTo(this.model,"applyingUpdate:entry",function(metadata,html){var entryID=metadata.entryID;var entryView=_this._entryViewsByID[entryID];var collapsed=entryView.isCollapsed();_this._onApplyingUpdate(entryView,metadata);_this.listenToOnce(_this.model,"appliedModelUpdate:entry:"+entryID,function(metadata,html){return _this._reloadView(entryView,html)});_this.listenToOnce(_this.model,"appliedUpdate:entry:"+entryID,function(metadata){_this._onAppliedUpdate(entryView,metadata);if(collapsed){entryView.collapse()}else{entryView.expand()}})})},render:function render(){var _this2=this;RB.ReviewablePageView.prototype.render.call(this);this._entryViews.forEach(function(entryView){return entryView.render()});this._onHashChanged();if("onhashchange"in window){window.onhashchange=this._onHashChanged.bind(this)}this.diffFragmentQueue.loadFragments();this._issueSummaryTableView=new RB.ReviewRequestPage.IssueSummaryTableView({el:$("#issue-summary"),model:this.model.commentIssueManager});this._issueSummaryTableView.render();this.listenTo(this._issueSummaryTableView,"issueClicked",this._onIssueClicked);this.listenTo(this.model,"appliedUpdate:issue-summary-table",function(metadata,html){_this2._reloadView(_this2._issueSummaryTableView,html)});this._rendered=true;return this},addEntryView:function addEntryView(entryView){var entry=entryView.model;this._entryViews.push(entryView);this._entryViewsByID[entry.id]=entryView;this.model.addEntry(entry);if(this._rendered){entryView.render()}},queueLoadDiff:function queueLoadDiff(commentID,key,onFragmentRendered){this.diffFragmentQueue.queueLoad(commentID,key,onFragmentRendered)},openCommentEditor:function openCommentEditor(contextType,contextID){for(var i=0;i<this._entryViews.length;i++){var entryView=this._entryViews[i];var reviewReplyEditorView=_.isFunction(entryView.getReviewReplyEditorView)?entryView.getReviewReplyEditorView(contextType,contextID):null;if(reviewReplyEditorView){reviewReplyEditorView.openCommentEditor();break}}},_reloadView:function _reloadView(view,html){var $oldEl=view.$el;var $newEl=$(html);view.setElement($newEl);$oldEl.replaceWith($newEl);view.render()},_onApplyingUpdate:function _onApplyingUpdate(view,metadata){if(view&&_.isFunction(view.beforeApplyUpdate)){view.beforeApplyUpdate(metadata)}},_onAppliedUpdate:function _onAppliedUpdate(view,metadata){if(view&&_.isFunction(view.afterApplyUpdate)){view.afterApplyUpdate(metadata)}},_onHashChanged:function _onHashChanged(){var hash=RB.getLocationHash();var selector=null;if(hash!==""){if(hash.includes("comment")){selector="a[name="+hash+"]"}else{selector="#"+hash}}if(!selector){return}for(var i=0;i<this._entryViews.length;i++){var entryView=this._entryViews[i];var $anchor=entryView.$(selector);if($anchor.length>0){entryView.expand();RB.scrollManager.scrollToElement($anchor);break}}},_onCollapseAllClicked:function _onCollapseAllClicked(e){e.preventDefault();e.stopPropagation();this._entryViews.forEach(function(entryView){return entryView.collapse()})},_onExpandAllClicked:function _onExpandAllClicked(e){e.preventDefault();e.stopPropagation();this._entryViews.forEach(function(entryView){return entryView.expand()})},_onIssueClicked:function _onIssueClicked(params){var prefix=commentTypeToIDPrefix[params.commentType];var selector="#"+prefix+"comment"+params.commentID;this._entryViews.forEach(function(entryView){if(entryView.$el.find(selector).length>0){entryView.expand()}});window.location=params.commentURL}})})();"use strict";RB.ReviewRequestPage.ReviewView=Backbone.View.extend({initialize:function initialize(options){var _this=this;this.options=options;this.entryModel=options.entryModel;this._bannerView=null;this._draftBannerShown=false;this._openIssueCount=0;this._reviewReply=null;this._replyEditors=[];this._replyEditorViews=[];this._replyDraftsCount=0;this._diffFragmentViews=[];this._$reviewComments=null;this._$bodyTop=null;this._$bodyBottom=null;this.model.set("includeTextTypes","html,raw,markdown");this._setupNewReply();this.listenTo(this.entryModel,"change:collapsed",function(){if(!_this.entryModel.get("collapsed")){_this._diffFragmentViews.forEach(function(view){return view.hideControls(false)})}})},render:function render(){var _this2=this;var reviewRequestEditor=this.entryModel.get("reviewRequestEditor");this._$reviewComments=this.$(".review-comments");var $comment=this._$reviewComments.find(".review-comment-details .review-comment");this._$bodyTop=$comment.find(".body_top");this._$bodyBottom=$comment.find(".body_bottom");this._replyDraftsCount=0;this.on("hasDraftChanged",function(hasDraft){if(hasDraft){_this2._showReplyDraftBanner()}else{_this2._hideReplyDraftBanner()}});_.each(this._$reviewComments.find(".issue-indicator"),function(el){var $issueState=$(".issue-state",el);if($issueState.length>0){var issueStatus=$issueState.data("issue-status");if(RB.BaseComment.isStateOpen(issueStatus)){_this2._openIssueCount++}var issueBar=new RB.CommentIssueBarView({el:el,reviewID:_this2.model.id,canVerify:$issueState.data("can-verify"),commentID:$issueState.data("comment-id"),commentType:$issueState.data("comment-type"),interactive:$issueState.data("interactive"),issueStatus:issueStatus});issueBar.render();_this2.listenTo(issueBar,"statusChanged",function(oldStatus,newStatus){var oldOpen=RB.BaseComment.isStateOpen(oldStatus);var newOpen=RB.BaseComment.isStateOpen(newStatus);if(oldOpen!==newOpen){if(newOpen){_this2._openIssueCount++}else{_this2._openIssueCount--}}_this2.trigger("openIssuesChanged")})}});_.each(this.$(".comment-section"),function(el){var $el=$(el);var editor=new RB.ReviewRequestPage.ReviewReplyEditor({contextID:$el.data("context-id"),contextType:$el.data("context-type"),review:_this2.model,reviewReply:_this2._reviewReply});var view=new RB.ReviewRequestPage.ReviewReplyEditorView({el:el,model:editor,reviewRequestEditor:reviewRequestEditor});view.render();_this2.listenTo(editor,"change:hasDraft",function(model,hasDraft){if(hasDraft){_this2._replyDraftsCount++;_this2.trigger("hasDraftChanged",true)}else{_this2._replyDraftsCount--;if(_this2._replyDraftsCount===0){_this2.trigger("hasDraftChanged",false)}}});_this2._replyEditors.push(editor);_this2._replyEditorViews.push(view);if(editor.get("hasDraft")){_this2._replyDraftsCount++}});if(this._replyDraftsCount>0){this.trigger("hasDraftChanged",true)}this._diffFragmentViews=[];var page=RB.PageManager.getPage();var diffCommentsData=this.entryModel.get("diffCommentsData");for(var i=0;i<diffCommentsData.length;i++){var diffCommentData=diffCommentsData[i];page.queueLoadDiff(diffCommentData[0],diffCommentData[1],function(view){return _this2._diffFragmentViews.push(view)})}var reviewRequest=this.model.get("parentObject");var bugTrackerURL=reviewRequest.get("bugTrackerURL");_.each(this.$("pre.reviewtext"),function(el){RB.formatText($(el),{bugTrackerURL:bugTrackerURL})});this.listenTo(this.model,"change:bodyTop",this._onBodyTopChanged);this.listenTo(this.model,"change:bodyBottom",this._onBodyBottomChanged);this.listenTo(this.model,"change:bodyTopRichText",this._onBodyTopRichTextChanged);this.listenTo(this.model,"change:bodyBottomRichText",this._onBodyBottomRichTextChanged);return this},_onBodyTopChanged:function _onBodyTopChanged(){this._$bodyTop.html(this.model.get("htmlTextFields").bodyTop)},_onBodyTopRichTextChanged:function _onBodyTopRichTextChanged(){if(this.model.get("bodyTopRichText")){this._$bodyTop.addClass("rich-text")}else{this._$bodyTop.removeClass("rich-text")}},_onBodyBottomChanged:function _onBodyBottomChanged(){var html=this.model.get("htmlTextFields").bodyBottom;this._$bodyBottom.html(html).closest("li").setVisible(html&&html.length>0)},_onBodyBottomRichTextChanged:function _onBodyBottomRichTextChanged(){if(this.model.get("bodyBottomRichText")){this._$bodyBottom.addClass("rich-text")}else{this._$bodyBottom.removeClass("rich-text")}},hasOpenIssues:function hasOpenIssues(){return this._openIssueCount>0},getOpenIssueCount:function getOpenIssueCount(){return this._openIssueCount},getReviewReplyEditorView:function getReviewReplyEditorView(contextType,contextID){if(contextID===undefined){contextID=null}return _.find(this._replyEditorViews,function(view){var editor=view.model;return editor.get("contextID")===contextID&&editor.get("contextType")===contextType})},getReviewReply:function getReviewReply(){return this._reviewReply},_setupNewReply:function _setupNewReply(reviewReply){var _this3=this;if(!reviewReply){reviewReply=this.model.createReply()}if(this._reviewReply!==null){this.stopListening(this._reviewReply);this._replyEditors.forEach(function(editor){return editor.set("reviewReply",reviewReply)});this.trigger("hasDraftChanged",false)}this.listenTo(reviewReply,"destroyed published",function(){return _this3._setupNewReply()});this._reviewReply=reviewReply},_showReplyDraftBanner:function _showReplyDraftBanner(){if(!this._draftBannerShown){this._bannerView=new RB.ReviewRequestPage.ReviewReplyDraftBannerView({model:this._reviewReply,$floatContainer:this.options.$bannerFloatContainer,noFloatContainerClass:this.options.bannerNoFloatContainerClass,reviewRequestEditor:this.entryModel.get("reviewRequestEditor")});this._bannerView.render();this._bannerView.$el.appendTo(this.options.$bannerParent);this._draftBannerShown=true}},_hideReplyDraftBanner:function _hideReplyDraftBanner(){if(this._draftBannerShown){this._bannerView.remove();this._bannerView=null;this._draftBannerShown=false}}})}).call(this);
