"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var RuntimeFamily;
(function (RuntimeFamily) {
    RuntimeFamily[RuntimeFamily["NodeJS"] = 0] = "NodeJS";
    RuntimeFamily[RuntimeFamily["Java"] = 1] = "Java";
    RuntimeFamily[RuntimeFamily["Python"] = 2] = "Python";
    RuntimeFamily[RuntimeFamily["DotNetCore"] = 3] = "DotNetCore";
    RuntimeFamily[RuntimeFamily["Go"] = 4] = "Go";
    RuntimeFamily[RuntimeFamily["Ruby"] = 5] = "Ruby";
    RuntimeFamily[RuntimeFamily["Other"] = 6] = "Other";
})(RuntimeFamily = exports.RuntimeFamily || (exports.RuntimeFamily = {}));
/**
 * Lambda function runtime environment.
 *
 * If you need to use a runtime name that doesn't exist as a static member, you
 * can instantiate a `Runtime` object, e.g: `new Runtime('nodejs99.99')`.
 */
class Runtime {
    constructor(name, family, props = {}) {
        this.name = name;
        this.supportsInlineCode = !!props.supportsInlineCode;
        this.family = family;
        Runtime.All.push(this);
    }
    toString() {
        return this.name;
    }
}
/** A list of all the know ``Runtime``s. */
Runtime.All = new Array();
Runtime.NodeJS = new Runtime('nodejs', RuntimeFamily.NodeJS, { supportsInlineCode: true });
Runtime.NodeJS43 = new Runtime('nodejs4.3', RuntimeFamily.NodeJS, { supportsInlineCode: true });
Runtime.NodeJS610 = new Runtime('nodejs6.10', RuntimeFamily.NodeJS, { supportsInlineCode: true });
Runtime.NodeJS810 = new Runtime('nodejs8.10', RuntimeFamily.NodeJS, { supportsInlineCode: true });
Runtime.Python27 = new Runtime('python2.7', RuntimeFamily.Python, { supportsInlineCode: true });
Runtime.Python36 = new Runtime('python3.6', RuntimeFamily.Python, { supportsInlineCode: true });
Runtime.Python37 = new Runtime('python3.7', RuntimeFamily.Python, { supportsInlineCode: true });
Runtime.Java8 = new Runtime('java8', RuntimeFamily.Java);
Runtime.DotNetCore1 = new Runtime('dotnetcore1.0', RuntimeFamily.DotNetCore);
Runtime.DotNetCore2 = new Runtime('dotnetcore2.0', RuntimeFamily.DotNetCore);
Runtime.DotNetCore21 = new Runtime('dotnetcore2.1', RuntimeFamily.DotNetCore);
Runtime.Go1x = new Runtime('go1.x', RuntimeFamily.Go);
Runtime.Ruby25 = new Runtime('ruby2.5', RuntimeFamily.Ruby, { supportsInlineCode: true });
Runtime.Provided = new Runtime('provided', RuntimeFamily.Other);
exports.Runtime = Runtime;
//# sourceMappingURL=data:application/json;base64,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